/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.knowledge_editor;

import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.graph.NodeVariableType;
import edu.cmu.tetrad.util.NamingProtocol;
import edu.cmu.tetrad.util.TetradSerializableExcluded;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;

public class KnowledgeModelNode
implements Node,
TetradSerializableExcluded {
    static final long serialVersionUID = 23L;
    private String name;
    private NodeVariableType nodeVariableType = NodeVariableType.DOMAIN;
    private int centerX;
    private int centerY;
    private final Map<String, Object> attributes = new HashMap<String, Object>();

    public KnowledgeModelNode(String varName) {
        if (varName == null) {
            throw new NullPointerException();
        }
        this.name = varName;
    }

    public static KnowledgeModelNode serializableInstance() {
        return new KnowledgeModelNode("X");
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (!NamingProtocol.isLegalName(name)) {
            throw new IllegalArgumentException(NamingProtocol.getProtocolDescription());
        }
        this.name = name;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.NO_TYPE;
    }

    @Override
    public void setNodeType(NodeType nodeType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getCenterX() {
        return this.centerX;
    }

    @Override
    public void setCenterX(int centerX) {
        this.centerX = centerX;
    }

    @Override
    public int getCenterY() {
        return this.centerY;
    }

    @Override
    public void setCenterY(int centerY) {
        this.centerY = centerY;
    }

    @Override
    public void setCenter(int centerX, int centerY) {
        this.centerX = centerX;
        this.centerY = centerY;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
    }

    @Override
    public Node like(String name) {
        return null;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public int compareTo(Node node) {
        String name = this.getName();
        String[] tokens1 = name.split(":");
        String _name = node.getName();
        String[] tokens2 = _name.split(":");
        if (tokens1.length == 1) {
            tokens1 = new String[]{tokens1[0], "0"};
        }
        if (tokens2.length == 1) {
            tokens2 = new String[]{tokens2[0], "0"};
        }
        int i1 = tokens1[1].compareTo(tokens2[1]);
        int i2 = tokens1[0].compareTo(tokens2[0]);
        if (i1 == 0) {
            return i2;
        }
        return i1;
    }

    @Override
    public NodeVariableType getNodeVariableType() {
        return this.nodeVariableType;
    }

    @Override
    public void setNodeVariableType(NodeVariableType nodeVariableType) {
        this.nodeVariableType = nodeVariableType;
    }

    @Override
    public Map<String, Object> getAllAttributes() {
        return this.attributes;
    }

    @Override
    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    @Override
    public void removeAttribute(String key) {
        this.attributes.remove(key);
    }

    @Override
    public void addAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }
}

