/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.knowledge_editor;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.data.KnowledgeGroup;
import edu.cmu.tetradapp.knowledge_editor.ListTransferable;
import edu.cmu.tetradapp.workbench.LayoutUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;

class OtherGroupsEditor
extends JPanel {
    private final Knowledge knowledge;
    private final List<String> variables;

    public OtherGroupsEditor(Knowledge knowledge, List<String> vars) {
        if (knowledge == null) {
            throw new NullPointerException("The given knowledge must not be null");
        }
        if (vars == null) {
            throw new NullPointerException("The given list of variables must not be null");
        }
        this.knowledge = knowledge;
        this.variables = new ArrayList<String>(vars);
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.add(this.buildComponent());
    }

    private Box buildComponent() {
        Box vBox = Box.createVerticalBox();
        VariableDragList varList = new VariableDragList(this.variables);
        varList.setBorder(null);
        JScrollPane pane = new JScrollPane(varList);
        pane.setPreferredSize(new Dimension(500, 50));
        vBox.add(pane);
        JButton addForbidden = new JButton("Add New Forbidden Group");
        addForbidden.addActionListener(e -> {
            KnowledgeGroup targetKnowledgeGroup = new KnowledgeGroup(2);
            this.knowledge.addKnowledgeGroup(targetKnowledgeGroup);
            this.rebuild();
        });
        JButton addRequired = new JButton("Add New Required Group");
        addRequired.addActionListener(e -> {
            KnowledgeGroup targetKnowledgeGroup = new KnowledgeGroup(1);
            this.knowledge.addKnowledgeGroup(targetKnowledgeGroup);
            this.rebuild();
        });
        Box buttons = Box.createHorizontalBox();
        buttons.add(addForbidden);
        buttons.add(Box.createHorizontalStrut(5));
        buttons.add(addRequired);
        buttons.add(Box.createHorizontalGlue());
        vBox.add(Box.createVerticalStrut(5));
        vBox.add(buttons);
        vBox.add(Box.createVerticalStrut(5));
        Box groupBoxes = Box.createVerticalBox();
        List<KnowledgeGroup> groups = this.knowledge.getKnowledgeGroups();
        for (int i = 0; i < groups.size(); ++i) {
            groupBoxes.add(this.buildGroupBox(i, groups.get(i)));
        }
        groupBoxes.add(Box.createVerticalGlue());
        JScrollPane pane2 = new JScrollPane(groupBoxes);
        pane2.setPreferredSize(new Dimension(500, 400));
        vBox.add(pane2);
        vBox.add(LayoutUtils.leftAlignJLabel(new JLabel("Use shift key to select multiple items.")));
        return vBox;
    }

    private Box buildGroupBox(int index, KnowledgeGroup group) {
        Box vBox = Box.createVerticalBox();
        vBox.setBorder(new EmptyBorder(10, 10, 10, 10));
        Box labelBox = Box.createHorizontalBox();
        JButton forbiddenButton = new JButton("Generate forbidden group");
        forbiddenButton.setFont(forbiddenButton.getFont().deriveFont(11.0f));
        forbiddenButton.setMargin(new Insets(3, 4, 3, 4));
        Set<String> fromGroup = group.getFromVariables();
        Set<String> toGroup = group.getToVariables();
        forbiddenButton.setEnabled(!fromGroup.isEmpty() && !toGroup.isEmpty());
        forbiddenButton.addActionListener(e -> {
            HashSet<String> toForbiddenGroup = new HashSet<String>();
            this.variables.forEach(var -> {
                if (!fromGroup.contains(var) && !toGroup.contains(var)) {
                    toForbiddenGroup.add((String)var);
                }
            });
            KnowledgeGroup targetKnowledgeGroup = new KnowledgeGroup(2, fromGroup, toForbiddenGroup);
            this.knowledge.addKnowledgeGroup(targetKnowledgeGroup);
            this.rebuild();
        });
        String title = group.getType() == 2 ? "Forbidden Group" : "Required Group";
        JButton remove = new JButton("Remove");
        remove.setFont(remove.getFont().deriveFont(11.0f));
        remove.setMargin(new Insets(3, 4, 3, 4));
        remove.addActionListener(e -> {
            this.knowledge.removeKnowledgeGroup(index);
            this.rebuild();
        });
        labelBox.add(new JLabel(title));
        if (group.getType() == 1) {
            labelBox.add(Box.createHorizontalGlue());
            labelBox.add(forbiddenButton);
        }
        labelBox.add(Box.createHorizontalGlue());
        labelBox.add(remove);
        vBox.add(labelBox);
        vBox.add(Box.createVerticalStrut(2));
        Box box = Box.createHorizontalBox();
        GroupVariableDragList fromList = new GroupVariableDragList(index, true);
        GroupVariableDragList toList = new GroupVariableDragList(index, false);
        JScrollPane pane1 = new JScrollPane(fromList);
        pane1.setPreferredSize(new Dimension(180, 50));
        JScrollPane pane2 = new JScrollPane(toList);
        pane2.setPreferredSize(new Dimension(180, 50));
        box.add(pane1);
        box.add(new Arrow());
        box.add(pane2);
        vBox.add(box);
        return vBox;
    }

    private void rebuild() {
        this.removeAll();
        this.add(this.buildComponent());
        this.revalidate();
        this.repaint();
    }

    private static void sort(DefaultListModel model) {
        Object[] elements = model.toArray();
        Arrays.sort(elements);
        model.clear();
        for (Object element : elements) {
            model.addElement(element);
        }
    }

    private static Set<String> getElementsInModel(DefaultListModel model) {
        HashSet<String> elements = new HashSet<String>();
        for (int i = 0; i < model.getSize(); ++i) {
            elements.add((String)model.getElementAt(i));
        }
        return elements;
    }

    private static boolean modelContains(Object o, DefaultListModel model) {
        for (int i = 0; i < model.getSize(); ++i) {
            if (!o.equals(model.getElementAt(i))) continue;
            return true;
        }
        return false;
    }

    private static class VariableDragList
    extends JList
    implements DragGestureListener,
    DropTargetListener {
        public VariableDragList(List<String> items) {
            this.setLayoutOrientation(2);
            this.setVisibleRowCount(0);
            this.setCellRenderer(new VariableRenderer());
            new DropTarget(this, 2, this, true);
            DragSource dragSource = DragSource.getDefaultDragSource();
            dragSource.createDefaultDragGestureRecognizer(this, 2, this);
            this.setModel(new DefaultListModel());
            for (String item : items) {
                ((DefaultListModel)this.getModel()).addElement(item);
            }
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            if (this.getSelectedIndex() == -1) {
                return;
            }
            List list = this.getSelectedValuesList();
            if (list == null) {
                this.getToolkit().beep();
            } else {
                ListTransferable transferable = new ListTransferable(list);
                dragGestureEvent.startDrag(DragSource.DefaultMoveDrop, transferable);
            }
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            dtde.getDropTargetContext().dropComplete(true);
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
        }
    }

    private class GroupVariableDragList
    extends JList
    implements DropTargetListener,
    DragSourceListener,
    DragGestureListener {
        private final int index;
        private final boolean from;

        public GroupVariableDragList(int index, boolean from) {
            this.index = index;
            this.from = from;
            this.setLayoutOrientation(2);
            this.setVisibleRowCount(0);
            this.setCellRenderer(new VariableRenderer());
            new DropTarget(this, 2, this, true);
            DragSource dragSource = DragSource.getDefaultDragSource();
            dragSource.createDefaultDragGestureRecognizer(this, 2, this);
            this.setModel(new DefaultListModel());
            KnowledgeGroup group = OtherGroupsEditor.this.knowledge.getKnowledgeGroups().get(index);
            Set<String> vars = from ? group.getFromVariables() : group.getToVariables();
            for (String item : vars) {
                ((DefaultListModel)this.getModel()).addElement(item);
            }
        }

        @Override
        public void drop(DropTargetDropEvent dtde) {
            try {
                Transferable tr = dtde.getTransferable();
                DataFlavor flavor = tr.getTransferDataFlavors()[0];
                DefaultListModel model = (DefaultListModel)this.getModel();
                boolean added = false;
                for (Object var : (List)tr.getTransferData(flavor)) {
                    if (OtherGroupsEditor.modelContains(var, model) || this.opposingContains((String)var)) continue;
                    model.addElement(var);
                    added = true;
                }
                if (!added) {
                    dtde.getDropTargetContext().dropComplete(false);
                    return;
                }
                OtherGroupsEditor.sort(model);
                KnowledgeGroup group = OtherGroupsEditor.this.knowledge.getKnowledgeGroups().get(this.index);
                KnowledgeGroup g = this.from ? new KnowledgeGroup(group.getType(), OtherGroupsEditor.getElementsInModel(model), group.getToVariables()) : new KnowledgeGroup(group.getType(), group.getFromVariables(), OtherGroupsEditor.getElementsInModel(model));
                try {
                    OtherGroupsEditor.this.knowledge.setKnowledgeGroup(this.index, g);
                    dtde.getDropTargetContext().dropComplete(true);
                    OtherGroupsEditor.this.rebuild();
                }
                catch (IllegalArgumentException ex) {
                    JOptionPane.showMessageDialog(OtherGroupsEditor.this, ex.getMessage());
                    OtherGroupsEditor.this.rebuild();
                    dtde.getDropTargetContext().dropComplete(false);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dsde) {
            if (dsde.getDropSuccess()) {
                Transferable t = dsde.getDragSourceContext().getTransferable();
                try {
                    List list = (List)t.getTransferData(ListTransferable.DATA_FLAVOR);
                    DefaultListModel model = (DefaultListModel)this.getModel();
                    for (Object o : list) {
                        model.removeElement(o);
                    }
                    KnowledgeGroup group = OtherGroupsEditor.this.knowledge.getKnowledgeGroups().get(this.index);
                    KnowledgeGroup g = this.from ? new KnowledgeGroup(group.getType(), OtherGroupsEditor.getElementsInModel(model), group.getToVariables()) : new KnowledgeGroup(group.getType(), group.getFromVariables(), OtherGroupsEditor.getElementsInModel(model));
                    try {
                        OtherGroupsEditor.this.knowledge.setKnowledgeGroup(this.index, g);
                        OtherGroupsEditor.this.rebuild();
                    }
                    catch (IllegalArgumentException ex) {
                        JOptionPane.showMessageDialog(OtherGroupsEditor.this, ex.getMessage());
                        OtherGroupsEditor.this.rebuild();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            if (this.getSelectedIndex() == -1) {
                return;
            }
            List list = this.getSelectedValuesList();
            if (list == null) {
                this.getToolkit().beep();
            } else {
                ListTransferable transferable = new ListTransferable(list);
                dge.startDrag(DragSource.DefaultMoveDrop, transferable, this);
            }
        }

        private boolean opposingContains(String o) {
            KnowledgeGroup group = OtherGroupsEditor.this.knowledge.getKnowledgeGroups().get(this.index);
            Set<String> opposite = this.from ? group.getToVariables() : group.getFromVariables();
            return opposite.contains(o);
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
        }

        @Override
        public void dragEnter(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragOver(DragSourceDragEvent dsde) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent dsde) {
        }

        @Override
        public void dragExit(DragSourceEvent dse) {
        }
    }

    private static class Arrow
    extends JPanel {
        private final Color color;

        public Arrow() {
            Color b = Color.BLACK;
            this.color = new Color(b.getRed(), b.getGreen(), b.getBlue(), 150);
            this.setMinimumSize(new Dimension(22, 22));
        }

        @Override
        public void paintComponent(Graphics g) {
            Dimension size = this.getSize();
            if (size.width < 21 || size.height < 21) {
                return;
            }
            int mid = size.height / 2;
            g.setColor(this.color);
            int end = size.width - 15;
            g.fillRect(5, mid, end - 5, 2);
            g.fillPolygon(new int[]{end, end + 10, end}, new int[]{mid + 10, mid, mid - 10}, 3);
        }
    }

    private static class VariableRenderer
    extends DefaultListCellRenderer {
        private final Color fillColor = new Color(153, 204, 204);
        private final Color selectedFillColor = new Color(255, 204, 102);

        public VariableRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(0);
            this.setBorder(new CompoundBorder(new MatteBorder(2, 2, 2, 2, Color.WHITE), new LineBorder(Color.BLACK)));
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(" " + value + " ");
            if (isSelected) {
                this.setForeground(Color.BLACK);
                this.setBackground(this.selectedFillColor);
            } else {
                this.setForeground(Color.BLACK);
                this.setBackground(this.fillColor);
            }
            return this;
        }
    }
}

