/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataModelList;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.data.IndependenceFacts;
import edu.cmu.tetrad.data.TimeSeriesData;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.search.ImpliedOrientation;
import edu.cmu.tetrad.session.ParamsResettable;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetrad.util.Unmarshallable;
import edu.cmu.tetradapp.model.AlgorithmRunner;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.IndependenceFactsModel;
import edu.cmu.tetradapp.model.KnowledgeBoxModel;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractAlgorithmRunner
implements AlgorithmRunner,
ParamsResettable,
Unmarshallable {
    static final long serialVersionUID = 23L;
    private DataWrapper dataWrapper;
    private String name;
    private Parameters params;
    private transient DataModel dataModel;
    private Graph sourceGraph;
    private Graph resultGraph = new EdgeListGraph();
    private Graph externalGraph;
    private List<Graph> graphs;
    private Map<String, String> allParamSettings;
    final Map<String, String> paramSettings = new LinkedHashMap<String, String>();

    public AbstractAlgorithmRunner(DataWrapper dataWrapper, Parameters params, KnowledgeBoxModel knowledgeBoxModel) {
        if (dataWrapper == null) {
            throw new NullPointerException();
        }
        if (params == null) {
            throw new NullPointerException();
        }
        this.params = params;
        this.sourceGraph = dataWrapper.getSourceGraph();
        DataModelList dataSource = dataWrapper.getDataModelList();
        this.dataWrapper = dataWrapper;
        if (knowledgeBoxModel == null) {
            this.getParams().set("knowledge", (Object)dataWrapper.getKnowledge());
        } else {
            this.getParams().set("knowledge", (Object)knowledgeBoxModel.getKnowledge());
        }
        List<String> names = dataSource.getVariableNames();
        this.transferVarNamesToParams(names);
    }

    public AbstractAlgorithmRunner(DataWrapper dataWrapper, Parameters params, KnowledgeBoxModel knowledgeBoxModel, IndependenceFactsModel facts) {
        if (dataWrapper == null) {
            throw new NullPointerException();
        }
        if (params == null) {
            throw new NullPointerException();
        }
        this.params = params;
        this.sourceGraph = dataWrapper.getSourceGraph();
        DataModel dataSource = this.getSelectedDataModel(dataWrapper);
        this.dataWrapper = dataWrapper;
        if (knowledgeBoxModel == null) {
            this.getParams().set("knowledge", (Object)dataWrapper.getKnowledge());
        } else {
            this.getParams().set("knowledge", (Object)knowledgeBoxModel.getKnowledge());
        }
        this.getParams().set("independenceFacts", (Object)facts.getFacts());
        List<String> names = dataSource.getVariableNames();
        this.transferVarNamesToParams(names);
    }

    public AbstractAlgorithmRunner(DataWrapper dataWrapper, Parameters params) {
        if (dataWrapper == null) {
            throw new NullPointerException();
        }
        if (params == null) {
            throw new NullPointerException();
        }
        this.params = params;
        this.sourceGraph = dataWrapper.getSourceGraph();
        DataModel dataSource = this.getSelectedDataModel(dataWrapper);
        this.dataWrapper = dataWrapper;
        List<String> names = dataSource.getVariableNames();
        this.transferVarNamesToParams(names);
    }

    public AbstractAlgorithmRunner(Graph sourceGraph, Parameters params) {
        if (sourceGraph == null) {
            throw new NullPointerException("Source graph must not be null.");
        }
        if (params == null) {
            throw new NullPointerException("Parameters must not be null.");
        }
        this.params = params;
        List<String> names = this.measuredNames(sourceGraph);
        this.transferVarNamesToParams(names);
        this.sourceGraph = sourceGraph;
    }

    public AbstractAlgorithmRunner(Graph graph, Parameters params, KnowledgeBoxModel knowledgeBoxModel) {
        this(graph, params);
        if (knowledgeBoxModel != null) {
            this.getParams().set("knowledge", (Object)knowledgeBoxModel.getKnowledge());
        }
    }

    public AbstractAlgorithmRunner(Parameters params, Graph ... graphs) {
        this.graphs = Arrays.asList(graphs);
        this.params = params;
    }

    public AbstractAlgorithmRunner(Parameters params, KnowledgeBoxModel knowledgeBoxModel, Graph ... graphs) {
        this.graphs = Arrays.asList(graphs);
        this.params = params;
        if (knowledgeBoxModel != null) {
            this.getParams().set("knowledge", (Object)knowledgeBoxModel.getKnowledge());
        }
    }

    public AbstractAlgorithmRunner(IndependenceFactsModel model, Parameters params, KnowledgeBoxModel knowledgeBoxModel) {
        if (model == null) {
            throw new NullPointerException();
        }
        if (params == null) {
            throw new NullPointerException();
        }
        this.params = params;
        IndependenceFacts dataSource = model.getFacts();
        if (knowledgeBoxModel != null) {
            this.getParams().set("knowledge", (Object)knowledgeBoxModel.getKnowledge());
        }
        List<String> names = dataSource.getVariableNames();
        this.transferVarNamesToParams(names);
        this.dataModel = dataSource;
    }

    public AbstractAlgorithmRunner(Graph graph, Parameters params, KnowledgeBoxModel knowledgeBoxModel, IndependenceFacts facts) {
        this(graph, params);
        if (knowledgeBoxModel != null) {
            this.getParams().set("knowledge", (Object)knowledgeBoxModel.getKnowledge());
        }
        if (facts != null) {
            this.getParams().set("independenceFacts", (Object)facts);
        }
    }

    public final Graph getResultGraph() {
        return this.resultGraph;
    }

    @Override
    public boolean supportsKnowledge() {
        return false;
    }

    @Override
    public ImpliedOrientation getMeekRules() {
        return null;
    }

    @Override
    public void setExternalGraph(Graph graph) {
        this.externalGraph = graph;
    }

    @Override
    public Graph getExternalGraph() {
        return this.externalGraph;
    }

    @Override
    public abstract String getAlgorithmName();

    @Override
    public final Graph getSourceGraph() {
        return this.sourceGraph;
    }

    @Override
    public final DataModel getDataModel() {
        if (this.dataWrapper != null) {
            DataModelList dataModelList = this.dataWrapper.getDataModelList();
            if (dataModelList.size() == 1) {
                return dataModelList.get(0);
            }
            return dataModelList;
        }
        if (this.dataModel != null) {
            return this.dataModel;
        }
        return null;
    }

    final DataModelList getDataModelList() {
        if (this.dataWrapper == null) {
            return null;
        }
        return this.dataWrapper.getDataModelList();
    }

    public final void setResultGraph(Graph resultGraph) {
        this.resultGraph = resultGraph;
    }

    @Override
    public final Parameters getParams() {
        return this.params;
    }

    @Override
    public Object getResettableParams() {
        return this.getParams();
    }

    @Override
    public void resetParams(Object params) {
        this.params = (Parameters)params;
    }

    private DataModel getSelectedDataModel(DataWrapper dataWrapper) {
        DataModelList dataModelList = dataWrapper.getDataModelList();
        if (dataModelList.size() > 1) {
            return dataModelList;
        }
        DataModel dataModel = dataWrapper.getSelectedDataModel();
        if (dataModel instanceof DataSet) {
            DataSet dataSet = (DataSet)dataModel;
            if (dataSet.isDiscrete()) {
                return dataSet;
            }
            if (dataSet.isContinuous()) {
                return dataSet;
            }
            if (dataSet.isMixed()) {
                return dataSet;
            }
            throw new IllegalArgumentException("<html>This data set contains a mixture of discrete and continuous <br>columns; there are no algorithm in Tetrad currently to <br>search over such data sets.</html>");
        }
        if (dataModel instanceof ICovarianceMatrix) {
            return dataModel;
        }
        if (dataModel instanceof TimeSeriesData) {
            return dataModel;
        }
        throw new IllegalArgumentException("Unexpected dataModel source: " + dataModel);
    }

    private List<String> measuredNames(Graph graph) {
        ArrayList<String> names = new ArrayList<String>();
        for (Node node : graph.getNodes()) {
            if (node.getNodeType() != NodeType.MEASURED) continue;
            names.add(node.getName());
        }
        return names;
    }

    private void transferVarNamesToParams(List<String> names) {
        this.getParams().set("varNames", (Object)names);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public List<Graph> getGraphs() {
        return this.graphs;
    }

    @Override
    public Map<String, String> getParamSettings() {
        this.paramSettings.put("Algorithm", this.getAlgorithmName());
        return this.paramSettings;
    }

    @Override
    public Map<String, String> getAllParamSettings() {
        return this.allParamSettings;
    }

    @Override
    public void setAllParamSettings(Map<String, String> allParamSettings) {
        this.allParamSettings = allParamSettings;
    }
}

