/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.BoxDataSet;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DoubleDataBox;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.IndTestChiSquare;
import edu.cmu.tetrad.search.IndTestFisherZ;
import edu.cmu.tetrad.search.IndTestFisherZGeneralizedInverse;
import edu.cmu.tetrad.search.IndTestGSquare;
import edu.cmu.tetrad.search.IndTestRegression;
import edu.cmu.tetrad.search.IndTestType;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.MarkovBlanketSearchRunner;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractMBSearchRunner
extends DataWrapper
implements MarkovBlanketSearchRunner {
    static final long serialVersionUID = 23L;
    private DataSet dataModel;
    private List<Node> variables;
    private final DataSet source;
    private final Parameters params;
    private String searchName;

    AbstractMBSearchRunner(DataModel source, Parameters params) {
        super(AbstractMBSearchRunner.castData(source));
        if (source == null) {
            throw new NullPointerException("The source data was null.");
        }
        if (params == null) {
            throw new NullPointerException("Search params were null.");
        }
        this.params = params;
        this.source = (DataSet)source;
    }

    @Override
    public Parameters getParams() {
        return this.params;
    }

    @Override
    public DataSet getDataModelForMarkovBlanket() {
        return this.dataModel;
    }

    @Override
    public List<Node> getMarkovBlanket() {
        return this.variables;
    }

    @Override
    public DataSet getSource() {
        return this.source;
    }

    @Override
    public void setSearchName(String n) {
        this.searchName = n;
    }

    @Override
    public String getSearchName() {
        if (this.searchName == null) {
            return "Markov Blanket Search";
        }
        return this.searchName;
    }

    void validate() {
        if (this.source.getNumColumns() == 0 || this.source.getNumRows() == 0) {
            throw new IllegalStateException("Cannot run algorithm on an empty data set.");
        }
    }

    void setSearchResults(List<Node> nodes) {
        if (nodes == null) {
            throw new NullPointerException("nodes were null.");
        }
        this.variables = new ArrayList<Node>(nodes);
        this.dataModel = nodes.isEmpty() ? new BoxDataSet(new DoubleDataBox(this.source.getNumRows(), nodes.size()), nodes) : this.source.subsetColumns(nodes);
        this.setDataModel(this.dataModel);
    }

    IndependenceTest getIndependenceTest() {
        IndTestType type = (IndTestType)this.params.get("indTestType", IndTestType.FISHER_Z);
        if (this.source.isContinuous() || this.source.getNumColumns() == 0) {
            if (IndTestType.FISHER_Z == type) {
                return new IndTestFisherZ(this.source, this.params.getDouble("alpha", 0.001));
            }
            if (IndTestType.FISHER_ZD == type) {
                return new IndTestFisherZGeneralizedInverse(this.source, this.params.getDouble("alpha", 0.001));
            }
            if (IndTestType.LINEAR_REGRESSION == type) {
                return new IndTestRegression(this.source, this.params.getDouble("alpha", 0.001));
            }
            this.params.set("indTestType", (Object)IndTestType.FISHER_Z);
            return new IndTestFisherZ(this.source, this.params.getDouble("alpha", 0.001));
        }
        if (this.source.isDiscrete()) {
            if (IndTestType.G_SQUARE == type) {
                return new IndTestGSquare(this.source, this.params.getDouble("alpha", 0.001));
            }
            if (IndTestType.CHI_SQUARE != type) {
                this.params.set("indTestType", (Object)IndTestType.CHI_SQUARE);
            }
            return new IndTestChiSquare(this.source, this.params.getDouble("alpha", 0.001));
        }
        throw new IllegalStateException("Cannot find Independence for Data source.");
    }

    private static DataSet castData(DataModel model) {
        if (model instanceof DataSet) {
            return (DataSet)model;
        }
        throw new IllegalStateException("The data model must be a rectangular data set.");
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.params == null) {
            throw new NullPointerException();
        }
        if (this.source == null) {
            throw new NullPointerException();
        }
    }
}

