/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.Clusters;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataModelList;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.data.TimeSeriesData;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.session.ParamsResettable;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.MeasurementModelWrapper;
import edu.cmu.tetradapp.model.MimRunner;
import java.util.List;

public abstract class AbstractMimRunner
implements MimRunner,
ParamsResettable {
    static final long serialVersionUID = 23L;
    private String name;
    private final transient DataModel dataModel;
    private Parameters params;
    private Clusters clusters = new Clusters();
    private Graph sourceGraph;
    private Graph resultGraph;
    private Graph structureGraph;
    private DataWrapper dataWrapper;

    AbstractMimRunner(DataWrapper dataWrapper, Clusters clusters, Parameters params) {
        if (dataWrapper == null) {
            throw new NullPointerException();
        }
        if (params == null) {
            throw new NullPointerException();
        }
        this.dataWrapper = dataWrapper;
        this.params = params;
        this.setClusters(clusters);
        this.sourceGraph = dataWrapper.getSourceGraph();
        DataModel data = this.getDataModel(dataWrapper);
        this.getParams().set("knowledge", (Object)dataWrapper.getKnowledge());
        List<String> names = data.getVariableNames();
        this.transferVarNamesToParams(names);
        this.dataModel = data;
    }

    AbstractMimRunner(MeasurementModelWrapper wrapper, Clusters clusters, Parameters params) {
        if (wrapper == null) {
            throw new NullPointerException();
        }
        if (params == null) {
            throw new NullPointerException();
        }
        this.params = params;
        this.setClusters(clusters);
        DataSet data = wrapper.getData();
        List<String> names = data.getVariableNames();
        this.transferVarNamesToParams(names);
        this.dataModel = data;
    }

    AbstractMimRunner(MimRunner runner, Parameters params) {
        if (runner == null) {
            throw new NullPointerException();
        }
        this.params = params;
        this.params.set("clusters", (Object)runner.getClusters());
        this.sourceGraph = runner.getSourceGraph();
        DataModel dataSource = runner.getData();
        List<String> names = dataSource.getVariableNames();
        this.transferVarNamesToParams(names);
        this.dataModel = dataSource;
    }

    @Override
    public final Graph getResultGraph() {
        return this.resultGraph;
    }

    @Override
    public Clusters getClusters() {
        return this.clusters;
    }

    @Override
    public Graph getStructureGraph() {
        return this.structureGraph;
    }

    @Override
    public Graph getFullGraph() {
        return null;
    }

    @Override
    public final Graph getSourceGraph() {
        return this.sourceGraph;
    }

    @Override
    public final DataModel getData() {
        if (this.dataWrapper != null) {
            DataModelList dataModelList = this.dataWrapper.getDataModelList();
            if (dataModelList.size() == 1) {
                return dataModelList.get(0);
            }
            return dataModelList;
        }
        if (this.dataModel != null) {
            return this.dataModel;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public final Parameters getParams() {
        return this.params;
    }

    @Override
    public void resetParams(Object params) {
        this.params = (Parameters)params;
    }

    @Override
    public Object getResettableParams() {
        return this.params;
    }

    void setResultGraph(Graph graph) {
        this.resultGraph = graph;
    }

    void setClusters(Clusters clusters) {
        if (clusters == null) {
            throw new NullPointerException();
        }
        this.clusters = clusters;
    }

    void setStructureGraph(Graph graph) {
        this.structureGraph = graph;
    }

    private DataModel getDataModel(DataWrapper dataWrapper) {
        DataModel dataModel = dataWrapper.getSelectedDataModel();
        if (dataModel instanceof DataModelList) {
            DataModelList dataModelList = (DataModelList)dataModel;
            dataModel = dataModelList.getSelectedModel();
        }
        if (dataModel instanceof DataSet) {
            DataSet dataSet = (DataSet)dataModel;
            if (dataSet.isDiscrete()) {
                return dataSet;
            }
            if (dataSet.isContinuous()) {
                return dataSet;
            }
            throw new IllegalArgumentException("<html>This dataModel set contains a mixture of discrete and continuous <br>columns; there are no algorithm in Tetrad currently to <br>search over such data sets.</html>");
        }
        if (dataModel instanceof ICovarianceMatrix) {
            return dataModel;
        }
        if (dataModel instanceof TimeSeriesData) {
            return dataModel;
        }
        throw new IllegalArgumentException("Unexpected dataModel source: " + dataModel);
    }

    private void transferVarNamesToParams(List<String> names) {
        this.getParams().set("varNames", (Object)names);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }
}

