/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.bayes.BayesIm;
import edu.cmu.tetrad.bayes.BayesPm;
import edu.cmu.tetrad.bayes.MlBayesEstimator;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataModelList;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataUtils;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.session.SessionModel;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetradapp.model.BayesImWrapper;
import edu.cmu.tetradapp.model.BayesPmWrapper;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.PcRunner;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;

public class BayesEstimatorWrapper
implements SessionModel {
    static final long serialVersionUID = 23L;
    private String name;
    private BayesIm bayesIm;
    private DataSet dataSet;
    private final DataWrapper dataWrapper;
    private int numModels = 1;
    private int modelIndex;
    private final List<BayesIm> bayesIms = new ArrayList<BayesIm>();

    public BayesEstimatorWrapper(DataWrapper dataWrapper, BayesPmWrapper bayesPmWrapper) {
        if (dataWrapper == null) {
            throw new NullPointerException("BayesDataWrapper must not be null.");
        }
        this.dataWrapper = dataWrapper;
        if (bayesPmWrapper == null) {
            throw new NullPointerException("BayesPmWrapper must not be null");
        }
        DataModelList dataModel = dataWrapper.getDataModelList();
        if (dataModel != null) {
            for (int i = 0; i < dataWrapper.getDataModelList().size(); ++i) {
                DataModel model = dataWrapper.getDataModelList().get(i);
                DataSet dataSet = (DataSet)model;
                bayesPmWrapper.setModelIndex(i);
                BayesPm bayesPm = bayesPmWrapper.getBayesPm();
                this.estimate(dataSet, bayesPm);
                this.bayesIms.add(this.bayesIm);
            }
        } else {
            throw new IllegalArgumentException("Data must consist of discrete data sets.");
        }
        this.bayesIm = this.bayesIms.get(0);
        this.log(this.bayesIm);
        this.name = bayesPmWrapper.getName();
        this.numModels = this.bayesIms.size();
        this.modelIndex = 0;
        this.bayesIm = this.bayesIms.get(this.modelIndex);
        DataModel model = dataModel.get(this.modelIndex);
        this.dataSet = (DataSet)model;
    }

    public BayesEstimatorWrapper(DataWrapper dataWrapper, BayesImWrapper bayesImWrapper) {
        this(dataWrapper, new BayesPmWrapper(bayesImWrapper));
    }

    public static PcRunner serializableInstance() {
        return PcRunner.serializableInstance();
    }

    public BayesIm getEstimatedBayesIm() {
        return this.bayesIm;
    }

    public void setBayesIm(BayesIm bayesIm) {
        this.bayesIms.clear();
        this.bayesIms.add(bayesIm);
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public Graph getGraph() {
        return this.bayesIm.getBayesPm().getDag();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public int getNumModels() {
        return this.numModels;
    }

    public void setNumModels(int numModels) {
        this.numModels = numModels;
    }

    public int getModelIndex() {
        return this.modelIndex;
    }

    public void setModelIndex(int modelIndex) {
        this.modelIndex = modelIndex;
        this.bayesIm = this.bayesIms.get(modelIndex);
        DataModelList dataModel = this.dataWrapper.getDataModelList();
        this.dataSet = (DataSet)dataModel.get(modelIndex);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.bayesIm == null) {
            throw new NullPointerException();
        }
    }

    private void log(BayesIm im) {
        TetradLogger.getInstance().log("info", "ML estimated Bayes IM.");
        TetradLogger.getInstance().log("im", im.toString());
    }

    private void estimate(DataSet dataSet, BayesPm bayesPm) {
        Graph graph = bayesPm.getDag();
        for (Node o : graph.getNodes()) {
            Node node = o;
            if (node.getNodeType() != NodeType.LATENT) continue;
            throw new IllegalArgumentException("Estimation of Bayes IM's with latents is not supported.");
        }
        if (DataUtils.containsMissingValue(dataSet)) {
            throw new IllegalArgumentException("Please remove or impute missing values.");
        }
        try {
            MlBayesEstimator estimator = new MlBayesEstimator();
            this.bayesIm = estimator.estimate(bayesPm, dataSet);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
            throw new RuntimeException("Value assignments between Bayes PM and discrete data set do not match.");
        }
    }
}

