/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.algcomparison.simulation.BayesNetSimulation;
import edu.cmu.tetrad.bayes.BayesIm;
import edu.cmu.tetrad.bayes.BayesPm;
import edu.cmu.tetrad.bayes.MlBayesIm;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.session.SessionModel;
import edu.cmu.tetrad.util.Memorable;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetradapp.model.ApproximateUpdaterWrapper;
import edu.cmu.tetradapp.model.BayesPmWrapper;
import edu.cmu.tetradapp.model.CptInvariantUpdaterWrapper;
import edu.cmu.tetradapp.model.RowSummingExactWrapper;
import edu.cmu.tetradapp.model.Simulation;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;

public class BayesImWrapper
implements SessionModel,
Memorable {
    static final long serialVersionUID = 23L;
    private int numModels = 1;
    private int modelIndex;
    private String modelSourceName;
    private String name;
    private List<BayesIm> bayesIms;

    public BayesImWrapper(BayesPmWrapper bayesPmWrapper, BayesImWrapper oldBayesImwrapper, Parameters params) {
        if (bayesPmWrapper == null) {
            throw new NullPointerException("BayesPmWrapper must not be null.");
        }
        if (params == null) {
            throw new NullPointerException("Parameters must not be null.");
        }
        BayesPm bayesPm = new BayesPm(bayesPmWrapper.getBayesPm());
        BayesIm oldBayesIm = oldBayesImwrapper.getBayesIm();
        if (params.getString("initializationMode", "manualRetain").equals("manualRetain")) {
            this.setBayesIm(bayesPm, oldBayesIm, 0);
        } else if (params.getString("initializationMode", "manualRetain").equals("randomRetain")) {
            this.setBayesIm(bayesPm, oldBayesIm, 1);
        } else if (params.getString("initializationMode", "manualRetain").equals("randomOverwrite")) {
            this.setBayesIm(new MlBayesIm(bayesPm, 1));
        }
    }

    private void setBayesIm(BayesPm bayesPm, BayesIm oldBayesIm, int manual) {
        this.bayesIms = new ArrayList<BayesIm>();
        this.bayesIms.add(new MlBayesIm(bayesPm, oldBayesIm, manual));
    }

    public BayesImWrapper(Simulation simulation) {
        List<BayesIm> bayesIms = null;
        if (simulation == null) {
            throw new NullPointerException("The Simulation box does not contain a simulation.");
        }
        edu.cmu.tetrad.algcomparison.simulation.Simulation _simulation = simulation.getSimulation();
        if (_simulation == null) {
            throw new NullPointerException("No data sets have been simulated.");
        }
        if (!(_simulation instanceof BayesNetSimulation)) {
            throw new IllegalArgumentException("That was not a discrete Bayes net simulation.");
        }
        bayesIms = ((BayesNetSimulation)_simulation).getBayesIms();
        if (bayesIms == null) {
            throw new NullPointerException("It looks like you have not done a simulation.");
        }
        this.bayesIms = bayesIms;
        this.numModels = simulation.getDataModelList().size();
        this.modelIndex = 0;
        this.modelSourceName = simulation.getName();
    }

    public BayesImWrapper(RowSummingExactWrapper wrapper, Parameters parameters) {
        if (wrapper == null) {
            throw new NullPointerException();
        }
        this.setBayesIm(wrapper.getBayesUpdater().getUpdatedBayesIm());
    }

    public BayesImWrapper(CptInvariantUpdaterWrapper wrapper, Parameters parameters) {
        if (wrapper == null) {
            throw new NullPointerException();
        }
        this.setBayesIm(wrapper.getBayesUpdater().getUpdatedBayesIm());
    }

    public BayesImWrapper(ApproximateUpdaterWrapper wrapper, Parameters parameters) {
        if (wrapper == null) {
            throw new NullPointerException();
        }
        this.setBayesIm(wrapper.getBayesUpdater().getUpdatedBayesIm());
    }

    public BayesImWrapper(BayesPmWrapper bayesPmWrapper, Parameters params) {
        if (bayesPmWrapper == null) {
            throw new NullPointerException("BayesPmWrapper must not be null.");
        }
        if (params == null) {
            throw new NullPointerException("Parameters must not be null.");
        }
        BayesPm bayesPm = new BayesPm(bayesPmWrapper.getBayesPm());
        if (params.getString("initializationMode", "manualRetain").equals("manualRetain")) {
            this.setBayesIm(new MlBayesIm(bayesPm));
        } else if (params.getString("initializationMode", "manualRetain").equals("randomRetain")) {
            this.setBayesIm(new MlBayesIm(bayesPm, 1));
        } else if (params.getString("initializationMode", "manualRetain").equals("randomOverwrite")) {
            this.setBayesIm(new MlBayesIm(bayesPm, 1));
        }
    }

    public BayesImWrapper(BayesIm bayesIm) {
        if (bayesIm == null) {
            throw new NullPointerException("Bayes IM must not be null.");
        }
        this.setBayesIm(new MlBayesIm(bayesIm));
    }

    public static BayesImWrapper serializableInstance() {
        return new BayesImWrapper(BayesPmWrapper.serializableInstance(), new Parameters());
    }

    public BayesIm getBayesIm() {
        return this.bayesIms.get(this.getModelIndex());
    }

    public Graph getGraph() {
        return this.getBayesIm().getBayesPm().getDag();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public Graph getSourceGraph() {
        return this.getGraph();
    }

    public Graph getResultGraph() {
        return this.getGraph();
    }

    public List<String> getVariableNames() {
        return this.getGraph().getNodeNames();
    }

    public List<Node> getVariables() {
        return this.getGraph().getNodes();
    }

    public void setBayesIm(BayesIm bayesIm) {
        this.bayesIms = new ArrayList<BayesIm>();
        this.bayesIms.add(bayesIm);
    }

    public int getNumModels() {
        return this.numModels;
    }

    public int getModelIndex() {
        return this.modelIndex;
    }

    public String getModelSourceName() {
        return this.modelSourceName;
    }

    public void setModelIndex(int modelIndex) {
        this.modelIndex = modelIndex;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
    }
}

