/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.bayes.BayesIm;
import edu.cmu.tetrad.bayes.BayesPm;
import edu.cmu.tetrad.bayes.MlBayesImObs;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.session.SessionModel;
import edu.cmu.tetrad.util.Memorable;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetradapp.model.BayesPmWrapper;
import edu.cmu.tetradapp.model.PcRunner;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;

public class BayesImWrapperObs
implements SessionModel,
Memorable {
    static final long serialVersionUID = 23L;
    private String name;
    private BayesIm bayesIm;

    public BayesImWrapperObs(BayesPmWrapper bayesPmWrapper, Parameters params) {
        if (bayesPmWrapper == null) {
            throw new NullPointerException("BayesPmWrapper must not be null.");
        }
        if (params == null) {
            throw new NullPointerException("Parameters must not be null.");
        }
        BayesPm bayesPm = new BayesPm(bayesPmWrapper.getBayesPm());
        if (params.getString("initializationMode", "manualRetain").equals("manualRetain")) {
            this.bayesIm = new MlBayesImObs(bayesPm);
        } else if (params.getString("initializationMode", "manualRetain").equals("randomRetain")) {
            this.bayesIm = new MlBayesImObs(bayesPm, 1);
        } else if (params.getString("initializationMode", "manualRetain").equals("randomOverwrite")) {
            this.bayesIm = new MlBayesImObs(bayesPm, 1);
        }
        this.log(this.bayesIm);
    }

    public static PcRunner serializableInstance() {
        return PcRunner.serializableInstance();
    }

    public BayesIm getBayesIm() {
        return this.bayesIm;
    }

    public Graph getGraph() {
        return this.bayesIm.getBayesPm().getDag();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    private void log(BayesIm im) {
        TetradLogger.getInstance().log("info", "Maximum likelihood Bayes IM: Observed Variables Only");
        TetradLogger.getInstance().log("im", im.toString());
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.bayesIm == null) {
            throw new NullPointerException();
        }
    }

    public Graph getSourceGraph() {
        return this.getGraph();
    }

    public Graph getResultGraph() {
        return this.getGraph();
    }

    public List<String> getVariableNames() {
        return this.getGraph().getNodeNames();
    }

    public List<Node> getVariables() {
        return this.getGraph().getNodes();
    }

    public void setBayesIm(BayesIm bayesIm) {
        this.bayesIm = bayesIm;
    }
}

