/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.algcomparison.simulation.BayesNetSimulation;
import edu.cmu.tetrad.bayes.BayesIm;
import edu.cmu.tetrad.bayes.BayesPm;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DiscreteVariable;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.session.SessionModel;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetradapp.model.AlgorithmRunner;
import edu.cmu.tetradapp.model.BayesEstimatorWrapper;
import edu.cmu.tetradapp.model.BayesImWrapper;
import edu.cmu.tetradapp.model.DagWrapper;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.GraphSource;
import edu.cmu.tetradapp.model.GraphWrapper;
import edu.cmu.tetradapp.model.Simulation;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class BayesPmWrapper
implements SessionModel {
    static final long serialVersionUID = 23L;
    private int numModels;
    private int modelIndex;
    private String modelSourceName;
    private String name;
    private List<BayesPm> bayesPms;

    public BayesPmWrapper(Graph graph, Parameters params) {
        this.numModels = 1;
        if (graph == null) {
            throw new NullPointerException("Graph must not be null.");
        }
        if (params.getString("initializationMode", "trinary").equals("trinary")) {
            int upperBound = 3;
            int lowerBound = 3;
            this.setBayesPm(graph, lowerBound, upperBound);
        } else if (params.getString("initializationMode", "trinary").equals("range")) {
            int lowerBound = params.getInt("minCategories", 2);
            int upperBound = params.getInt("maxCategories", 4);
            this.setBayesPm(graph, lowerBound, upperBound);
        } else {
            throw new IllegalStateException("Unrecognized type.");
        }
    }

    private void setBayesPm(Graph graph, int lowerBound, int upperBound) {
        BayesPm b = new BayesPm(graph, lowerBound, upperBound);
        this.setBayesPm(b);
    }

    private void setBayesPm(BayesPm b) {
        this.bayesPms = new ArrayList<BayesPm>();
        this.bayesPms.add(b);
    }

    public BayesPmWrapper(Simulation simulation) {
        this.numModels = 1;
        if (simulation == null) {
            throw new NullPointerException("The Simulation box does not contain a simulation.");
        }
        edu.cmu.tetrad.algcomparison.simulation.Simulation _simulation = simulation.getSimulation();
        if (_simulation == null) {
            throw new NullPointerException("No data sets have been simulated.");
        }
        if (!(_simulation instanceof BayesNetSimulation)) {
            throw new IllegalArgumentException("That was not a discrete Bayes net simulation.");
        }
        List<BayesIm> bayesIms = ((BayesNetSimulation)_simulation).getBayesIms();
        if (bayesIms == null) {
            throw new NullPointerException("It looks like you have not done a simulation.");
        }
        ArrayList<BayesPm> bayesPms = new ArrayList<BayesPm>();
        for (BayesIm bayesIm : bayesIms) {
            bayesPms.add(bayesIm.getBayesPm());
        }
        this.bayesPms = bayesPms;
        this.numModels = simulation.getDataModelList().size();
        this.modelIndex = 0;
        this.modelSourceName = simulation.getName();
    }

    public BayesPmWrapper(Dag graph, BayesPm bayesPm, Parameters params) {
        this.numModels = 1;
        if (graph == null) {
            throw new NullPointerException("Graph must not be null.");
        }
        if (bayesPm == null) {
            throw new NullPointerException("BayesPm must not be null");
        }
        if (params.getString("initializationMode", "trinary").equals("trinary")) {
            int upperBound = 3;
            int lowerBound = 3;
            this.setBayesPm(new BayesPm(graph, bayesPm, lowerBound, upperBound));
        } else if (params.getString("initializationMode", "trinary").equals("range")) {
            int lowerBound = params.getInt("minCategories", 2);
            int upperBound = params.getInt("maxCategories", 4);
            this.setBayesPm(graph, lowerBound, upperBound);
        } else {
            throw new IllegalStateException("Unrecognized type.");
        }
        this.log(bayesPm);
    }

    public BayesPmWrapper(GraphWrapper graphWrapper, Parameters params) {
        Dag graph;
        this.numModels = 1;
        if (graphWrapper == null) {
            throw new NullPointerException("Graph must not be null.");
        }
        try {
            graph = new Dag(graphWrapper.getGraph());
        }
        catch (Exception e) {
            throw new RuntimeException("The parent graph cannot be converted to a DAG.");
        }
        if (params.getString("bayesPmInitializationMode", "range").equals("trinary")) {
            int upperBound = 3;
            int lowerBound = 3;
            this.setBayesPm(graph, lowerBound, upperBound);
        } else if (params.getString("bayesPmInitializationMode", "range").equals("range")) {
            int lowerBound = params.getInt("minCategories", 2);
            int upperBound = params.getInt("maxCategories", 4);
            this.setBayesPm(graph, lowerBound, upperBound);
        } else {
            throw new IllegalStateException("Unrecognized type.");
        }
    }

    public BayesPmWrapper(BayesEstimatorWrapper wrapper) {
        this.numModels = 1;
        this.setBayesPm(new BayesPm(wrapper.getEstimatedBayesIm().getBayesPm()));
    }

    public BayesPmWrapper(BayesImWrapper wrapper) {
        this.numModels = 1;
        this.bayesPms = new ArrayList<BayesPm>();
        for (int i = 0; i < wrapper.getNumModels(); ++i) {
            wrapper.setModelIndex(i);
            this.bayesPms.add(wrapper.getBayesIm().getBayesPm());
        }
        this.numModels = wrapper.getNumModels();
    }

    public BayesPmWrapper(GraphSource graphWrapper, DataWrapper dataWrapper) {
        this((Graph)new Dag(graphWrapper.getGraph()), dataWrapper);
    }

    public BayesPmWrapper(Graph graph, DataWrapper dataWrapper) {
        this.numModels = 1;
        DataSet dataSet = (DataSet)dataWrapper.getSelectedDataModel();
        List<Node> vars = dataSet.getVariables();
        HashMap<String, DiscreteVariable> nodesToVars = new HashMap<String, DiscreteVariable>();
        for (int i = 0; i < dataSet.getNumColumns(); ++i) {
            DiscreteVariable var = (DiscreteVariable)vars.get(i);
            String name = var.getName();
            Node node = new GraphNode(name);
            nodesToVars.put(node.getName(), var);
        }
        BayesPm bayesPm = new BayesPm(graph);
        List<Node> nodes = bayesPm.getDag().getNodes();
        for (Node node : nodes) {
            Node var = (Node)nodesToVars.get(node.getName());
            if (var == null) continue;
            DiscreteVariable var2 = (DiscreteVariable)nodesToVars.get(node.getName());
            int numCategories = var2.getNumCategories();
            ArrayList<String> categories = new ArrayList<String>();
            for (int j = 0; j < numCategories; ++j) {
                categories.add(var2.getCategory(j));
            }
            bayesPm.setCategories(node, categories);
        }
        this.setBayesPm(bayesPm);
    }

    public BayesPmWrapper(GraphWrapper graphWrapper, Simulation simulation) {
        this((GraphSource)graphWrapper, (DataWrapper)simulation);
    }

    public BayesPmWrapper(AlgorithmRunner wrapper, Parameters params) {
        this((Graph)new Dag(wrapper.getGraph()), params);
    }

    public BayesPmWrapper(AlgorithmRunner wrapper, DataWrapper dataWrapper) {
        this((Graph)new Dag(wrapper.getGraph()), dataWrapper);
    }

    public BayesPmWrapper(AlgorithmRunner wrapper, Simulation simulation) {
        this((Graph)new Dag(wrapper.getGraph()), (DataWrapper)simulation);
    }

    public BayesPmWrapper(BayesEstimatorWrapper wrapper, Simulation simulation) {
        this((Graph)new Dag(wrapper.getGraph()), (DataWrapper)simulation);
    }

    public BayesPmWrapper(BayesEstimatorWrapper wrapper, DataWrapper dataWrapper) {
        this((Graph)new Dag(wrapper.getGraph()), dataWrapper);
    }

    public BayesPmWrapper(DagWrapper dagWrapper, Parameters params) {
        int lowerBound;
        int upperBound;
        Dag graph;
        this.numModels = 1;
        if (dagWrapper == null) {
            throw new NullPointerException("Graph must not be null.");
        }
        try {
            graph = new Dag(dagWrapper.getDag());
        }
        catch (Exception e) {
            throw new RuntimeException("The parent graph cannot be converted to a DAG.");
        }
        if (params.getString("bayesPmInitializationMode", "trinary").equals("trinary")) {
            upperBound = 3;
            lowerBound = 3;
        } else if (params.getString("bayesPmInitializationMode", "trinary").equals("range")) {
            lowerBound = params.getInt("minCategories", 2);
            upperBound = params.getInt("maxCategories", 4);
        } else {
            throw new IllegalStateException("Unrecognized type.");
        }
        this.setBayesPm(graph, lowerBound, upperBound);
    }

    public BayesPmWrapper(DagWrapper dagWrapper, BayesPmWrapper oldBayesPmWrapper, Parameters params) {
        block6: {
            this.numModels = 1;
            try {
                if (dagWrapper == null) {
                    throw new NullPointerException("Graph must not be null.");
                }
                if (oldBayesPmWrapper == null) {
                    throw new NullPointerException("BayesPm must not be null");
                }
                Graph graph = dagWrapper.getDag();
                String string = params.getString("bayesPmInitializationMode", "trinary");
                if (string.equals("trinary")) {
                    int upperBound = 3;
                    int lowerBound = 3;
                    this.setBayesPm(new BayesPm(graph, oldBayesPmWrapper.getBayesPm(), lowerBound, upperBound));
                    break block6;
                }
                if (string.equals("range")) {
                    int lowerBound = params.getInt("minCategories", 2);
                    int upperBound = params.getInt("maxCategories", 4);
                    this.setBayesPm(graph, lowerBound, upperBound);
                    break block6;
                }
                throw new IllegalStateException("Unrecognized type.");
            }
            catch (Exception e) {
                throw new RuntimeException("The parent graph cannot be converted to a DAG.");
            }
        }
    }

    public BayesPmWrapper(DagWrapper dagWrapper, DataWrapper dataWrapper) {
        this.numModels = 1;
        DataSet dataSet = (DataSet)dataWrapper.getSelectedDataModel();
        List<Node> vars = dataSet.getVariables();
        HashMap<String, DiscreteVariable> nodesToVars = new HashMap<String, DiscreteVariable>();
        for (int i = 0; i < dataSet.getNumColumns(); ++i) {
            DiscreteVariable var = (DiscreteVariable)vars.get(i);
            String name = var.getName();
            GraphNode node = new GraphNode(name);
            nodesToVars.put(node.getName(), var);
        }
        Dag graph = new Dag(dagWrapper.getDag());
        BayesPm bayesPm = new BayesPm(graph);
        List<Node> nodes = bayesPm.getDag().getNodes();
        for (Node node : nodes) {
            Node var = (Node)nodesToVars.get(node.getName());
            if (var == null) continue;
            DiscreteVariable var2 = (DiscreteVariable)nodesToVars.get(node.getName());
            int numCategories = var2.getNumCategories();
            ArrayList<String> categories = new ArrayList<String>();
            for (int j = 0; j < numCategories; ++j) {
                categories.add(var2.getCategory(j));
            }
            bayesPm.setCategories(node, categories);
        }
        this.setBayesPm(bayesPm);
    }

    public BayesPmWrapper(DagWrapper dagWrapper, Simulation dataWrapper) {
        this(dagWrapper, (DataWrapper)dataWrapper);
    }

    public static BayesPmWrapper serializableInstance() {
        return new BayesPmWrapper((Graph)Dag.serializableInstance(), new Parameters());
    }

    public BayesPm getBayesPm() {
        return this.bayesPms.get(this.getModelIndex());
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
    }

    public Graph getGraph() {
        return this.getBayesPm().getDag();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    private void log(BayesPm pm) {
        TetradLogger.getInstance().log("info", "Bayes Parametric Model (Bayes PM)");
        TetradLogger.getInstance().log("pm", pm.toString());
    }

    public Graph getSourceGraph() {
        return this.getGraph();
    }

    public Graph getResultGraph() {
        return this.getGraph();
    }

    public List<String> getVariableNames() {
        return this.getGraph().getNodeNames();
    }

    public List<Node> getVariables() {
        return this.getGraph().getNodes();
    }

    public int getNumModels() {
        return this.numModels;
    }

    public int getModelIndex() {
        return this.modelIndex;
    }

    public String getModelSourceName() {
        return this.modelSourceName;
    }

    public void setModelIndex(int modelIndex) {
        this.modelIndex = modelIndex;
    }
}

