/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.session.DoNotAddOldModel;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetradapp.model.GraphSource;
import edu.cmu.tetradapp.model.GraphWrapper;

public class BidirectedToUndirectedWrapper
extends GraphWrapper
implements DoNotAddOldModel {
    static final long serialVersionUID = 23L;

    public BidirectedToUndirectedWrapper(GraphSource source, Parameters parameters) {
        this(source.getGraph());
    }

    public BidirectedToUndirectedWrapper(Graph graph) {
        super(BidirectedToUndirectedWrapper.pickDagFromCPDAG(graph), "Make Bidirected Edges Undirected");
        TetradLogger.getInstance().log("graph", this.getGraph() + "");
    }

    public static BidirectedToUndirectedWrapper serializableInstance() {
        return new BidirectedToUndirectedWrapper(EdgeListGraph.serializableInstance());
    }

    private static Graph pickDagFromCPDAG(Graph graph) {
        return GraphUtils.bidirectedToUndirected(graph);
    }

    @Override
    public boolean allowRandomGraph() {
        return false;
    }
}

