/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.Clusters;
import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.LayoutUtil;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.search.BpcAlgorithmType;
import edu.cmu.tetrad.search.BpcTetradPurifyWashdown;
import edu.cmu.tetrad.search.BuildPureClusters;
import edu.cmu.tetrad.search.ClusterUtils;
import edu.cmu.tetrad.search.MimUtils;
import edu.cmu.tetrad.search.TestType;
import edu.cmu.tetrad.search.Washdown;
import edu.cmu.tetrad.sem.ReidentifyVariables;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetrad.util.Unmarshallable;
import edu.cmu.tetradapp.model.AbstractMimRunner;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.GraphSource;
import edu.cmu.tetradapp.model.GraphWrapper;
import edu.cmu.tetradapp.model.PcRunner;
import edu.cmu.tetradapp.model.SemImWrapper;
import java.rmi.MarshalledObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class BuildPureClustersRunner
extends AbstractMimRunner
implements GraphSource,
Unmarshallable {
    static final long serialVersionUID = 23L;
    private SemIm semIm;
    private Graph trueGraph;

    public BuildPureClustersRunner(DataWrapper dataWrapper, Parameters pureClustersParams) {
        super(dataWrapper, (Clusters)pureClustersParams.get("clusters", null), pureClustersParams);
    }

    public BuildPureClustersRunner(DataWrapper dataWrapper, SemImWrapper semImWrapper, Parameters pureClustersParams) {
        super(dataWrapper, (Clusters)pureClustersParams.get("clusters", null), pureClustersParams);
        this.semIm = semImWrapper.getSemIm();
        this.trueGraph = this.semIm.getSemPm().getGraph();
    }

    public BuildPureClustersRunner(DataWrapper dataWrapper, GraphWrapper graphWrapper, Parameters pureClustersParams) {
        super(dataWrapper, (Clusters)pureClustersParams.get("clusters", null), pureClustersParams);
        this.trueGraph = graphWrapper.getGraph();
    }

    public static PcRunner serializableInstance() {
        return PcRunner.serializableInstance();
    }

    @Override
    public void execute() {
        List<String> variableNames;
        List<List<Node>> partition;
        Graph searchGraph;
        boolean rKey = this.getParams().getBoolean("BPCrDown", false);
        BpcAlgorithmType algorithm = (BpcAlgorithmType)this.getParams().get("bpcAlgorithmthmType", BpcAlgorithmType.FIND_ONE_FACTOR_CLUSTERS);
        if (rKey) {
            DataModel source = this.getData();
            Washdown washdown = source instanceof DataSet ? new Washdown((DataSet)source, this.getParams().getDouble("alpha", 0.001)) : new Washdown((CovarianceMatrix)source, this.getParams().getDouble("alpha", 0.001));
            searchGraph = washdown.search();
        } else {
            Object bpc;
            TestType tetradTestType = (TestType)this.getParams().get("tetradTestType", TestType.TETRAD_WISHART);
            if (algorithm == BpcAlgorithmType.TETRAD_PURIFY_WASHDOWN) {
                DataModel source = this.getData();
                bpc = source instanceof DataSet ? new BpcTetradPurifyWashdown((DataSet)source, tetradTestType, this.getParams().getDouble("alpha", 0.001)) : new BpcTetradPurifyWashdown((ICovarianceMatrix)source, tetradTestType, this.getParams().getDouble("alpha", 0.001));
                searchGraph = ((BpcTetradPurifyWashdown)bpc).search();
            } else if (algorithm == BpcAlgorithmType.BUILD_PURE_CLUSTERS) {
                DataModel source = this.getData();
                TestType testType = (TestType)this.getParams().get("tetradTestType", TestType.TETRAD_WISHART);
                if (source instanceof ICovarianceMatrix) {
                    bpc = new BuildPureClusters((ICovarianceMatrix)source, this.getParams().getDouble("alpha", 0.001), testType);
                } else if (source instanceof DataSet) {
                    bpc = new BuildPureClusters((DataSet)source, this.getParams().getDouble("alpha", 0.001), testType);
                } else {
                    throw new IllegalArgumentException();
                }
                searchGraph = ((BuildPureClusters)bpc).search();
            } else {
                throw new IllegalStateException();
            }
        }
        if (this.semIm != null) {
            partition = MimUtils.convertToClusters2(searchGraph);
            variableNames = ReidentifyVariables.reidentifyVariables2(partition, this.trueGraph, (DataSet)this.getData());
            this.rename(searchGraph, partition, variableNames);
        } else if (this.trueGraph != null) {
            partition = MimUtils.convertToClusters2(searchGraph);
            variableNames = ReidentifyVariables.reidentifyVariables1(partition, this.trueGraph);
            this.rename(searchGraph, partition, variableNames);
        }
        System.out.println("Search Graph " + searchGraph);
        try {
            Graph graph = new MarshalledObject<Graph>(searchGraph).get();
            LayoutUtil.circleLayout(graph, 200, 200, 150);
            LayoutUtil.fruchtermanReingoldLayout(graph);
            this.setResultGraph(graph);
            this.setClusters(MimUtils.convertToClusters(graph, this.getData().getVariables()));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private void rename(Graph searchGraph, List<List<Node>> partition, List<String> variableNames) {
        for (Node node : searchGraph.getNodes()) {
            if (node.getNodeType() != NodeType.LATENT) continue;
            List<Node> children = searchGraph.getChildren(node);
            children.removeAll(ReidentifyVariables.getLatents(searchGraph));
            for (int i = 0; i < partition.size(); ++i) {
                if (!new HashSet(partition.get(i)).equals(new HashSet<Node>(children))) continue;
                node.setName(variableNames.get(i));
            }
        }
    }

    @Override
    public Graph getGraph() {
        return this.getResultGraph();
    }

    public List<Node> getVariables() {
        ArrayList<Node> latents = new ArrayList<Node>();
        for (String name : this.getVariableNames()) {
            ContinuousVariable node = new ContinuousVariable(name);
            node.setNodeType(NodeType.LATENT);
            latents.add(node);
        }
        return latents;
    }

    public List<String> getVariableNames() {
        List<List<Node>> partition = ClusterUtils.clustersToPartition(this.getClusters(), this.getData().getVariables());
        return ClusterUtils.generateLatentNames(partition.size());
    }
}

