/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.bayes.BayesIm;
import edu.cmu.tetrad.bayes.BayesPm;
import edu.cmu.tetrad.bayes.MlBayesEstimator;
import edu.cmu.tetrad.data.DataModelList;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataUtils;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.graph.SemGraph;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.sem.SemEstimator;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.sem.SemOptimizer;
import edu.cmu.tetrad.sem.SemOptimizerRicf;
import edu.cmu.tetrad.sem.SemPm;
import edu.cmu.tetrad.session.SessionModel;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetradapp.model.BayesPmWrapper;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.GeneralAlgorithmRunner;
import edu.cmu.tetradapp.model.Simulation;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;

public final class CPDAGFitModel
implements SessionModel {
    static final long serialVersionUID = 23L;
    private final Parameters parameters;
    private String name;
    private List<BayesIm> bayesIms;
    private List<BayesPm> bayesPms;
    private List<Graph> referenceGraphs;
    private final DataModelList dataModelList;
    private List<SemPm> semPms;

    public CPDAGFitModel(Simulation simulation, GeneralAlgorithmRunner algorithmRunner, Parameters params) {
        block7: {
            List<Graph> graphs;
            DataModelList dataModels;
            block6: {
                if (params == null) {
                    throw new NullPointerException("Parameters must not be null");
                }
                this.parameters = params;
                this.dataModelList = dataModels = simulation.getDataModelList();
                graphs = algorithmRunner.getGraphs();
                if (dataModels.size() != graphs.size()) {
                    throw new IllegalArgumentException("Sorry, I was expecting the same number of data sets as result graphs.");
                }
                if (!dataModels.get(0).isDiscrete()) break block6;
                this.bayesPms = new ArrayList<BayesPm>();
                this.bayesIms = new ArrayList<BayesIm>();
                for (int i = 0; i < dataModels.size(); ++i) {
                    DataSet dataSet = (DataSet)dataModels.get(0);
                    Graph dag = SearchGraphUtils.dagFromCPDAG(graphs.get(0));
                    BayesPm pm = new BayesPmWrapper(dag, new DataWrapper(dataSet)).getBayesPm();
                    this.bayesPms.add(pm);
                    this.bayesIms.add(this.estimate(dataSet, pm));
                }
                break block7;
            }
            if (!dataModels.get(0).isContinuous()) break block7;
            this.semPms = new ArrayList<SemPm>();
            ArrayList<SemIm> semIms = new ArrayList<SemIm>();
            for (int i = 0; i < dataModels.size(); ++i) {
                DataSet dataSet = (DataSet)dataModels.get(0);
                Graph dag = SearchGraphUtils.dagFromCPDAG(graphs.get(0));
                try {
                    SemPm pm = new SemPm(dag);
                    this.semPms.add(pm);
                    semIms.add(this.estimate(dataSet, pm));
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Graph mag = SearchGraphUtils.pagToMag(graphs.get(0));
                    SemGraph graph = new SemGraph(mag);
                    graph.setShowErrorTerms(false);
                    SemPm pm = new SemPm(graph);
                    this.semPms.add(pm);
                    semIms.add(this.estimatePag(dataSet, pm));
                }
            }
        }
    }

    private BayesIm estimate(DataSet dataSet, BayesPm bayesPm) {
        Graph graph = bayesPm.getDag();
        for (Node o : graph.getNodes()) {
            Node node = o;
            if (node.getNodeType() != NodeType.LATENT) continue;
            throw new IllegalArgumentException("Estimation of Bayes IM's with latents is not supported.");
        }
        if (DataUtils.containsMissingValue(dataSet)) {
            throw new IllegalArgumentException("Please remove or impute missing values.");
        }
        try {
            MlBayesEstimator estimator = new MlBayesEstimator();
            return estimator.estimate(bayesPm, dataSet);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
            throw new RuntimeException("Value assignments between Bayes PM and discrete data set do not match.");
        }
    }

    private SemIm estimate(DataSet dataSet, SemPm semPm) {
        SemGraph graph = semPm.getGraph();
        for (Node o : graph.getNodes()) {
            Node node = o;
            if (node.getNodeType() != NodeType.LATENT) continue;
            throw new IllegalArgumentException("Estimation of Bayes IM's with latents is not supported.");
        }
        if (DataUtils.containsMissingValue(dataSet)) {
            throw new IllegalArgumentException("Please remove or impute missing values.");
        }
        try {
            SemEstimator estimator = new SemEstimator(dataSet, semPm);
            return estimator.estimate();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
            throw new RuntimeException("Value assignments between Bayes PM and discrete data set do not match.");
        }
    }

    private SemIm estimatePag(DataSet dataSet, SemPm pm) {
        SemGraph graph = pm.getGraph();
        for (Node o : graph.getNodes()) {
            Node node = o;
            if (node.getNodeType() != NodeType.LATENT) continue;
            throw new IllegalArgumentException("Estimation of Bayes IM's with latents is not supported.");
        }
        if (DataUtils.containsMissingValue(dataSet)) {
            throw new IllegalArgumentException("Please remove or impute missing values.");
        }
        try {
            SemOptimizerRicf optimizer = new SemOptimizerRicf();
            SemEstimator estimator = new SemEstimator(dataSet, pm, (SemOptimizer)optimizer);
            return estimator.estimate();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
            throw new RuntimeException("Value assignments between Bayes PM and discrete data set do not match.");
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public BayesIm getBayesIm(int i) {
        return this.bayesIms.get(i);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
    }

    public List<Graph> getReferenceGraphs() {
        return this.referenceGraphs;
    }

    public List<BayesIm> getBayesIms() {
        return this.bayesIms;
    }

    public DataModelList getDataModelList() {
        return this.dataModelList;
    }

    public List<BayesPm> getBayesPms() {
        return this.bayesPms;
    }

    public List<SemPm> getSemPms() {
        return this.semPms;
    }

    public Parameters getParams() {
        return this.parameters;
    }
}

