/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.session.DoNotAddOldModel;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetradapp.model.GraphSource;
import edu.cmu.tetradapp.model.GraphWrapper;

public class CPDAGFromDagGraphWrapper
extends GraphWrapper
implements DoNotAddOldModel {
    static final long serialVersionUID = 23L;

    public CPDAGFromDagGraphWrapper(GraphSource source, Parameters parameters) {
        this(source.getGraph());
    }

    public CPDAGFromDagGraphWrapper(Graph graph) {
        super(new EdgeListGraph());
        try {
            new Dag(graph);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("The source graph is not a DAG.");
        }
        Graph CPDAG = CPDAGFromDagGraphWrapper.getCPDAG(new EdgeListGraph(graph));
        this.setGraph(CPDAG);
        TetradLogger.getInstance().log("info", "\nGenerating CPDAG from DAG.");
        TetradLogger.getInstance().log("CPDAG", CPDAG + "");
    }

    public static CPDAGFromDagGraphWrapper serializableInstance() {
        return new CPDAGFromDagGraphWrapper(EdgeListGraph.serializableInstance());
    }

    private static Graph getCPDAG(Graph graph) {
        return SearchGraphUtils.cpdagFromDag(graph);
    }

    @Override
    public boolean allowRandomGraph() {
        return false;
    }
}

