/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.calculator.Transformation;
import edu.cmu.tetrad.data.BoxDataSet;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataModelList;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DoubleDataBox;
import edu.cmu.tetrad.data.LogDataUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.PcRunner;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;

public class CalculatorWrapper
extends DataWrapper {
    static final long serialVersionUID = 23L;

    public CalculatorWrapper(DataWrapper data, Parameters params) {
        if (data == null) {
            throw new NullPointerException("The given data must not be null");
        }
        if (params == null) {
            throw new NullPointerException("The given parameters must not be null");
        }
        DataModelList list = new DataModelList();
        DataModelList originals = data.getDataModelList();
        for (DataModel model : originals) {
            String[] displayEquations;
            DataSet copy = CalculatorWrapper.copy((DataSet)model);
            ArrayList<String> equations = new ArrayList<String>();
            int size = ((List)params.get("equations", null)).size();
            for (String equation : displayEquations = ((List)params.get("equations", null)).toArray(new String[size])) {
                if (equation.contains("$")) {
                    for (Node node : copy.getVariables()) {
                        equations.add(equation.replace("$", node.getName()));
                    }
                    continue;
                }
                equations.add(equation);
            }
            if (!equations.isEmpty()) {
                try {
                    Transformation.transform(copy, equations.toArray(new String[0]));
                }
                catch (ParseException e) {
                    throw new IllegalStateException("Was given unparsable expressions.");
                }
            }
            list.add(copy);
        }
        this.setDataModel(list);
        this.setSourceGraph(data.getSourceGraph());
        LogDataUtils.logDataModelList("Result data from a calculator operation.", this.getDataModelList());
    }

    public static PcRunner serializableInstance() {
        return PcRunner.serializableInstance();
    }

    private static DataSet copy(DataSet data) {
        BoxDataSet copy = new BoxDataSet(new DoubleDataBox(data.getNumRows(), data.getVariables().size()), data.getVariables());
        int cols = data.getNumColumns();
        int rows = data.getNumRows();
        for (int col = 0; col < cols; ++col) {
            for (int row = 0; row < rows; ++row) {
                copy.setDouble(row, col, data.getDouble(row, col));
            }
        }
        return copy;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
    }
}

