/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.BoxDataSet;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataModelList;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DoubleDataBox;
import edu.cmu.tetrad.data.LogDataUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.Matrix;
import edu.cmu.tetrad.util.StatUtils;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.PcRunner;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.util.FastMath;

public class ConvertToPositiveSkew
extends DataWrapper {
    static final long serialVersionUID = 23L;

    private ConvertToPositiveSkew(DataWrapper wrapper) {
        DataModelList inList1 = wrapper.getDataModelList();
        DataModelList outList = new DataModelList();
        for (DataModel model : inList1) {
            if (!(model instanceof DataSet)) {
                throw new IllegalArgumentException("Not a data set: " + model.getName());
            }
            DataSet dataSet = (DataSet)model;
            if (!dataSet.isContinuous()) {
                throw new IllegalArgumentException("Not a continuous data set: " + dataSet.getName());
            }
            Matrix matrix2D = dataSet.getDoubleData();
            for (int j = 0; j < matrix2D.columns(); ++j) {
                double[] c = matrix2D.getColumn(j).toArray();
                double skew = StatUtils.skewness(c);
                for (int i = 0; i < matrix2D.rows(); ++i) {
                    matrix2D.set(i, j, matrix2D.get(i, j) * FastMath.signum(skew));
                }
            }
            List<Node> list = dataSet.getVariables();
            ArrayList<Node> list2 = new ArrayList<Node>(list);
            BoxDataSet dataSet2 = new BoxDataSet(new DoubleDataBox(matrix2D.toArray()), list2);
            outList.add(dataSet2);
        }
        this.setDataModel(outList);
        this.setSourceGraph(wrapper.getSourceGraph());
        LogDataUtils.logDataModelList("Multiplying each column by the sign of its skew.", this.getDataModelList());
    }

    public static PcRunner serializableInstance() {
        return PcRunner.serializableInstance();
    }
}

