/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.CorrelationMatrix;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.data.LogDataUtils;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.PcRunner;

public class CorrMatrixConverter
extends DataWrapper {
    static final long serialVersionUID = 23L;

    public CorrMatrixConverter(DataWrapper wrapper, Parameters params) {
        CorrelationMatrix covMatrix;
        if (wrapper.getSelectedDataModel() instanceof DataSet) {
            DataSet dataSet = (DataSet)wrapper.getSelectedDataModel();
            if (!dataSet.isContinuous()) {
                throw new RuntimeException("Only continuous data sets can be converted to correlation matrices.");
            }
            covMatrix = new CorrelationMatrix(dataSet);
        } else if (wrapper.getSelectedDataModel() instanceof ICovarianceMatrix) {
            ICovarianceMatrix covOrig = (ICovarianceMatrix)wrapper.getSelectedDataModel();
            covMatrix = new CorrelationMatrix(covOrig);
        } else {
            throw new IllegalArgumentException("Expecting a continuous data set or a covariance matrix.");
        }
        this.setDataModel(covMatrix);
        this.setSourceGraph(wrapper.getSourceGraph());
        LogDataUtils.logDataModelList("Conversion of parent data to correlation matrix form.", this.getDataModelList());
    }

    public static PcRunner serializableInstance() {
        return PcRunner.serializableInstance();
    }
}

