/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.bayes.BayesIm;
import edu.cmu.tetrad.bayes.CptInvariantUpdater;
import edu.cmu.tetrad.bayes.DirichletBayesIm;
import edu.cmu.tetrad.bayes.Evidence;
import edu.cmu.tetrad.bayes.ManipulatingBayesUpdater;
import edu.cmu.tetrad.data.DiscreteVariable;
import edu.cmu.tetrad.session.SessionModel;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetrad.util.Unmarshallable;
import edu.cmu.tetradapp.model.BayesEstimatorWrapper;
import edu.cmu.tetradapp.model.BayesImWrapper;
import edu.cmu.tetradapp.model.DirichletBayesImWrapper;
import edu.cmu.tetradapp.model.DirichletEstimatorWrapper;
import edu.cmu.tetradapp.model.EmBayesEstimatorWrapper;
import edu.cmu.tetradapp.model.UpdaterWrapper;
import java.io.IOException;
import java.io.ObjectInputStream;

public class CptInvariantUpdaterWrapper
implements SessionModel,
UpdaterWrapper,
Unmarshallable {
    static final long serialVersionUID = 23L;
    private String name;
    private ManipulatingBayesUpdater bayesUpdater;
    private Parameters params;

    public CptInvariantUpdaterWrapper(BayesImWrapper wrapper, Parameters params) {
        if (wrapper == null) {
            throw new NullPointerException();
        }
        BayesIm bayesIm = wrapper.getBayesIm();
        this.setup(bayesIm, params);
    }

    public CptInvariantUpdaterWrapper(DirichletBayesImWrapper wrapper, Parameters params) {
        if (wrapper == null) {
            throw new NullPointerException();
        }
        DirichletBayesIm bayesIm = wrapper.getDirichletBayesIm();
        this.setup(bayesIm, params);
    }

    public CptInvariantUpdaterWrapper(BayesEstimatorWrapper wrapper, Parameters params) {
        if (wrapper == null) {
            throw new NullPointerException();
        }
        BayesIm bayesIm = wrapper.getEstimatedBayesIm();
        this.setup(bayesIm, params);
    }

    public CptInvariantUpdaterWrapper(DirichletEstimatorWrapper wrapper, Parameters params) {
        if (wrapper == null) {
            throw new NullPointerException();
        }
        DirichletBayesIm bayesIm = wrapper.getEstimatedBayesIm();
        this.setup(bayesIm, params);
    }

    public CptInvariantUpdaterWrapper(EmBayesEstimatorWrapper wrapper, Parameters params) {
        if (wrapper == null) {
            throw new NullPointerException();
        }
        BayesIm bayesIm = wrapper.getEstimateBayesIm();
        this.setup(bayesIm, params);
    }

    public static CptInvariantUpdaterWrapper serializableInstance() {
        return new CptInvariantUpdaterWrapper(BayesImWrapper.serializableInstance(), new Parameters());
    }

    @Override
    public ManipulatingBayesUpdater getBayesUpdater() {
        return this.bayesUpdater;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    private void setup(BayesIm bayesIm, Parameters params) {
        TetradLogger.getInstance().setConfigForClass(this.getClass());
        this.params = params;
        this.bayesUpdater = params.get("evidence", null) == null || ((Evidence)params.get("evidence", null)).isIncompatibleWith(bayesIm) ? new CptInvariantUpdater(bayesIm) : new CptInvariantUpdater(bayesIm, (Evidence)params.get("evidence", null));
        TetradLogger.getInstance().reset();
    }

    private String category(Evidence evidence, String nodeName, int i) {
        DiscreteVariable variable = this.discreteVariable(evidence, nodeName);
        return variable.getCategory(i);
    }

    private DiscreteVariable discreteVariable(Evidence evidence, String nodeName) {
        return evidence.getVariable(nodeName);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.bayesUpdater == null) {
            throw new NullPointerException();
        }
    }

    @Override
    public Parameters getParams() {
        return this.params;
    }
}

