/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.KnowledgeBoxInput;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.LayoutUtil;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.IndTestDSep;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.session.SimulationParamsSource;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetradapp.model.AbstractAlgorithmRunner;
import edu.cmu.tetradapp.model.BayesEstimatorWrapper;
import edu.cmu.tetradapp.model.BayesImWrapper;
import edu.cmu.tetradapp.model.BayesPmWrapper;
import edu.cmu.tetradapp.model.CptInvariantUpdaterWrapper;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.GraphSource;
import edu.cmu.tetradapp.model.IndTestProducer;
import edu.cmu.tetradapp.model.MultipleGraphSource;
import edu.cmu.tetradapp.model.RegressionRunner;
import edu.cmu.tetradapp.model.SemEstimatorWrapper;
import edu.cmu.tetradapp.model.SemImWrapper;
import edu.cmu.tetradapp.model.SemPmWrapper;
import edu.cmu.tetradapp.model.Simulation;
import edu.cmu.tetradapp.util.GraphUtils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DagWrapper
implements GraphSource,
KnowledgeBoxInput,
IndTestProducer,
SimulationParamsSource,
MultipleGraphSource {
    static final long serialVersionUID = 23L;
    private int numModels = 1;
    private int modelIndex;
    private String modelSourceName;
    private String name;
    private List<Dag> dags;
    private Map<String, String> allParamSettings;
    private Parameters parameters;
    private Dag graph;

    public DagWrapper(Dag graph) {
        if (graph == null) {
            throw new NullPointerException("Tetrad dag must not be null.");
        }
        this.setGraph(graph);
        this.parameters = new Parameters();
        this.log();
    }

    public DagWrapper(Parameters params) {
        this.parameters = params;
        if (params.getString("newGraphInitializationMode", "manual").equals("manual")) {
            this.setDag(new Dag());
        } else if (params.getString("newGraphInitializationMode", "manual").equals("random")) {
            this.setDag(new Dag(GraphUtils.makeRandomGraph(this.getGraph(), params)));
        }
        this.log();
    }

    public DagWrapper(GraphSource graphSource, Parameters parameters) {
        if (graphSource instanceof Simulation) {
            Simulation simulation = (Simulation)graphSource;
            List<Graph> graphs = simulation.getGraphs();
            this.dags = new ArrayList<Dag>();
            for (Graph graph : graphs) {
                this.dags.add(new Dag(graph));
            }
            this.numModels = this.dags.size();
            this.modelIndex = 0;
            this.modelSourceName = simulation.getName();
        } else {
            this.setGraph(new EdgeListGraph(graphSource.getGraph()));
        }
        this.log();
    }

    public DagWrapper(AbstractAlgorithmRunner wrapper) {
        this(new Dag(wrapper.getResultGraph()));
    }

    public DagWrapper(DataWrapper wrapper) {
        if (wrapper instanceof Simulation) {
            Simulation simulation = (Simulation)wrapper;
            List<Graph> graphs = simulation.getGraphs();
            this.dags = new ArrayList<Dag>();
            for (Graph graph : graphs) {
                this.dags.add(new Dag(graph));
            }
            this.numModels = this.dags.size();
            this.modelIndex = 0;
            this.modelSourceName = simulation.getName();
        } else {
            this.setGraph(new EdgeListGraph(wrapper.getVariables()));
        }
        LayoutUtil.circleLayout(this.getGraph(), 200, 200, 150);
    }

    public DagWrapper(BayesPmWrapper wrapper) {
        this(new Dag(wrapper.getBayesPm().getDag()));
    }

    public DagWrapper(BayesImWrapper wrapper) {
        this(new Dag(wrapper.getBayesIm().getBayesPm().getDag()));
    }

    public DagWrapper(BayesEstimatorWrapper wrapper) {
        this(new Dag(wrapper.getEstimatedBayesIm().getBayesPm().getDag()));
    }

    public DagWrapper(CptInvariantUpdaterWrapper wrapper) {
        this(new Dag(wrapper.getBayesUpdater().getManipulatedGraph()));
    }

    public DagWrapper(SemPmWrapper wrapper) {
        this(new Dag(wrapper.getSemPm().getGraph()));
    }

    public DagWrapper(SemImWrapper wrapper) {
        this(new Dag(wrapper.getSemIm().getSemPm().getGraph()));
    }

    public DagWrapper(SemEstimatorWrapper wrapper) {
        this(new Dag(wrapper.getSemEstimator().getEstimatedSem().getSemPm().getGraph()));
    }

    public DagWrapper(RegressionRunner wrapper) {
        this(new Dag(wrapper.getResultGraph()));
    }

    public static DagWrapper serializableInstance() {
        return new DagWrapper(Dag.serializableInstance());
    }

    public Graph getDag() {
        return this.dags.get(this.getModelIndex());
    }

    public void setDag(Dag graph) {
        this.dags = new ArrayList<Dag>();
        this.dags.add(graph);
        this.log();
    }

    private void log() {
        TetradLogger.getInstance().log("info", "Directed Acyclic Graph (DAG)");
        TetradLogger.getInstance().log("graph", this.getGraph() + "");
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
    }

    @Override
    public Graph getGraph() {
        return this.getDag();
    }

    @Override
    public IndependenceTest getIndependenceTest() {
        return new IndTestDSep(this.getGraph());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Graph getSourceGraph() {
        return this.getGraph();
    }

    @Override
    public Graph getResultGraph() {
        return this.getGraph();
    }

    @Override
    public List<String> getVariableNames() {
        return this.getGraph().getNodeNames();
    }

    @Override
    public List<Node> getVariables() {
        return this.getGraph().getNodes();
    }

    @Override
    public Map<String, String> getParamSettings() {
        HashMap<String, String> paramSettings = new HashMap<String, String>();
        paramSettings.put("# Nodes", Integer.toString(this.getDag().getNumNodes()));
        paramSettings.put("# Edges", Integer.toString(this.getDag().getNumEdges()));
        return paramSettings;
    }

    @Override
    public void setAllParamSettings(Map<String, String> paramSettings) {
        this.allParamSettings = paramSettings;
    }

    @Override
    public Map<String, String> getAllParamSettings() {
        return this.allParamSettings;
    }

    public Parameters getParameters() {
        return this.parameters;
    }

    public int getNumModels() {
        return this.numModels;
    }

    public int getModelIndex() {
        return this.modelIndex;
    }

    public String getModelSourceName() {
        return this.modelSourceName;
    }

    public void setModelIndex(int modelIndex) {
        this.modelIndex = modelIndex;
    }

    public void setGraph(Graph graph) {
        this.dags = new ArrayList<Dag>();
        this.dags.add(new Dag(graph));
    }

    @Override
    public List<Graph> getGraphs() {
        return new ArrayList<Graph>(this.dags);
    }
}

