/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.BoxDataSet;
import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.CorrelationMatrix;
import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataModelList;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.data.KnowledgeBoxInput;
import edu.cmu.tetrad.data.LogDataUtils;
import edu.cmu.tetrad.data.VerticalDoubleDataBox;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.regression.RegressionResult;
import edu.cmu.tetrad.session.DoNotAddOldModel;
import edu.cmu.tetrad.session.SimulationParamsSource;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetradapp.model.DagWrapper;
import edu.cmu.tetradapp.model.GraphWrapper;
import edu.cmu.tetradapp.model.KnowledgeEditable;
import edu.cmu.tetradapp.model.MimBuildRunner;
import edu.cmu.tetradapp.model.MultipleDataSource;
import edu.cmu.tetradapp.model.PcRunner;
import edu.cmu.tetradapp.model.RegressionRunner;
import edu.cmu.tetradapp.model.SemGraphWrapper;
import edu.cmu.tetradapp.model.Simulation;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class DataWrapper
implements KnowledgeEditable,
KnowledgeBoxInput,
DoNotAddOldModel,
SimulationParamsSource,
MultipleDataSource {
    static final long serialVersionUID = 23L;
    private String name;
    private DataModelList dataModelList;
    private final Map discretizationSpecs = new HashMap();
    private Graph sourceGraph;
    private Parameters parameters;
    private Map<String, String> allParamSettings;

    protected DataWrapper() {
        this.setDataModel(new BoxDataSet(new VerticalDoubleDataBox(0, 0), new LinkedList<Node>()));
        this.parameters = new Parameters();
    }

    public DataWrapper(Parameters parameters) {
        this.setDataModel(new BoxDataSet(new VerticalDoubleDataBox(0, 0), new LinkedList<Node>()));
        this.parameters = parameters;
    }

    public DataWrapper(Simulation wrapper, Parameters parameters) {
        this.name = wrapper.getName();
        this.dataModelList = new DataModelList();
        for (DataModel model : wrapper.getDataModels()) {
            if (model instanceof DataSet) {
                this.dataModelList.add(((DataSet)model).copy());
                continue;
            }
            if (model instanceof CorrelationMatrix) {
                this.dataModelList.add(new CorrelationMatrix((ICovarianceMatrix)((CorrelationMatrix)model)));
                continue;
            }
            if (model instanceof CovarianceMatrix) {
                this.dataModelList.add(new CovarianceMatrix((CovarianceMatrix)model));
                continue;
            }
            throw new IllegalArgumentException();
        }
        this.dataModelList = wrapper.getDataModelList();
        this.parameters = parameters;
    }

    public DataWrapper(DataWrapper wrapper, Parameters parameters) {
        this.name = wrapper.name;
        DataModelList dataModelList = new DataModelList();
        int selected = -1;
        for (int i = 0; i < wrapper.getDataModelList().size(); ++i) {
            DataModel model = wrapper.getDataModelList().get(i);
            if (model instanceof DataSet) {
                dataModelList.add(((DataSet)model).copy());
            } else if (model instanceof CorrelationMatrix) {
                dataModelList.add(new CorrelationMatrix((ICovarianceMatrix)((CorrelationMatrix)model)));
            } else if (model instanceof CovarianceMatrix) {
                dataModelList.add(new CovarianceMatrix((CovarianceMatrix)model));
            } else {
                throw new IllegalArgumentException();
            }
            if (!model.equals(wrapper.getDataModelList().getSelectedModel())) continue;
            selected = i;
        }
        if (selected > -1) {
            dataModelList.setSelectedModel(dataModelList.get(selected));
        }
        if (wrapper.sourceGraph != null) {
            this.sourceGraph = new EdgeListGraph(wrapper.sourceGraph);
        }
        this.dataModelList = dataModelList;
        LogDataUtils.logDataModelList("Standalone data set.", this.getDataModelList());
    }

    public DataWrapper(DataSet dataSet) {
        this.setDataModel(dataSet);
    }

    public DataWrapper(Graph graph, Parameters parameters) {
        if (graph == null) {
            throw new NullPointerException();
        }
        List<Node> nodes = graph.getNodes();
        LinkedList<Node> variables = new LinkedList<Node>();
        Iterator<Node> iterator = nodes.iterator();
        while (iterator.hasNext()) {
            Node node1;
            Node node = node1 = iterator.next();
            String name = node.getName();
            NodeType nodetype = node.getNodeType();
            if (nodetype != NodeType.MEASURED) continue;
            ContinuousVariable var = new ContinuousVariable(name);
            variables.add(var);
        }
        BoxDataSet dataSet = new BoxDataSet(new VerticalDoubleDataBox(0, variables.size()), variables);
        DataModelList dataModelList = new DataModelList();
        dataModelList.add(dataSet);
        this.dataModelList = dataModelList;
    }

    public DataWrapper(DagWrapper dagWrapper, Parameters parameters) {
        this(dagWrapper.getDag(), parameters);
    }

    public DataWrapper(SemGraphWrapper wrapper, Parameters parameters) {
        this(wrapper.getGraph(), parameters);
    }

    public DataWrapper(GraphWrapper wrapper, Parameters parameters) {
        this(wrapper.getGraph(), parameters);
    }

    public DataWrapper(RegressionRunner regression, DataWrapper wrapper, Parameters parameters) {
        this(regression.getResult(), (DataSet)wrapper.getDataModelList().getSelectedModel(), parameters);
    }

    public DataWrapper(RegressionRunner regression, Simulation wrapper, Parameters parameters) {
        this(regression.getResult(), (DataSet)wrapper.getDataModelList().getSelectedModel(), parameters);
    }

    public DataWrapper(RegressionResult result, DataSet data, Parameters parameters) {
        DataSet data2 = data.copy();
        String predictedVariable = this.nextVariableName("Pred", data);
        data2.addVariable(new ContinuousVariable(predictedVariable));
        String[] regressorNames = result.getRegressorNames();
        for (int i = 0; i < data.getNumRows(); ++i) {
            double[] x = new double[regressorNames.length];
            for (int j = 0; j < regressorNames.length; ++j) {
                Node variable = data.getVariable(regressorNames[j]);
                if (variable == null) {
                    throw new NullPointerException("Variable " + variable + " doesn't exist in the input data.");
                }
                if (!(variable instanceof ContinuousVariable)) {
                    throw new IllegalArgumentException("Expecting a continuous variable: " + variable);
                }
                x[j] = data.getDouble(i, data.getColumn(variable));
            }
            double yHat = result.getPredictedValue(x);
            data2.setDouble(i, data2.getColumn(data2.getVariable(predictedVariable)), yHat);
        }
        DataModelList dataModelList = new DataModelList();
        dataModelList.add(data2);
        this.dataModelList = dataModelList;
    }

    public DataWrapper(MimBuildRunner mimBuild, Parameters parameters) {
        ICovarianceMatrix cov = mimBuild.getCovMatrix();
        DataModelList dataModelList = new DataModelList();
        dataModelList.add(cov);
        this.dataModelList = dataModelList;
    }

    private String nextVariableName(String base, DataSet data) {
        int i = -1;
        String name = "?";
        block0: while (true) {
            name = ++i == 0 ? base : base + i;
            for (Node node1 : data.getVariables()) {
                if (!node1.getName().equals(name)) continue;
                continue block0;
            }
            break;
        }
        return name;
    }

    public static PcRunner serializableInstance() {
        return PcRunner.serializableInstance();
    }

    public DataModelList getDataModelList() {
        return this.dataModelList;
    }

    @Override
    public List<DataModel> getDataModels() {
        return new ArrayList<DataModel>(this.dataModelList);
    }

    public void setDataModelList(DataModelList dataModelList) {
        if (dataModelList == null) {
            throw new NullPointerException("Data model list not provided.");
        }
        this.dataModelList = dataModelList;
    }

    public DataModel getSelectedDataModel() {
        DataModelList modelList = this.getDataModelList();
        return modelList.getSelectedModel();
    }

    public void setDataModel(DataModel dataModel) {
        if (dataModel == null) {
            dataModel = new BoxDataSet(new VerticalDoubleDataBox(0, 0), new LinkedList<Node>());
        }
        if (dataModel instanceof DataModelList) {
            this.dataModelList = (DataModelList)dataModel;
        } else {
            DataModelList dataModelList = new DataModelList();
            dataModelList.add(dataModel);
            this.dataModelList = dataModelList;
        }
    }

    @Override
    public Knowledge getKnowledge() {
        return this.getSelectedDataModel().getKnowledge();
    }

    @Override
    public void setKnowledge(Knowledge knowledge) {
        this.getSelectedDataModel().setKnowledge(knowledge);
    }

    @Override
    public List<String> getVarNames() {
        return this.getSelectedDataModel().getVariableNames();
    }

    @Override
    public Graph getSourceGraph() {
        return this.sourceGraph;
    }

    @Override
    public Graph getResultGraph() {
        return this.getSourceGraph();
    }

    @Override
    public List<Node> getVariables() {
        return this.getSelectedDataModel().getVariables();
    }

    protected void setSourceGraph(Graph sourceGraph) {
        this.sourceGraph = sourceGraph;
    }

    public Map getDiscretizationSpecs() {
        return this.discretizationSpecs;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public Parameters getParams() {
        return this.parameters;
    }

    public void setParameters(Parameters parameters) {
        this.parameters = parameters;
    }

    @Override
    public List<String> getVariableNames() {
        ArrayList<String> variableNames = new ArrayList<String>();
        for (Node n : this.getVariables()) {
            variableNames.add(n.getName());
        }
        return variableNames;
    }

    @Override
    public Map<String, String> getParamSettings() {
        HashMap<String, String> paramSettings = new HashMap<String, String>();
        if (this.dataModelList == null) {
            System.out.println();
        }
        if (this.dataModelList.size() > 1) {
            paramSettings.put("# Datasets", Integer.toString(this.dataModelList.size()));
        } else {
            DataModel dataModel = this.dataModelList.get(0);
            if (dataModel instanceof CovarianceMatrix) {
                if (!paramSettings.containsKey("# Nodes")) {
                    paramSettings.put("# Vars", Integer.toString(((CovarianceMatrix)dataModel).getDimension()));
                }
                paramSettings.put("N", Integer.toString(((CovarianceMatrix)dataModel).getSampleSize()));
            } else {
                if (!paramSettings.containsKey("# Nodes")) {
                    paramSettings.put("# Vars", Integer.toString(((DataSet)dataModel).getNumColumns()));
                }
                paramSettings.put("N", Integer.toString(((DataSet)dataModel).getNumRows()));
            }
        }
        return paramSettings;
    }

    @Override
    public void setAllParamSettings(Map<String, String> paramSettings) {
        this.allParamSettings = paramSettings;
    }

    @Override
    public Map<String, String> getAllParamSettings() {
        return this.allParamSettings;
    }
}

