/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.bayes.BayesPm;
import edu.cmu.tetrad.bayes.DirichletBayesIm;
import edu.cmu.tetrad.data.KnowledgeBoxInput;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetradapp.model.BayesPmWrapper;
import edu.cmu.tetradapp.model.DirichletEstimatorWrapper;
import edu.cmu.tetradapp.model.Simulation;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;

public class DirichletBayesImWrapper
implements KnowledgeBoxInput {
    static final long serialVersionUID = 23L;
    private String name;
    private final DirichletBayesIm dirichletBayesIm;

    public DirichletBayesImWrapper(Simulation simulation) {
        throw new NullPointerException("Sorry, that was not a Dirichlet Bayes IM simulation.");
    }

    public DirichletBayesImWrapper(BayesPmWrapper bayesPmWrapper, Parameters params) {
        if (bayesPmWrapper == null) {
            throw new NullPointerException("BayesPmWrapper must not be null.");
        }
        if (params == null) {
            throw new NullPointerException("Parameters must not be null.");
        }
        BayesPm bayesPm = new BayesPm(bayesPmWrapper.getBayesPm());
        if (params.getString("initializationMode", "manual").equals("manual")) {
            this.dirichletBayesIm = DirichletBayesIm.blankDirichletIm(bayesPm);
        } else if (params.getString("initializationMode", "manual").equals("symmetricPrior")) {
            this.dirichletBayesIm = DirichletBayesIm.symmetricDirichletIm(bayesPm, params.getDouble("symmetricAlpha", 1.0));
        } else {
            throw new IllegalStateException("Expecting 'manual' or 'symmetricPrior");
        }
        this.log(this.dirichletBayesIm);
    }

    public DirichletBayesImWrapper(DirichletEstimatorWrapper wrapper) {
        if (wrapper == null) {
            throw new NullPointerException();
        }
        this.dirichletBayesIm = wrapper.getEstimatedBayesIm();
        this.log(this.dirichletBayesIm);
    }

    public static DirichletBayesImWrapper serializableInstance() {
        return new DirichletBayesImWrapper(BayesPmWrapper.serializableInstance(), new Parameters());
    }

    public DirichletBayesIm getDirichletBayesIm() {
        return this.dirichletBayesIm;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.dirichletBayesIm == null) {
            throw new NullPointerException();
        }
    }

    public Graph getGraph() {
        return this.dirichletBayesIm.getBayesPm().getDag();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Graph getSourceGraph() {
        return this.getGraph();
    }

    @Override
    public Graph getResultGraph() {
        return this.getGraph();
    }

    @Override
    public List<String> getVariableNames() {
        return this.getGraph().getNodeNames();
    }

    @Override
    public List<Node> getVariables() {
        return this.getGraph().getNodes();
    }

    private void log(DirichletBayesIm im) {
        TetradLogger.getInstance().log("info", "Dirichlet Bayes IM");
        TetradLogger.getInstance().log("im", im.toString());
    }
}

