/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.bayes.DirichletBayesIm;
import edu.cmu.tetrad.bayes.DirichletEstimator;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataUtils;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.session.SessionModel;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetradapp.model.BayesPmWrapper;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.DirichletBayesImWrapper;
import edu.cmu.tetradapp.model.PcRunner;
import java.io.IOException;
import java.io.ObjectInputStream;

public class DirichletEstimatorWrapper
implements SessionModel {
    static final long serialVersionUID = 23L;
    private String name;
    private final DirichletBayesIm dirichletBayesIm;

    public DirichletEstimatorWrapper(DataWrapper dataWrapper, DirichletBayesImWrapper dirichletPriorWrapper) {
        if (dataWrapper == null) {
            throw new NullPointerException();
        }
        if (dirichletPriorWrapper == null) {
            throw new NullPointerException();
        }
        DataSet dataSet = (DataSet)dataWrapper.getSelectedDataModel();
        if (DataUtils.containsMissingValue(dataSet)) {
            throw new IllegalArgumentException("Please remove or impute missing values.");
        }
        DirichletBayesIm dirichletBayesIm = dirichletPriorWrapper.getDirichletBayesIm();
        try {
            this.dirichletBayesIm = DirichletEstimator.estimate(dirichletBayesIm, dataSet);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Please fully specify the Dirichlet prior first.");
        }
        this.log(dirichletBayesIm);
    }

    public DirichletEstimatorWrapper(DataWrapper dataWrapper, BayesPmWrapper bayesPmWrapper, Parameters params) {
        if (dataWrapper == null) {
            throw new NullPointerException();
        }
        if (bayesPmWrapper == null) {
            throw new NullPointerException();
        }
        if (params == null) {
            throw new NullPointerException();
        }
        DataSet dataSet = (DataSet)dataWrapper.getSelectedDataModel();
        if (DataUtils.containsMissingValue(dataSet)) {
            throw new IllegalArgumentException("Please remove or impute missing values.");
        }
        DirichletBayesIm dirichletBayesIm = DirichletBayesIm.symmetricDirichletIm(bayesPmWrapper.getBayesPm(), params.getDouble("symmetricAlpha", 1.0));
        if (DataUtils.containsMissingValue(dataSet)) {
            throw new IllegalArgumentException("Please remove or impute missing values.");
        }
        try {
            this.dirichletBayesIm = DirichletEstimator.estimate(dirichletBayesIm, dataSet);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Please fully specify the Dirichlet prior first.");
        }
        this.log(dirichletBayesIm);
    }

    public static PcRunner serializableInstance() {
        return PcRunner.serializableInstance();
    }

    public DirichletBayesIm getEstimatedBayesIm() {
        return this.dirichletBayesIm;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.dirichletBayesIm == null) {
            throw new NullPointerException();
        }
    }

    public Graph getGraph() {
        return this.dirichletBayesIm.getBayesPm().getDag();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    private void log(DirichletBayesIm im) {
        TetradLogger.getInstance().log("info", "Estimated Dirichlet Bayes IM");
        TetradLogger.getInstance().log("im", "" + im);
        TetradLogger.getInstance().reset();
    }
}

