/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.session.SessionModel;
import edu.cmu.tetrad.util.Matrix;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.SemEstimatorWrapper;
import edu.cmu.tetradapp.model.SemImWrapper;
import java.text.NumberFormat;

public class EdgeWeightComparison
implements SessionModel {
    static final long serialVersionUID = 23L;
    private String name;
    private final SemIm reference;
    private final SemIm target;

    public EdgeWeightComparison(SemEstimatorWrapper reference, SemEstimatorWrapper target, Parameters parameters) {
        this.reference = reference.getEstimatedSemIm();
        this.target = target.getEstimatedSemIm();
    }

    public EdgeWeightComparison(SemImWrapper reference, SemEstimatorWrapper target, Parameters parameters) {
        this.reference = reference.getSemIm();
        this.target = target.getEstimatedSemIm();
    }

    public EdgeWeightComparison(SemImWrapper reference, SemImWrapper target, Parameters parameters) {
        this.reference = reference.getSemIm();
        this.target = target.getSemIm();
    }

    public String getDisplayString() {
        String displayString = "";
        SemIm ref = this.reference;
        Matrix referenceMatrix = ref.getEdgeCoef();
        Matrix targetMatrix = this.target.getEdgeCoef();
        if (targetMatrix.columns() != referenceMatrix.columns() || targetMatrix.rows() != referenceMatrix.rows()) {
            return "The SEM IM's you selected don't have the same number of variables!  No comparison is possible here.";
        }
        double score = 0.0;
        for (int i = 0; i < ref.getEdgeCoef().rows(); ++i) {
            for (int j = 0; j < ref.getEdgeCoef().columns(); ++j) {
                score += (targetMatrix.get(i, j) - referenceMatrix.get(i, j)) * (targetMatrix.get(i, j) - referenceMatrix.get(i, j));
            }
        }
        NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
        displayString = displayString + "Sum of squared differences of corresponding\nedge weights:\n\n" + nf.format(score);
        return displayString;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static DataWrapper serializableInstance() {
        return new DataWrapper(new Parameters());
    }
}

