/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.LayoutUtil;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.session.DoNotAddOldModel;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetradapp.model.GraphSource;
import edu.cmu.tetradapp.model.GraphWrapper;
import java.rmi.MarshalledObject;
import java.util.ArrayList;

public class ExtractStructureModelWrapper
extends GraphWrapper
implements DoNotAddOldModel {
    static final long serialVersionUID = 23L;

    public ExtractStructureModelWrapper(GraphSource source, Parameters parameters) {
        this(source.getGraph());
    }

    public ExtractStructureModelWrapper(Graph graph) {
        super(new EdgeListGraph());
        Graph graph3;
        ArrayList<Node> latents = new ArrayList<Node>();
        for (Node node : graph.getNodes()) {
            if (node.getNodeType() != NodeType.LATENT) continue;
            latents.add(node);
        }
        Graph graph2 = graph.subgraph(latents);
        try {
            graph3 = new MarshalledObject<Graph>(graph2).get();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        LayoutUtil.fruchtermanReingoldLayout(graph3);
        this.setGraph(graph3);
        TetradLogger.getInstance().log("info", "\nGenerating CPDAG from DAG.");
    }

    public static ExtractStructureModelWrapper serializableInstance() {
        return new ExtractStructureModelWrapper(EdgeListGraph.serializableInstance());
    }

    private static Graph getCPDAG(Dag dag) {
        return SearchGraphUtils.cpdagFromDag(dag);
    }

    @Override
    public boolean allowRandomGraph() {
        return false;
    }
}

