/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.graph.SemGraph;
import edu.cmu.tetrad.graph.Triple;
import edu.cmu.tetrad.search.FactorAnalysis;
import edu.cmu.tetrad.util.Matrix;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetrad.util.TextTable;
import edu.cmu.tetradapp.model.AbstractAlgorithmRunner;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.PcRunner;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.apache.commons.math3.util.FastMath;

public class FactorAnalysisRunner
extends AbstractAlgorithmRunner {
    static final long serialVersionUID = 23L;
    private String output;
    private Matrix rotatedSolution;
    private double threshold;

    private FactorAnalysisRunner(DataWrapper dataWrapper, Parameters pc) {
        super(dataWrapper, pc, null);
    }

    public static PcRunner serializableInstance() {
        return PcRunner.serializableInstance();
    }

    @Override
    public void execute() {
        int i;
        DataSet selectedModel = (DataSet)this.getDataModel();
        if (selectedModel == null) {
            throw new NullPointerException("Data not specified.");
        }
        FactorAnalysis analysis = new FactorAnalysis(selectedModel);
        this.threshold = 0.2;
        Matrix unrotatedSolution = analysis.successiveResidual();
        this.rotatedSolution = analysis.successiveFactorVarimax(unrotatedSolution);
        NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
        this.output = "Unrotated Factor Loading Matrix:\n";
        this.output = this.output + this.tableString(unrotatedSolution, nf, Double.POSITIVE_INFINITY);
        if (unrotatedSolution.columns() != 1) {
            this.output = this.output + "\n\nRotated Matrix (using sequential varimax):\n";
            this.output = this.output + this.tableString(this.rotatedSolution, nf, this.threshold);
        }
        SemGraph graph = new SemGraph();
        Vector<Node> observedVariables = new Vector<Node>();
        for (Node a : selectedModel.getVariables()) {
            graph.addNode(a);
            observedVariables.add(a);
        }
        Vector<ContinuousVariable> factors = new Vector<ContinuousVariable>();
        for (i = 0; i < this.getRotatedSolution().columns(); ++i) {
            ContinuousVariable factor = new ContinuousVariable("Factor" + (i + 1));
            factor.setNodeType(NodeType.LATENT);
            graph.addNode(factor);
            factors.add(factor);
        }
        for (i = 0; i < this.getRotatedSolution().rows(); ++i) {
            for (int j = 0; j < this.getRotatedSolution().columns(); ++j) {
                if (!(FastMath.abs(this.getRotatedSolution().get(i, j)) > this.getThreshold())) continue;
                graph.addDirectedEdge((Node)factors.get(j), (Node)observedVariables.get(i));
            }
        }
        this.setResultGraph(graph);
    }

    private String tableString(Matrix matrix, NumberFormat nf, double threshold) {
        TextTable table = new TextTable(matrix.rows() + 1, matrix.columns() + 1);
        for (int i = 0; i < matrix.rows() + 1; ++i) {
            for (int j = 0; j < matrix.columns() + 1; ++j) {
                if (i > 0 && j == 0) {
                    table.setToken(i, 0, "X" + i);
                    continue;
                }
                if (i == 0 && j > 0) {
                    table.setToken(0, j, "Factor " + j);
                    continue;
                }
                if (i <= 0) continue;
                double coefficient = matrix.get(i - 1, j - 1);
                String token = !Double.isNaN(coefficient) ? nf.format(coefficient) : "Undefined";
                token = token + (FastMath.abs(coefficient) > threshold ? "*" : " ");
                table.setToken(i, j, token);
            }
        }
        return "\n" + table;
    }

    @Override
    public Graph getGraph() {
        return this.getResultGraph();
    }

    @Override
    public List<String> getTriplesClassificationTypes() {
        return new ArrayList<String>();
    }

    @Override
    public List<List<Triple>> getTriplesLists(Node node) {
        return new ArrayList<List<Triple>>();
    }

    @Override
    public boolean supportsKnowledge() {
        return true;
    }

    @Override
    public String getAlgorithmName() {
        return "Factor Analysis";
    }

    public String getOutput() {
        return this.output;
    }

    private Matrix getRotatedSolution() {
        return this.rotatedSolution;
    }

    private double getThreshold() {
        return this.threshold;
    }
}

