/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataModelList;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.LayoutUtil;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.Triple;
import edu.cmu.tetrad.search.BDeuScore;
import edu.cmu.tetrad.search.BdeuScoreImages;
import edu.cmu.tetrad.search.ConditionalGaussianScore;
import edu.cmu.tetrad.search.Fges;
import edu.cmu.tetrad.search.GraphScore;
import edu.cmu.tetrad.search.GraphScorer;
import edu.cmu.tetrad.search.ImpliedOrientation;
import edu.cmu.tetrad.search.MeekRules;
import edu.cmu.tetrad.search.ScoredGraph;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.search.SemBicScore;
import edu.cmu.tetrad.search.SemBicScoreImages;
import edu.cmu.tetrad.session.DoNotAddOldModel;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetrad.util.TetradSerializable;
import edu.cmu.tetradapp.model.AbstractAlgorithmRunner;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.GraphSource;
import edu.cmu.tetradapp.model.GraphWrapper;
import edu.cmu.tetradapp.model.IFgesRunner;
import edu.cmu.tetradapp.model.IGesRunner;
import edu.cmu.tetradapp.model.Indexable;
import edu.cmu.tetradapp.model.KnowledgeBoxModel;
import edu.cmu.tetradapp.model.MergeDatasetsWrapper;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class FgesRunner
extends AbstractAlgorithmRunner
implements IFgesRunner,
PropertyChangeListener,
IGesRunner,
Indexable,
DoNotAddOldModel {
    static final long serialVersionUID = 23L;
    private transient List<PropertyChangeListener> listeners;
    private List<ScoredGraph> topGraphs;
    private int index;
    private transient Fges fges;
    private transient Graph externalGraph;

    public FgesRunner(DataWrapper[] dataWrappers, Parameters params, KnowledgeBoxModel knowledgeBoxModel) {
        super(new MergeDatasetsWrapper(dataWrappers, params), params, knowledgeBoxModel);
    }

    public FgesRunner(DataWrapper[] dataWrappers, Parameters params) {
        super(new MergeDatasetsWrapper(dataWrappers, params), params, null);
    }

    public FgesRunner(DataWrapper[] dataWrappers, GraphSource graph, Parameters params) {
        super(new MergeDatasetsWrapper(dataWrappers, params), params, null);
        if (graph == this) {
            throw new IllegalArgumentException();
        }
        this.externalGraph = graph.getGraph();
    }

    public FgesRunner(DataWrapper[] dataWrappers, GraphSource graph, Parameters params, KnowledgeBoxModel knowledgeBoxModel) {
        super(new MergeDatasetsWrapper(dataWrappers, params), params, knowledgeBoxModel);
        if (graph == this) {
            throw new IllegalArgumentException();
        }
        this.externalGraph = graph.getGraph();
    }

    public FgesRunner(GraphWrapper graphWrapper, Parameters params, KnowledgeBoxModel knowledgeBoxModel) {
        super(graphWrapper.getGraph(), params, knowledgeBoxModel);
    }

    public FgesRunner(GraphWrapper graphWrapper, Parameters params) {
        super(graphWrapper.getGraph(), params, null);
    }

    public static DataWrapper serializableInstance() {
        return new DataWrapper(new Parameters());
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute() {
        void var1_3;
        System.out.println("A");
        DataModel dataModel = this.getDataModel();
        if (dataModel == null && this.getSourceGraph() != null) {
            Graph graph = this.getSourceGraph();
        }
        if (var1_3 == null) {
            throw new RuntimeException("Data source is unspecified. You may need to double click all your data boxes, \nthen click Save, and then right click on them and select Propagate Downstream. \nThe issue is that we use a seed to simulate from IM's, so your data is not saved to \nfile when you save the session. It can, however, be recreated from the saved seed.");
        }
        Parameters params = this.getParams();
        if (var1_3 instanceof Graph) {
            GraphScore gesScore = new GraphScore((Graph)var1_3);
            this.fges = new Fges(gesScore);
            this.fges.setKnowledge((Knowledge)this.getParams().get("knowledge", new Knowledge()));
            this.fges.setVerbose(true);
        } else {
            double penaltyDiscount = params.getDouble("penaltyDiscount", 4.0);
            if (var1_3 instanceof DataSet) {
                DataSet dataSet = (DataSet)var1_3;
                if (dataSet.isContinuous()) {
                    SemBicScore gesScore = new SemBicScore(new CovarianceMatrix((DataSet)var1_3));
                    gesScore.setPenaltyDiscount(penaltyDiscount);
                    System.out.println("Score done");
                    this.fges = new Fges(gesScore);
                } else if (dataSet.isDiscrete()) {
                    double samplePrior = this.getParams().getDouble("samplePrior", 1.0);
                    double structurePrior = this.getParams().getDouble("structurePrior", 1.0);
                    BDeuScore score = new BDeuScore(dataSet);
                    score.setSamplePrior(samplePrior);
                    score.setStructurePrior(structurePrior);
                    this.fges = new Fges(score);
                } else {
                    ConditionalGaussianScore gesScore = new ConditionalGaussianScore(dataSet, 1.0, 1.0, false);
                    gesScore.setPenaltyDiscount(penaltyDiscount);
                    this.fges = new Fges(gesScore);
                }
            } else if (var1_3 instanceof ICovarianceMatrix) {
                SemBicScore gesScore = new SemBicScore((ICovarianceMatrix)var1_3);
                gesScore.setPenaltyDiscount(penaltyDiscount);
                gesScore.setPenaltyDiscount(penaltyDiscount);
                this.fges = new Fges(gesScore);
            } else if (var1_3 instanceof DataModelList) {
                DataModelList list = (DataModelList)var1_3;
                for (DataModel dataModel2 : list) {
                    if (dataModel2 instanceof DataSet || dataModel2 instanceof ICovarianceMatrix) continue;
                    throw new IllegalArgumentException("Need a combination of all continuous data sets or covariance matrices, or else all discrete data sets, or else a single externalGraph.");
                }
                if (list.size() != 1) {
                    throw new IllegalArgumentException("FGES takes exactly one data set, covariance matrix, or externalGraph as input. For multiple data sets as input, use IMaGES.");
                }
                if (this.allContinuous(list)) {
                    double penalty = this.getParams().getDouble("penaltyDiscount", 4.0);
                    if (params.getBoolean("firstNontriangular", false)) {
                        SemBicScoreImages fgesScore = new SemBicScoreImages(list);
                        fgesScore.setPenaltyDiscount(penalty);
                        this.fges = new Fges(fgesScore);
                    } else {
                        SemBicScoreImages fgesScore = new SemBicScoreImages(list);
                        fgesScore.setPenaltyDiscount(penalty);
                        this.fges = new Fges(fgesScore);
                    }
                } else {
                    if (!this.allDiscrete(list)) throw new IllegalArgumentException("Data must be either all discrete or all continuous.");
                    double structurePrior = this.getParams().getDouble("structurePrior", 1.0);
                    double samplePrior = this.getParams().getDouble("samplePrior", 1.0);
                    BdeuScoreImages fgesScore = new BdeuScoreImages(list);
                    fgesScore.setSamplePrior(samplePrior);
                    fgesScore.setStructurePrior(structurePrior);
                    this.fges = params.getBoolean("firstNontriangular", false) ? new Fges(fgesScore) : new Fges(fgesScore);
                }
            } else {
                System.out.println("No viable input.");
            }
        }
        this.fges.setBoundGraph(this.externalGraph);
        this.fges.setKnowledge((Knowledge)this.getParams().get("knowledge", new Knowledge()));
        this.fges.setVerbose(true);
        Graph graph = this.fges.search();
        if (this.getSourceGraph() != null) {
            LayoutUtil.arrangeBySourceGraph(graph, this.getSourceGraph());
        } else if (((Knowledge)this.getParams().get("knowledge", new Knowledge())).isDefaultToKnowledgeLayout()) {
            SearchGraphUtils.arrangeByKnowledgeTiers(graph, (Knowledge)this.getParams().get("knowledge", new Knowledge()));
        } else {
            LayoutUtil.circleLayout(graph, 200, 200, 150);
        }
        this.setResultGraph(graph);
        this.topGraphs = new ArrayList<ScoredGraph>(this.fges.getTopGraphs());
        if (this.topGraphs.isEmpty()) {
            this.topGraphs.add(new ScoredGraph(this.getResultGraph(), Double.NaN));
        }
        this.setIndex(this.topGraphs.size() - 1);
    }

    @Override
    public Type getType() {
        Type type;
        TetradSerializable model = this.getDataModel();
        if (model == null && this.getSourceGraph() != null) {
            model = this.getSourceGraph();
        }
        if (model == null) {
            throw new RuntimeException("Data source is unspecified. You may need to double click all your data boxes, \nthen click Save, and then right click on them and select Propagate Downstream. \nThe issue is that we use a seed to simulate from IM's, so your data is not saved to \nfile when you save the session. It can, however, be recreated from the saved seed.");
        }
        if (model instanceof Graph) {
            type = Type.GRAPH;
        } else if (model instanceof DataSet) {
            DataSet dataSet = (DataSet)model;
            type = dataSet.isContinuous() ? Type.CONTINUOUS : (dataSet.isDiscrete() ? Type.DISCRETE : Type.MIXED);
        } else if (model instanceof ICovarianceMatrix) {
            type = Type.CONTINUOUS;
        } else if (model instanceof DataModelList) {
            DataModelList list = (DataModelList)model;
            type = this.allContinuous(list) ? Type.CONTINUOUS : (this.allDiscrete(list) ? Type.DISCRETE : Type.MIXED);
        } else {
            throw new IllegalArgumentException("Unrecognized data type.");
        }
        return type;
    }

    private boolean allContinuous(List<DataModel> dataModels) {
        for (DataModel dataModel : dataModels) {
            if (!(dataModel instanceof DataSet) || dataModel.isContinuous() && !(dataModel instanceof ICovarianceMatrix)) continue;
            return false;
        }
        return true;
    }

    private boolean allDiscrete(List<DataModel> dataModels) {
        for (DataModel dataModel : dataModels) {
            if (!(dataModel instanceof DataSet) || dataModel.isDiscrete()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setIndex(int index) {
        if (index < -1) {
            throw new IllegalArgumentException("Must be in >= -1: " + index);
        }
        this.index = index;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public Graph getGraph() {
        if (this.getIndex() >= 0) {
            return this.getTopGraphs().get(this.getIndex()).getGraph();
        }
        return this.getResultGraph();
    }

    @Override
    public List<String> getTriplesClassificationTypes() {
        return new ArrayList<String>();
    }

    @Override
    public List<List<Triple>> getTriplesLists(Node node) {
        return new ArrayList<List<Triple>>();
    }

    @Override
    public boolean supportsKnowledge() {
        return true;
    }

    @Override
    public ImpliedOrientation getMeekRules() {
        MeekRules rules = new MeekRules();
        rules.setKnowledge((Knowledge)this.getParams().get("knowledge", new Knowledge()));
        return rules;
    }

    @Override
    public Map<String, String> getParamSettings() {
        super.getParamSettings();
        Parameters params = this.getParams();
        this.paramSettings.put("Penalty Discount", new DecimalFormat("0.0").format(params.getDouble("penaltyDiscount", 4.0)));
        return this.paramSettings;
    }

    @Override
    public String getAlgorithmName() {
        return "FGES";
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.firePropertyChange(evt);
    }

    private void firePropertyChange(PropertyChangeEvent evt) {
        for (PropertyChangeListener l : this.getListeners()) {
            l.propertyChange(evt);
        }
    }

    private List<PropertyChangeListener> getListeners() {
        if (this.listeners == null) {
            this.listeners = new ArrayList<PropertyChangeListener>();
        }
        return this.listeners;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (!this.getListeners().contains(l)) {
            this.getListeners().add(l);
        }
    }

    @Override
    public List<ScoredGraph> getTopGraphs() {
        return this.topGraphs;
    }

    public String getBayesFactorsReport(Graph dag) {
        if (this.fges == null) {
            return "Please re-run IMaGES.";
        }
        return this.fges.logEdgeBayesFactorsString(dag);
    }

    public GraphScorer getGraphScorer() {
        return this.fges;
    }

    public static enum Type {
        CONTINUOUS,
        DISCRETE,
        MIXED,
        GRAPH;

    }
}

