/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.algcomparison.algorithm.Algorithm;
import edu.cmu.tetrad.algcomparison.algorithm.MultiDataSetAlgorithm;
import edu.cmu.tetrad.algcomparison.algorithm.cluster.ClusterAlgorithm;
import edu.cmu.tetrad.algcomparison.independence.DSeparationTest;
import edu.cmu.tetrad.algcomparison.independence.IndependenceWrapper;
import edu.cmu.tetrad.algcomparison.independence.TakesGraph;
import edu.cmu.tetrad.algcomparison.score.DSeparationScore;
import edu.cmu.tetrad.algcomparison.score.ScoreWrapper;
import edu.cmu.tetrad.algcomparison.utils.HasKnowledge;
import edu.cmu.tetrad.algcomparison.utils.TakesIndependenceWrapper;
import edu.cmu.tetrad.algcomparison.utils.UsesScoreWrapper;
import edu.cmu.tetrad.data.BoxDataSet;
import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataModelList;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataType;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.data.KnowledgeBoxInput;
import edu.cmu.tetrad.data.VerticalDoubleDataBox;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.LayoutUtil;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.Triple;
import edu.cmu.tetrad.search.ImpliedOrientation;
import edu.cmu.tetrad.search.IndTestScore;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.Score;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.search.TimeSeriesUtils;
import edu.cmu.tetrad.session.ParamsResettable;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetrad.util.RandomUtil;
import edu.cmu.tetrad.util.Unmarshallable;
import edu.cmu.tetradapp.model.AlgorithmRunner;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.GraphSource;
import edu.cmu.tetradapp.model.IndTestProducer;
import edu.cmu.tetradapp.model.IndependenceFactsModel;
import edu.cmu.tetradapp.model.KnowledgeBoxModel;
import edu.cmu.tetradapp.model.Simulation;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GeneralAlgorithmRunner
implements AlgorithmRunner,
ParamsResettable,
Unmarshallable,
IndTestProducer,
KnowledgeBoxInput {
    static final long serialVersionUID = 23L;
    private DataWrapper dataWrapper;
    private String name;
    private Algorithm algorithm;
    private Parameters parameters;
    private Graph sourceGraph;
    private Graph externalGraph;
    private List<Graph> graphList = new ArrayList<Graph>();
    private Knowledge knowledge;
    private final Map<String, Object> userAlgoSelections = new HashMap<String, Object>();
    private transient List<IndependenceTest> independenceTests;

    public GeneralAlgorithmRunner(GeneralAlgorithmRunner runner, Parameters parameters) {
        this(runner.getDataWrapper(), (GraphSource)runner, parameters, null, null);
        this.sourceGraph = runner.sourceGraph;
        this.knowledge = runner.knowledge;
        this.algorithm = runner.algorithm;
        this.parameters = parameters;
        this.userAlgoSelections.putAll(runner.userAlgoSelections);
    }

    public GeneralAlgorithmRunner(DataWrapper dataWrapper, Parameters parameters) {
        this(dataWrapper, null, parameters, null, null);
    }

    public GeneralAlgorithmRunner(DataWrapper dataWrapper, Parameters parameters, KnowledgeBoxModel knowledgeBoxModel) {
        this(dataWrapper, null, parameters, knowledgeBoxModel, null);
    }

    public GeneralAlgorithmRunner(DataWrapper dataWrapper, GraphSource graphSource, Parameters parameters) {
        this(dataWrapper, graphSource, parameters, null, null);
    }

    public GeneralAlgorithmRunner(DataWrapper dataWrapper, GraphSource graphSource, KnowledgeBoxModel knowledgeBoxModel, Parameters parameters) {
        this(dataWrapper, graphSource, parameters, knowledgeBoxModel, null);
    }

    public GeneralAlgorithmRunner(DataWrapper dataWrapper, Parameters parameters, KnowledgeBoxModel knowledgeBoxModel, IndependenceFactsModel facts) {
        this(dataWrapper, null, parameters, knowledgeBoxModel, facts);
    }

    public GeneralAlgorithmRunner(DataWrapper dataWrapper, GeneralAlgorithmRunner runner, Parameters parameters) {
        this(dataWrapper, null, parameters, null, null);
        this.algorithm = runner.algorithm;
        this.userAlgoSelections.putAll(runner.userAlgoSelections);
    }

    public GeneralAlgorithmRunner(DataWrapper dataWrapper, GeneralAlgorithmRunner runner, Parameters parameters, KnowledgeBoxModel knowledgeBoxModel) {
        this(dataWrapper, null, parameters, knowledgeBoxModel, null);
        this.algorithm = runner.algorithm;
        this.userAlgoSelections.putAll(runner.userAlgoSelections);
    }

    public GeneralAlgorithmRunner(DataWrapper dataWrapper, GraphSource graphSource, GeneralAlgorithmRunner runner, Parameters parameters) {
        this(dataWrapper, graphSource, parameters, null, null);
        this.algorithm = runner.algorithm;
        this.userAlgoSelections.putAll(runner.userAlgoSelections);
    }

    public GeneralAlgorithmRunner(DataWrapper dataWrapper, GraphSource graphSource, GeneralAlgorithmRunner runner, Parameters parameters, KnowledgeBoxModel knowledgeBoxModel) {
        this(dataWrapper, graphSource, parameters, knowledgeBoxModel, null);
        this.algorithm = runner.algorithm;
        this.userAlgoSelections.putAll(runner.userAlgoSelections);
    }

    public GeneralAlgorithmRunner(GraphSource graphSource, GeneralAlgorithmRunner runner, Parameters parameters) {
        this(null, graphSource, parameters, null, null);
        this.algorithm = runner.algorithm;
        this.userAlgoSelections.putAll(runner.userAlgoSelections);
    }

    public GeneralAlgorithmRunner(GraphSource graphSource, Parameters parameters, KnowledgeBoxModel knowledgeBoxModel) {
        this(null, graphSource, parameters, knowledgeBoxModel, null);
    }

    public GeneralAlgorithmRunner(IndependenceFactsModel model, Parameters parameters, KnowledgeBoxModel knowledgeBoxModel) {
        this(null, null, parameters, knowledgeBoxModel, model);
    }

    public GeneralAlgorithmRunner(GraphSource graphSource, Parameters parameters) {
        this(null, graphSource, parameters, null, null);
    }

    public GeneralAlgorithmRunner(DataWrapper dataWrapper, GraphSource graphSource, Parameters parameters, KnowledgeBoxModel knowledgeBoxModel, IndependenceFactsModel facts) {
        if (parameters == null) {
            throw new NullPointerException();
        }
        this.parameters = parameters;
        if (graphSource instanceof GeneralAlgorithmRunner) {
            this.algorithm = ((GeneralAlgorithmRunner)graphSource).getAlgorithm();
        }
        if (dataWrapper != null) {
            this.dataWrapper = dataWrapper;
            if (dataWrapper.getDataModelList().isEmpty() && dataWrapper instanceof Simulation) {
                ((Simulation)dataWrapper).createSimulation();
            }
        }
        if (graphSource != null) {
            if (dataWrapper == null && graphSource instanceof DataWrapper) {
                this.dataWrapper = (DataWrapper)((Object)graphSource);
            } else {
                this.sourceGraph = graphSource.getGraph();
            }
        }
        if (dataWrapper != null) {
            List<String> names = this.dataWrapper.getVariableNames();
            this.transferVarNamesToParams(names);
        }
        this.knowledge = knowledgeBoxModel != null ? knowledgeBoxModel.getKnowledge() : new Knowledge();
        if (facts != null) {
            this.getParameters().set("independenceFacts", (Object)facts.getFacts());
        }
    }

    @Override
    public void execute() {
        ArrayList<Graph> graphList = new ArrayList<Graph>();
        if (this.independenceTests != null) {
            this.independenceTests.clear();
        }
        Algorithm algo = this.getAlgorithm();
        if (this.knowledge != null && !this.knowledge.isEmpty()) {
            if (algo instanceof HasKnowledge) {
                ((HasKnowledge)((Object)algo)).setKnowledge(this.knowledge.copy());
            } else {
                throw new IllegalArgumentException("Knowledge has been supplied, but this algorithm does not use knowledge.");
            }
        }
        if (this.getDataModelList().size() == 0 && this.getSourceGraph() != null) {
            IndependenceWrapper wrapper;
            ScoreWrapper scoreWrapper;
            if (algo instanceof UsesScoreWrapper && (scoreWrapper = ((UsesScoreWrapper)((Object)algo)).getScoreWrapper()) instanceof DSeparationScore) {
                ((DSeparationScore)scoreWrapper).setGraph(this.getSourceGraph());
            }
            if (algo instanceof TakesIndependenceWrapper && (wrapper = ((TakesIndependenceWrapper)((Object)algo)).getIndependenceWrapper()) instanceof DSeparationTest) {
                ((DSeparationTest)wrapper).setGraph(this.getSourceGraph());
            }
            if (algo instanceof TakesGraph) {
                ((TakesGraph)((Object)algo)).setGraph(this.sourceGraph);
            }
            if (this.algorithm instanceof HasKnowledge) {
                Knowledge knowledge1 = TimeSeriesUtils.getKnowledge(this.getSourceGraph());
                if (this.knowledge.isEmpty() && !knowledge1.isEmpty()) {
                    ((HasKnowledge)((Object)algo)).setKnowledge(knowledge1);
                } else {
                    ((HasKnowledge)((Object)this.algorithm)).setKnowledge(this.knowledge.copy());
                }
            }
            Graph graph = algo.search(null, this.parameters);
            LayoutUtil.circleLayout(graph, 200, 200, 150);
            graphList.add(graph);
        } else if (this.getAlgorithm() instanceof MultiDataSetAlgorithm) {
            for (int k = 0; k < this.parameters.getInt("numRuns"); ++k) {
                Knowledge knowledge1 = this.getDataModelList().get(0).getKnowledge();
                ArrayList<DataModel> dataSets = new ArrayList<DataModel>(this.getDataModelList());
                for (DataModel dataSet : dataSets) {
                    dataSet.setKnowledge(knowledge1);
                }
                int randomSelectionSize = this.parameters.getInt("randomSelectionSize");
                if (randomSelectionSize == 0) {
                    randomSelectionSize = dataSets.size();
                }
                if (dataSets.size() < randomSelectionSize) {
                    throw new IllegalArgumentException("Sorry, the 'random selection size' is greater than the number of data sets: " + randomSelectionSize + " > " + dataSets.size());
                }
                RandomUtil.shuffle(dataSets);
                ArrayList<DataModel> sub = new ArrayList<DataModel>();
                for (int j = 0; j < randomSelectionSize; ++j) {
                    sub.add((DataModel)dataSets.get(j));
                }
                if (algo instanceof TakesGraph) {
                    ((TakesGraph)((Object)algo)).setGraph(this.sourceGraph);
                }
                if (this.algorithm instanceof HasKnowledge) {
                    ((HasKnowledge)((Object)this.algorithm)).setKnowledge(this.knowledge.copy());
                }
                graphList.add(((MultiDataSetAlgorithm)algo).search(sub, this.parameters));
            }
        } else if (this.getAlgorithm() instanceof ClusterAlgorithm) {
            for (int k = 0; k < this.parameters.getInt("numRuns"); ++k) {
                this.getDataModelList().forEach(dataModel -> {
                    if (dataModel instanceof ICovarianceMatrix) {
                        ICovarianceMatrix dataSet = (ICovarianceMatrix)dataModel;
                        if (algo instanceof TakesGraph) {
                            ((TakesGraph)((Object)algo)).setGraph(this.sourceGraph);
                        }
                        if (this.algorithm instanceof HasKnowledge) {
                            ((HasKnowledge)((Object)this.algorithm)).setKnowledge(this.knowledge.copy());
                        }
                        Graph graph = this.algorithm.search(dataSet, this.parameters);
                        LayoutUtil.circleLayout(graph, 200, 200, 150);
                        graphList.add(graph);
                    } else if (dataModel instanceof DataSet) {
                        DataSet dataSet = (DataSet)dataModel;
                        if (!dataSet.isContinuous()) {
                            throw new IllegalArgumentException("Sorry, you need a continuous dataset for a cluster algorithm.");
                        }
                        if (algo instanceof TakesGraph) {
                            ((TakesGraph)((Object)algo)).setGraph(this.sourceGraph);
                        }
                        if (this.algorithm instanceof HasKnowledge) {
                            ((HasKnowledge)((Object)this.algorithm)).setKnowledge(this.knowledge.copy());
                        }
                        Graph graph = this.algorithm.search(dataSet, this.parameters);
                        LayoutUtil.circleLayout(graph, 200, 200, 150);
                        graphList.add(graph);
                    }
                });
            }
        } else {
            if (this.getDataModelList().size() != 1) {
                throw new IllegalArgumentException("Expecting a single dataset here.");
            }
            if (algo != null) {
                this.getDataModelList().forEach(data -> {
                    Knowledge knowledgeFromData = data.getKnowledge();
                    if (knowledgeFromData != null && !knowledgeFromData.getVariables().isEmpty()) {
                        this.knowledge = knowledgeFromData;
                    }
                    DataType algDataType = algo.getDataType();
                    if (algo instanceof TakesGraph) {
                        ((TakesGraph)((Object)algo)).setGraph(this.sourceGraph);
                    }
                    if (this.algorithm instanceof HasKnowledge) {
                        ((HasKnowledge)((Object)this.algorithm)).setKnowledge(this.knowledge.copy());
                    }
                    if (data.isContinuous() && (algDataType == DataType.Continuous || algDataType == DataType.Mixed)) {
                        Graph graph = algo.search((DataModel)data, this.parameters);
                        LayoutUtil.circleLayout(graph, 200, 200, 150);
                        graphList.add(graph);
                    } else if (data.isDiscrete() && (algDataType == DataType.Discrete || algDataType == DataType.Mixed)) {
                        Graph graph = algo.search((DataModel)data, this.parameters);
                        LayoutUtil.circleLayout(graph, 200, 200, 150);
                        graphList.add(graph);
                    } else if (data.isMixed() && algDataType == DataType.Mixed) {
                        Graph graph = algo.search((DataModel)data, this.parameters);
                        LayoutUtil.circleLayout(graph, 200, 200, 150);
                        graphList.add(graph);
                    } else {
                        throw new IllegalArgumentException("The algorithm was not expecting that type of data.");
                    }
                });
            }
        }
        if (algo instanceof HasKnowledge && ((HasKnowledge)((Object)algo)).getKnowledge().getNumTiers() > 0) {
            Knowledge _knowledge = ((HasKnowledge)((Object)algo)).getKnowledge();
            if (_knowledge.getVariablesNotInTiers().size() < _knowledge.getVariables().size()) {
                for (Graph graph : graphList) {
                    SearchGraphUtils.arrangeByKnowledgeTiers(graph, _knowledge);
                }
            }
        } else {
            for (Graph graph : graphList) {
                LayoutUtil.circleLayout(graph, 225, 200, 150);
            }
        }
        this.graphList = graphList;
    }

    public boolean hasMissingValues() {
        DataModelList dataModelList = this.getDataModelList();
        if (dataModelList.containsEmptyData()) {
            return false;
        }
        if (dataModelList.get(0) instanceof CovarianceMatrix) {
            return false;
        }
        DataSet dataSet = (DataSet)dataModelList.get(0);
        return dataSet.existsMissingValue();
    }

    @Override
    public boolean supportsKnowledge() {
        return false;
    }

    @Override
    public ImpliedOrientation getMeekRules() {
        return null;
    }

    @Override
    public void setExternalGraph(Graph graph) {
        this.externalGraph = graph;
    }

    @Override
    public Graph getExternalGraph() {
        return this.externalGraph;
    }

    @Override
    public String getAlgorithmName() {
        return null;
    }

    @Override
    public final Graph getSourceGraph() {
        return this.sourceGraph;
    }

    @Override
    public Graph getResultGraph() {
        return this.getGraph();
    }

    @Override
    public final DataModel getDataModel() {
        if (this.dataWrapper != null) {
            DataModelList dataModelList = this.dataWrapper.getDataModelList();
            if (dataModelList.size() == 1) {
                return dataModelList.get(0);
            }
            return dataModelList;
        }
        return new BoxDataSet(new VerticalDoubleDataBox(0, 0), new ArrayList<Node>());
    }

    @Override
    public Parameters getParams() {
        return null;
    }

    public final DataModelList getDataModelList() {
        if (this.dataWrapper == null) {
            return new DataModelList();
        }
        return this.dataWrapper.getDataModelList();
    }

    public final Parameters getParameters() {
        return this.parameters;
    }

    @Override
    public Object getResettableParams() {
        return this.getParameters();
    }

    @Override
    public void resetParams(Object params) {
        this.parameters = (Parameters)params;
    }

    private void transferVarNamesToParams(List<String> names) {
        this.getParameters().set("varNames", (Object)names);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
    }

    @Override
    public IndependenceTest getIndependenceTest() {
        if (this.independenceTests == null) {
            this.independenceTests = new ArrayList<IndependenceTest>();
        }
        if (this.independenceTests.size() == 1) {
            return this.independenceTests.get(0);
        }
        Algorithm algo = this.getAlgorithm();
        if (this.getDataModelList().size() == 0 && this.getSourceGraph() != null) {
            DSeparationTest test = new DSeparationTest(this.getSourceGraph());
            if (this.independenceTests == null) {
                this.independenceTests = new ArrayList<IndependenceTest>();
            }
            this.independenceTests.add(test.getTest(null, this.parameters));
        } else if (algo instanceof TakesIndependenceWrapper) {
            if (this.getDataModelList().size() == 1) {
                IndependenceWrapper indTestWrapper = ((TakesIndependenceWrapper)((Object)this.getAlgorithm())).getIndependenceWrapper();
                if (this.independenceTests == null) {
                    this.independenceTests = new ArrayList<IndependenceTest>();
                }
                IndependenceTest test = indTestWrapper.getTest(this.getDataModelList().get(0), this.parameters);
                this.independenceTests.add(test);
            }
        } else if (algo instanceof UsesScoreWrapper && this.getDataModelList().size() == 1) {
            ScoreWrapper wrapper = ((UsesScoreWrapper)((Object)this.getAlgorithm())).getScoreWrapper();
            if (this.independenceTests == null) {
                this.independenceTests = new ArrayList<IndependenceTest>();
            }
            Score score = wrapper.getScore(this.getDataModelList().get(0), this.parameters);
            this.independenceTests.add(new IndTestScore(score));
        }
        if (this.independenceTests.isEmpty()) {
            throw new IllegalArgumentException("One or more of the parents was a search that didn't use a test or a score.");
        }
        return this.independenceTests.get(0);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(Algorithm algorithm) {
        if (algorithm == null) {
            throw new NullPointerException("Algorithm not specified");
        }
        this.algorithm = algorithm;
    }

    @Override
    public List<String> getTriplesClassificationTypes() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public List<List<Triple>> getTriplesLists(Node node) {
        return Collections.EMPTY_LIST;
    }

    @Override
    public Map<String, String> getParamSettings() {
        return Collections.EMPTY_MAP;
    }

    @Override
    public void setAllParamSettings(Map<String, String> paramSettings) {
    }

    @Override
    public Map<String, String> getAllParamSettings() {
        return Collections.EMPTY_MAP;
    }

    @Override
    public Graph getGraph() {
        if (this.graphList == null || this.graphList.isEmpty()) {
            return null;
        }
        Graph graph = this.graphList.get(0);
        LayoutUtil.circleLayout(graph, 225, 225, 180);
        return graph;
    }

    @Override
    public List<Graph> getGraphs() {
        return this.graphList;
    }

    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    public DataWrapper getDataWrapper() {
        return this.dataWrapper;
    }

    @Override
    public List<Node> getVariables() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public List<String> getVariableNames() {
        return Collections.EMPTY_LIST;
    }

    public List<Graph> getCompareGraphs(List<Graph> graphs) {
        if (graphs == null) {
            throw new NullPointerException();
        }
        ArrayList<Graph> compareGraphs = new ArrayList<Graph>();
        for (Graph graph : graphs) {
            compareGraphs.add(this.algorithm.getComparisonGraph(graph));
        }
        return compareGraphs;
    }

    public Map<String, Object> getUserAlgoSelections() {
        return this.userAlgoSelections;
    }
}

