/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.sem.GeneralizedSemEstimator;
import edu.cmu.tetrad.sem.GeneralizedSemIm;
import edu.cmu.tetrad.sem.GeneralizedSemPm;
import edu.cmu.tetrad.session.SessionModel;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.GeneralizedSemPmWrapper;
import edu.cmu.tetradapp.model.GraphSource;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;

public class GeneralizedSemEstimatorWrapper
implements SessionModel,
GraphSource {
    static final long serialVersionUID = 23L;
    private String name;
    private GeneralizedSemPm semPm;
    private final DataSet data;
    private boolean showErrors;
    private GeneralizedSemIm estIm;
    private String report = "";

    public GeneralizedSemEstimatorWrapper(GeneralizedSemPmWrapper semPm, DataWrapper data) {
        if (semPm == null) {
            throw new NullPointerException("SEM PM must not be null.");
        }
        this.semPm = semPm.getSemPm();
        this.data = (DataSet)data.getSelectedDataModel();
        this.execute();
    }

    public void execute() {
        GeneralizedSemEstimator estimator = new GeneralizedSemEstimator();
        this.estIm = estimator.estimate(this.semPm, this.data);
        this.report = estimator.getReport();
    }

    public static Node serializableInstance() {
        return new GraphNode("X");
    }

    public GeneralizedSemIm getSemIm() {
        return this.estIm;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
    }

    @Override
    public Graph getGraph() {
        return this.semPm.getGraph();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public boolean isShowErrors() {
        return this.showErrors;
    }

    public void setShowErrors(boolean showErrors) {
        this.showErrors = showErrors;
    }

    private void log(GeneralizedSemIm im) {
        TetradLogger.getInstance().log("info", "Generalized SEM IM");
        TetradLogger.getInstance().log("im", im.toString());
    }

    public Graph getSourceGraph() {
        return this.getGraph();
    }

    public Graph getResultGraph() {
        return this.getGraph();
    }

    public List<String> getVariableNames() {
        return this.getGraph().getNodeNames();
    }

    public List<Node> getVariables() {
        return this.getGraph().getNodes();
    }

    public GeneralizedSemPm getSemPm() {
        return this.semPm;
    }

    public void setSemPm(GeneralizedSemPm semPm) {
        this.semPm = semPm;
    }

    public String getReport() {
        return this.report;
    }
}

