/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.algcomparison.simulation.GeneralSemSimulation;
import edu.cmu.tetrad.data.KnowledgeBoxInput;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.sem.GeneralizedSemIm;
import edu.cmu.tetrad.sem.GeneralizedSemPm;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetradapp.model.GeneralizedSemPmWrapper;
import edu.cmu.tetradapp.model.SemImWrapper;
import edu.cmu.tetradapp.model.Simulation;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;

public class GeneralizedSemImWrapper
implements KnowledgeBoxInput {
    static final long serialVersionUID = 23L;
    private String name;
    private List<GeneralizedSemIm> semIms = new ArrayList<GeneralizedSemIm>();
    private boolean showErrors;

    public GeneralizedSemImWrapper(Simulation simulation) {
        List<Object> semIms = new ArrayList();
        if (simulation == null) {
            throw new NullPointerException("The Simulation box does not contain a simulation.");
        }
        edu.cmu.tetrad.algcomparison.simulation.Simulation _simulation = simulation.getSimulation();
        if (_simulation == null) {
            throw new NullPointerException("No data sets have been simulated.");
        }
        if (!(_simulation instanceof GeneralSemSimulation)) {
            throw new IllegalArgumentException("That was not Generalized SEM simulation. Sorry.");
        }
        semIms = ((GeneralSemSimulation)_simulation).getIms();
        if (semIms.isEmpty()) {
            throw new NullPointerException("It looks like you have not done a simulation.");
        }
        this.semIms = semIms;
        if (semIms.size() > 1) {
            throw new IllegalArgumentException("I'm sorry; this editor can only edit a single generalized SEM IM.");
        }
    }

    private GeneralizedSemImWrapper(GeneralizedSemPm semPm) {
        if (semPm == null) {
            throw new NullPointerException("SEM PM must not be null.");
        }
        this.semIms.add(new GeneralizedSemIm(semPm));
    }

    public GeneralizedSemImWrapper(GeneralizedSemPmWrapper wrapper) {
        this(wrapper.getSemPm());
    }

    public GeneralizedSemImWrapper(GeneralizedSemPmWrapper genSemPm, SemImWrapper imWrapper) {
        this.semIms.add(new GeneralizedSemIm(genSemPm.getSemPm(), imWrapper.getSemIm()));
    }

    public static GeneralizedSemImWrapper serializableInstance() {
        return new GeneralizedSemImWrapper(GeneralizedSemPmWrapper.serializableInstance());
    }

    public List<GeneralizedSemIm> getSemIms() {
        return this.semIms;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.semIms == null) {
            throw new NullPointerException();
        }
    }

    public Graph getGraph() {
        return this.semIms.get(0).getSemPm().getGraph();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public boolean isShowErrors() {
        return this.showErrors;
    }

    public void setShowErrors(boolean showErrors) {
        this.showErrors = showErrors;
    }

    private void log(GeneralizedSemIm im) {
        TetradLogger.getInstance().log("info", "Generalized SEM IM");
        TetradLogger.getInstance().log("im", im.toString());
    }

    @Override
    public Graph getSourceGraph() {
        return this.getGraph();
    }

    @Override
    public Graph getResultGraph() {
        return this.getGraph();
    }

    @Override
    public List<String> getVariableNames() {
        return this.getGraph().getNodeNames();
    }

    @Override
    public List<Node> getVariables() {
        return this.getGraph().getNodes();
    }
}

