/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.algcomparison.simulation.GeneralSemSimulation;
import edu.cmu.tetrad.data.KnowledgeBoxInput;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.SemGraph;
import edu.cmu.tetrad.sem.GeneralizedSemIm;
import edu.cmu.tetrad.sem.GeneralizedSemPm;
import edu.cmu.tetrad.sem.SemPm;
import edu.cmu.tetrad.sem.TemplateExpander;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetradapp.model.AlgorithmRunner;
import edu.cmu.tetradapp.model.BuildPureClustersRunner;
import edu.cmu.tetradapp.model.DagWrapper;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.GraphSource;
import edu.cmu.tetradapp.model.MimBuildRunner;
import edu.cmu.tetradapp.model.SemEstimatorWrapper;
import edu.cmu.tetradapp.model.SemGraphWrapper;
import edu.cmu.tetradapp.model.SemImWrapper;
import edu.cmu.tetradapp.model.SemPmWrapper;
import edu.cmu.tetradapp.model.Simulation;
import edu.cmu.tetradapp.model.TimeLagGraphWrapper;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.ParseException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class GeneralizedSemPmWrapper
implements KnowledgeBoxInput {
    static final long serialVersionUID = 23L;
    private String name;
    private final GeneralizedSemPm semPm;
    private boolean showErrors;

    public GeneralizedSemPmWrapper(Simulation simulation) {
        GeneralizedSemPm semPm = null;
        if (simulation == null) {
            throw new NullPointerException("The Simulation box does not contain a simulation.");
        }
        edu.cmu.tetrad.algcomparison.simulation.Simulation _simulation = simulation.getSimulation();
        if (_simulation == null) {
            throw new NullPointerException("No data sets have been simulated.");
        }
        if (!(_simulation instanceof GeneralSemSimulation)) {
            throw new IllegalArgumentException("That was not a Generalized SEM simulation.");
        }
        List<GeneralizedSemIm> ims = ((GeneralSemSimulation)_simulation).getIms();
        if (ims == null || ims.size() == 0) {
            throw new NullPointerException("It looks like you have not done a simulation.");
        }
        this.semPm = semPm = ims.get(0).getGeneralizedSemPm();
    }

    public GeneralizedSemPmWrapper(Graph graph) {
        if (graph == null) {
            throw new NullPointerException("Graph must not be null.");
        }
        if (graph instanceof SemGraph) {
            this.semPm = new GeneralizedSemPm(graph);
        } else {
            try {
                this.semPm = new GeneralizedSemPm(new SemGraph(graph));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        this.log(this.semPm);
    }

    public GeneralizedSemPmWrapper(Graph graph, GeneralizedSemPm oldPm) {
        this(graph);
        try {
            this.semPm.setVariablesTemplate(oldPm.getVariablesTemplate());
            this.semPm.setParametersTemplate(oldPm.getParametersTemplate());
            this.semPm.setErrorsTemplate(oldPm.getErrorsTemplate());
            for (Node node : this.semPm.getNodes()) {
                HashSet<String> parents = new HashSet<String>();
                for (Node parent : this.semPm.getParents(node)) {
                    parents.add(parent.getName());
                }
                Node _node = oldPm.getNode(node.getName());
                Set<Node> oldReferencedNodes = oldPm.getReferencedNodes(_node);
                HashSet<String> oldReferencedNames = new HashSet<String>();
                for (Node node2 : oldReferencedNodes) {
                    oldReferencedNames.add(node2.getName());
                }
                String template = this.semPm.getVariableNodes().contains(node) ? this.semPm.getVariablesTemplate() : this.semPm.getErrorsTemplate();
                String newExpression = "";
                try {
                    newExpression = TemplateExpander.getInstance().expandTemplate(template, this.semPm, node);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                this.semPm.setNodeExpression(node, newExpression);
                if (_node == null || !parents.equals(oldReferencedNames)) {
                    this.semPm.setNodeExpression(node, newExpression);
                    this.setReferencedParameters(node, this.semPm, oldPm);
                    continue;
                }
                try {
                    this.semPm.setNodeExpression(node, oldPm.getNodeExpressionString(node));
                }
                catch (Exception e) {
                    this.semPm.setNodeExpression(node, newExpression);
                }
            }
            for (String startsWith : oldPm.startsWithPrefixes()) {
                try {
                    this.semPm.setStartsWithParametersTemplate(startsWith, oldPm.getStartsWithParameterTemplate(startsWith));
                }
                catch (ParseException e) {
                    throw new RuntimeException(e);
                }
            }
            for (String parameter : this.semPm.getParameters()) {
                boolean found = false;
                Set<String> prefixes = oldPm.startsWithPrefixes();
                for (String startsWith : prefixes) {
                    if (!parameter.startsWith(startsWith)) continue;
                    this.semPm.setParameterExpression(parameter, oldPm.getStartsWithParameterTemplate(startsWith));
                    found = true;
                    break;
                }
                if (found) continue;
                this.semPm.setParameterExpression(parameter, this.semPm.getParameterExpressionString(parameter));
            }
        }
        catch (ParseException e) {
            throw new RuntimeException("Couldn't parse expression.", e);
        }
    }

    public void setReferencedParameters(Node node, GeneralizedSemPm oldPm, GeneralizedSemPm newPm) {
        Set<String> parameters = this.semPm.getReferencedParameters(node);
        for (String string : parameters) {
        }
    }

    public GeneralizedSemPmWrapper(SemPmWrapper pmWrapper) {
        if (pmWrapper == null) {
            throw new NullPointerException();
        }
        this.semPm = new GeneralizedSemPm(pmWrapper.getSemPm());
    }

    public GeneralizedSemPmWrapper(GraphSource graphWrapper) {
        this(new EdgeListGraph(graphWrapper.getGraph()));
    }

    public GeneralizedSemPmWrapper(GraphSource graphWrapper, DataWrapper dataWrapper) {
        this(new EdgeListGraph(graphWrapper.getGraph()));
    }

    public GeneralizedSemPmWrapper(GraphSource graphWrapper, GeneralizedSemPmWrapper wrapper) {
        this(new EdgeListGraph(graphWrapper.getGraph()), wrapper.getSemPm());
    }

    public GeneralizedSemPmWrapper(DagWrapper dagWrapper, GeneralizedSemPmWrapper wrapper) {
        this(new EdgeListGraph(dagWrapper.getDag()), wrapper.getSemPm());
    }

    public GeneralizedSemPmWrapper(SemGraphWrapper semGraphWrapper, GeneralizedSemPmWrapper wrapper) {
        this(semGraphWrapper.getSemGraph(), wrapper.getSemPm());
    }

    public GeneralizedSemPmWrapper(GeneralizedSemPmWrapper pmWrapper) {
        this.semPm = new GeneralizedSemPm(pmWrapper.getSemPm());
    }

    public GeneralizedSemPmWrapper(TimeLagGraphWrapper wrapper) {
        this(wrapper.getGraph());
    }

    public GeneralizedSemPmWrapper(SemEstimatorWrapper wrapper) {
        try {
            SemPm oldSemPm = wrapper.getSemEstimator().getEstimatedSem().getSemPm();
            this.semPm = new GeneralizedSemPm(oldSemPm);
        }
        catch (Exception e) {
            throw new RuntimeException("SemPm could not be deep cloned.", e);
        }
        this.log(this.semPm);
    }

    public GeneralizedSemPmWrapper(SemImWrapper wrapper) {
        SemPm oldSemPm = wrapper.getSemIm().getSemPm();
        this.semPm = new GeneralizedSemPm(oldSemPm);
        this.log(this.semPm);
    }

    public GeneralizedSemPmWrapper(MimBuildRunner wrapper) {
        SemPm oldSemPm = wrapper.getSemPm();
        this.semPm = new GeneralizedSemPm(oldSemPm);
        this.log(this.semPm);
    }

    public GeneralizedSemPmWrapper(BuildPureClustersRunner wrapper) {
        Graph graph = wrapper.getResultGraph();
        if (graph == null) {
            throw new IllegalArgumentException("No graph to display.");
        }
        SemPm oldSemPm = new SemPm(graph);
        this.semPm = new GeneralizedSemPm(oldSemPm);
        this.log(this.semPm);
    }

    public GeneralizedSemPmWrapper(AlgorithmRunner wrapper) {
        this(new EdgeListGraph(wrapper.getGraph()));
    }

    public static GeneralizedSemPmWrapper serializableInstance() {
        return new GeneralizedSemPmWrapper(Dag.serializableInstance());
    }

    public GeneralizedSemPm getSemPm() {
        return this.semPm;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.semPm == null) {
            throw new NullPointerException();
        }
    }

    public Graph getGraph() {
        return this.semPm.getGraph();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public boolean isShowErrors() {
        return this.showErrors;
    }

    public void setShowErrors(boolean showErrors) {
        this.showErrors = showErrors;
    }

    private void log(GeneralizedSemPm pm) {
        TetradLogger.getInstance().log("info", "Generalized Structural Equation Parameter Model (Generalized SEM PM)");
        TetradLogger.getInstance().log("pm", pm.toString());
    }

    @Override
    public Graph getSourceGraph() {
        return this.getGraph();
    }

    @Override
    public Graph getResultGraph() {
        return this.getGraph();
    }

    @Override
    public List<String> getVariableNames() {
        return this.getGraph().getNodeNames();
    }

    @Override
    public List<Node> getVariables() {
        return this.getGraph().getNodes();
    }
}

