/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.BoxDataSet;
import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.VerticalDoubleDataBox;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.session.ExecutionRestarter;
import edu.cmu.tetrad.session.SessionAdapter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.DecimalFormat;
import java.util.LinkedList;

public class GraphComparisonParams
extends SessionAdapter
implements ExecutionRestarter {
    static final long serialVersionUID = 23L;
    private DataSet dataSet;
    private boolean resetTableOnExecute = true;
    private boolean keepLatents;
    private String referenceGraphName;
    private String targetGraphName;

    private GraphComparisonParams() {
        this.newExecution();
    }

    public static GraphComparisonParams serializableInstance() {
        return new GraphComparisonParams();
    }

    @Override
    public final void newExecution() {
        ContinuousVariable adjCorrect = new ContinuousVariable("ADJ_COR");
        ContinuousVariable adjFn = new ContinuousVariable("ADJ_FN");
        ContinuousVariable adjFp = new ContinuousVariable("ADJ_FP");
        ContinuousVariable arrowptCorrect = new ContinuousVariable("AHD_COR");
        ContinuousVariable arrowptFn = new ContinuousVariable("AHD_FN");
        ContinuousVariable arrowptFp = new ContinuousVariable("AHD_FP");
        ContinuousVariable adjPrec = new ContinuousVariable("ADJ_PREC");
        ContinuousVariable adjRec = new ContinuousVariable("ADJ_REC");
        ContinuousVariable arrowptPrec = new ContinuousVariable("ARROWPT_PREC");
        ContinuousVariable arrowptRec = new ContinuousVariable("ARROWPT_REC");
        ContinuousVariable shd = new ContinuousVariable("SHD");
        LinkedList<Node> variables = new LinkedList<Node>();
        variables.add(adjCorrect);
        variables.add(adjFn);
        variables.add(adjFp);
        variables.add(arrowptCorrect);
        variables.add(arrowptFn);
        variables.add(arrowptFp);
        variables.add(adjPrec);
        variables.add(adjRec);
        variables.add(arrowptPrec);
        variables.add(arrowptRec);
        variables.add(shd);
        this.dataSet = new BoxDataSet(new VerticalDoubleDataBox(0, variables.size()), variables);
        this.dataSet.setNumberFormat(new DecimalFormat("0"));
    }

    public void addRecord(GraphUtils.GraphComparison comparison) {
        int newRow = this.dataSet.getNumRows();
        this.dataSet.setDouble(newRow, 0, comparison.getAdjCor());
        this.dataSet.setDouble(newRow, 1, comparison.getAdjFn());
        this.dataSet.setDouble(newRow, 2, comparison.getAdjFp());
        this.dataSet.setDouble(newRow, 3, comparison.getAhdCor());
        this.dataSet.setDouble(newRow, 4, comparison.getAhdFn());
        this.dataSet.setDouble(newRow, 5, comparison.getAhdFp());
        this.dataSet.setDouble(newRow, 6, comparison.getAdjPrec());
        this.dataSet.setDouble(newRow, 7, comparison.getAdjRec());
        this.dataSet.setDouble(newRow, 8, comparison.getAhdPrec());
        this.dataSet.setDouble(newRow, 9, comparison.getAhdRec());
        this.dataSet.setDouble(newRow, 10, comparison.getShd());
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public boolean isResetTableOnExecute() {
        return this.resetTableOnExecute;
    }

    public void setResetTableOnExecute(boolean resetTableOnExecute) {
        this.resetTableOnExecute = resetTableOnExecute;
    }

    public boolean isKeepLatents() {
        return this.keepLatents;
    }

    public void setKeepLatents(boolean keepLatents) {
        this.keepLatents = keepLatents;
    }

    public void setReferenceGraphName(String name) {
        this.referenceGraphName = name;
    }

    public String getReferenceGraphName() {
        return this.referenceGraphName;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
    }

    public void setTargetGraphName(String targetGraphName) {
        this.targetGraphName = targetGraphName;
    }

    public String getTargetGraphName() {
        return this.targetGraphName;
    }
}

