/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.KnowledgeBoxInput;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.LayoutUtil;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.IndTestDSep;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetradapp.model.GraphSource;
import edu.cmu.tetradapp.model.IndTestProducer;
import edu.cmu.tetradapp.util.IonInput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class GraphSelectionWrapper
implements GraphSource,
KnowledgeBoxInput,
IonInput,
IndTestProducer {
    static final long serialVersionUID = 23L;
    private final Parameters params;
    private List<Node> selectedNodes;
    private List<Graph> graphs = new ArrayList<Graph>();

    public GraphSelectionWrapper(GraphSource graphWrapper, Parameters parameters) {
        this(graphWrapper.getGraph(), parameters);
    }

    public GraphSelectionWrapper(List<Graph> graphs, Parameters params) {
        if (graphs == null) {
            throw new NullPointerException("Graph must not be null.");
        }
        this.params = params;
        this.init(params, graphs);
    }

    public GraphSelectionWrapper(Graph graph, Parameters params) {
        if (graph == null) {
            throw new NullPointerException("Graph must not be null.");
        }
        this.params = params;
        ArrayList<Graph> graphs = new ArrayList<Graph>();
        graphs.add(graph);
        this.init(params, graphs);
    }

    public GraphSelectionWrapper(Graph graphs, Parameters params, String message) {
        this(graphs, params);
        TetradLogger.getInstance().log("info", message);
    }

    public static GraphSelectionWrapper serializableInstance() {
        return new GraphSelectionWrapper(Dag.serializableInstance(), new Parameters());
    }

    private void init(Parameters params, List<Graph> graphs) {
        this.setGraphs(graphs);
        this.calculateSelection();
        List<Graph> selectionGraphs = this.getSelectionGraphs(params);
        for (int i = 0; i < graphs.size(); ++i) {
            Graph graph = selectionGraphs.get(i);
            LayoutUtil.fruchtermanReingoldLayout(graph);
        }
        this.log();
    }

    public List<Node> getSelectedVariables() {
        return this.selectedNodes;
    }

    private List<Graph> getSelectionGraphs(Parameters params) {
        return (List)params.get("selectionGraphs", Collections.singletonList(new EdgeListGraph()));
    }

    public void calculateSelection() {
        ArrayList<Graph> selectedGraphs = new ArrayList<Graph>();
        for (int i = 0; i < this.getGraphs().size(); ++i) {
            selectedGraphs.add(this.calculateSelectionGraph(i));
        }
        this.params.set("selectionGraphs", (Object)selectedGraphs);
    }

    public List<Graph> getGraphs() {
        if (this.graphs == null || this.graphs.isEmpty()) {
            List<Graph> _graphs = Collections.singletonList(new EdgeListGraph());
            this.params.set("graphs", (Object)_graphs);
            return _graphs;
        }
        return this.graphs;
    }

    private Graph calculateSelectionGraph(int k) {
        Object selectedGraph;
        List<Node> selectedVariables = this.getSelectedVariables();
        selectedVariables = GraphUtils.replaceNodes(selectedVariables, this.getSelectedGraph(k).getNodes());
        if (this.params.getString("graphSelectionType", "Subgraph").equals(Type.Subgraph.toString())) {
            selectedGraph = this.getSelectedGraph(k).subgraph(selectedVariables);
            this.params.set("highlightInEditor", (Object)selectedVariables);
        } else if (this.params.getString("graphSelectionType", "subgraph").equals(Type.Adjacents.toString())) {
            HashSet<Node> adj = new HashSet<Node>(selectedVariables);
            for (Node node : selectedVariables) {
                adj.addAll(this.getSelectedGraph(k).getAdjacentNodes(node));
            }
            selectedGraph = this.getSelectedGraph(k).subgraph(new ArrayList<Node>(adj));
            this.params.set("highlightInEditor", (Object)selectedVariables);
        } else if (this.params.getString("graphSelectionType", "Subgraph").equals(Type.Adjacents_of_Adjacents.toString())) {
            HashSet<Node> adj = new HashSet<Node>(selectedVariables);
            for (Node node : selectedVariables) {
                adj.addAll(this.getSelectedGraph(k).getAdjacentNodes(node));
            }
            for (Node node : new HashSet<Node>(adj)) {
                adj.addAll(this.getSelectedGraph(k).getAdjacentNodes(node));
            }
            selectedGraph = this.getSelectedGraph(k).subgraph(new ArrayList<Node>(adj));
            this.params.set("highlightInEditor", (Object)selectedVariables);
        } else if (this.params.getString("graphSelectionType", "Subgraph").equals(Type.Adjacents_of_Adjacents_of_Adjacents.toString())) {
            HashSet<Node> adj = new HashSet<Node>(selectedVariables);
            for (Node node : selectedVariables) {
                adj.addAll(this.getSelectedGraph(k).getAdjacentNodes(node));
            }
            for (Node node : new HashSet<Node>(adj)) {
                adj.addAll(this.getSelectedGraph(k).getAdjacentNodes(node));
            }
            for (Node node : new HashSet<Node>(adj)) {
                adj.addAll(this.getSelectedGraph(k).getAdjacentNodes(node));
            }
            selectedGraph = this.getSelectedGraph(k).subgraph(new ArrayList<Node>(adj));
            this.params.set("highlightInEditor", (Object)selectedVariables);
        } else if (this.params.getString("graphSelectionType", "subgraph").equals(Type.Adjacents.toString())) {
            HashSet<Node> adj = new HashSet<Node>(selectedVariables);
            for (Node node : selectedVariables) {
                adj.addAll(this.getSelectedGraph(k).getAdjacentNodes(node));
            }
            selectedGraph = this.getSelectedGraph(k).subgraph(new ArrayList<Node>(adj));
            this.params.set("highlightInEditor", (Object)selectedVariables);
        } else if (this.params.getString("graphSelectionType", "parents").equals(Type.Parents.toString())) {
            HashSet<Node> adj = new HashSet<Node>(selectedVariables);
            for (Node node : selectedVariables) {
                adj.addAll(this.getSelectedGraph(k).getParents(node));
            }
            selectedGraph = this.getSelectedGraph(k).subgraph(new ArrayList<Node>(adj));
            this.params.set("highlightInEditor", (Object)selectedVariables);
        } else if (this.params.getString("graphSelectionType", "children").equals(Type.Children.toString())) {
            HashSet<Node> adj = new HashSet<Node>(selectedVariables);
            for (Node node : selectedVariables) {
                adj.addAll(this.getSelectedGraph(k).getChildren(node));
            }
            selectedGraph = this.getSelectedGraph(k).subgraph(new ArrayList<Node>(adj));
            this.params.set("highlightInEditor", (Object)selectedVariables);
        } else if (this.params.getString("graphSelectionType", "ancestors").equals(Type.Ancestors.toString())) {
            HashSet<Node> adj = new HashSet<Node>(selectedVariables);
            for (Node node : selectedVariables) {
                adj.addAll(this.getSelectedGraph(k).paths().getAncestors(Collections.singletonList(node)));
            }
            selectedGraph = this.getSelectedGraph(k).subgraph(new ArrayList<Node>(adj));
            this.params.set("highlightInEditor", (Object)selectedVariables);
        } else if (this.params.getString("graphSelectionType", "descendants").equals(Type.Descendants.toString())) {
            HashSet<Node> adj = new HashSet<Node>(selectedVariables);
            for (Node node : selectedVariables) {
                adj.addAll(this.getSelectedGraph(k).paths().getDescendants(Collections.singletonList(node)));
            }
            selectedGraph = this.getSelectedGraph(k).subgraph(new ArrayList<Node>(adj));
            this.params.set("highlightInEditor", (Object)selectedVariables);
        } else if (this.params.getString("graphSelectionType", "Subgraph").equals(Type.Descendants.toString())) {
            HashSet<Edge> edges = new HashSet<Edge>();
            for (Node node : selectedVariables) {
                Set<Edge> ys = this.yStructures(this.getGraphAtIndex(k), node, k);
                edges.addAll(ys);
            }
            EdgeListGraph subGraph = new EdgeListGraph();
            for (Edge edge : edges) {
                if (!subGraph.containsNode(edge.getNode1())) {
                    subGraph.addNode(edge.getNode1());
                }
                if (!subGraph.containsNode(edge.getNode2())) {
                    subGraph.addNode(edge.getNode2());
                }
                subGraph.addEdge(edge);
            }
            selectedGraph = subGraph;
            this.params.set("highlightInEditor", (Object)selectedVariables);
        } else if (this.params.getString("graphSelectionType", "Subgraph").equals(Type.Pag_Y_Structures.toString())) {
            HashSet<Edge> edges = new HashSet<Edge>();
            for (Node node : selectedVariables) {
                Set<Edge> ys = this.pagYStructures(this.getGraphAtIndex(k), node, k);
                edges.addAll(ys);
            }
            EdgeListGraph subGraph = new EdgeListGraph();
            for (Edge edge : edges) {
                if (!subGraph.containsNode(edge.getNode1())) {
                    subGraph.addNode(edge.getNode1());
                }
                if (!subGraph.containsNode(edge.getNode2())) {
                    subGraph.addNode(edge.getNode2());
                }
                subGraph.addEdge(edge);
            }
            selectedGraph = subGraph;
            this.params.set("highlightInEditor", (Object)selectedVariables);
        } else if (this.params.getString("graphSelectionType", "Subgraph").equals(Type.Markov_Blankets.toString())) {
            HashSet<Node> _nodes = new HashSet<Node>();
            for (Node node : selectedVariables) {
                Set<Node> mb = this.mb(this.getGraphAtIndex(k), node);
                mb.add(node);
                _nodes.addAll(mb);
            }
            selectedGraph = this.getSelectedGraph(k).subgraph(new ArrayList<Node>(_nodes));
            this.params.set("highlightInEditor", (Object)selectedVariables);
        } else if (this.params.getString("graphSelectionType", "Subgraph").equals(Type.Treks.toString())) {
            EdgeListGraph g = new EdgeListGraph(selectedVariables);
            for (int i = 0; i < selectedVariables.size(); ++i) {
                block17: for (int j = i + 1; j < selectedVariables.size(); ++j) {
                    Node x = selectedVariables.get(i);
                    Node y = selectedVariables.get(j);
                    List<List<Node>> paths = this.getGraphAtIndex(k).paths().treks(x, y, this.getN() + 1);
                    if (this.params.getString("nType", "atLeast").equals(nType.atMost.toString()) && !paths.isEmpty()) {
                        for (List<Node> path : paths) {
                            if (path.size() > this.getN() + 1) continue;
                            g.addUndirectedEdge(x, y);
                            continue block17;
                        }
                        continue;
                    }
                    if (this.params.getString("nType", "atLeast").equals(nType.atLeast.toString()) && !paths.isEmpty()) {
                        for (List<Node> path : paths) {
                            if (path.size() < this.getN() + 1) continue;
                            g.addUndirectedEdge(x, y);
                            continue block17;
                        }
                        continue;
                    }
                    if (!this.params.getString("nType", "atLeast").equals(nType.equals.toString())) continue;
                    for (List<Node> path : paths) {
                        if (path.size() != this.getN() + 1) continue;
                        g.addUndirectedEdge(x, y);
                        continue block17;
                    }
                }
            }
            selectedGraph = g;
            this.params.set("highlightInEditor", (Object)selectedVariables);
        } else if (this.params.getString("graphSelectionType", "Subgraph").equals(Type.Trek_Edges.toString())) {
            HashSet<Edge> edges = new HashSet<Edge>();
            for (int i = 0; i < selectedVariables.size(); ++i) {
                for (int j = i + 1; j < selectedVariables.size(); ++j) {
                    List<List<Node>> paths;
                    Node x = selectedVariables.get(i);
                    Node y = selectedVariables.get(j);
                    if (this.params.getString("nType", "atLeast").equals(nType.atMost.toString())) {
                        paths = this.getGraphAtIndex(k).paths().treks(x, y, this.getN() + 1);
                        for (List<Node> path : paths) {
                            if (path.size() > this.getN() + 1) continue;
                            edges.addAll(this.getEdgesFromPath(path, this.getGraphAtIndex(k)));
                        }
                        continue;
                    }
                    if (this.params.getString("nType", "atLeast").equals(nType.atLeast.toString())) {
                        paths = this.getGraphAtIndex(k).paths().treks(x, y, -1);
                        for (List<Node> path : paths) {
                            if (path.size() < this.getN() + 1) continue;
                            edges.addAll(this.getEdgesFromPath(path, this.getGraphAtIndex(k)));
                        }
                        continue;
                    }
                    if (!this.params.getString("nType", "atLeast").equals(nType.equals.toString())) continue;
                    paths = this.getGraphAtIndex(k).paths().treks(x, y, this.getN() + 1);
                    for (List<Node> path : paths) {
                        if (path.size() != this.getN() + 1) continue;
                        edges.addAll(this.getEdgesFromPath(path, this.getGraphAtIndex(k)));
                    }
                }
            }
            selectedGraph = this.graphFromEdges(edges, new ArrayList<Node>());
            this.params.set("highlightInEditor", (Object)selectedVariables);
        } else if (this.params.getString("graphSelectionType", "Subgraph").equals(Type.Paths.toString())) {
            EdgeListGraph g = new EdgeListGraph(selectedVariables);
            for (int i = 0; i < selectedVariables.size(); ++i) {
                block27: for (int j = i + 1; j < selectedVariables.size(); ++j) {
                    Node x = selectedVariables.get(i);
                    Node y = selectedVariables.get(j);
                    List<List<Node>> paths = this.getGraphAtIndex(k).paths().allPathsFromTo(x, y, this.getN());
                    if (this.params.getString("nType", "atLeast").equals(nType.atMost.toString()) && !paths.isEmpty()) {
                        for (List<Node> path : paths) {
                            if (path.size() > this.getN() + 1) continue;
                            g.addUndirectedEdge(x, y);
                            continue block27;
                        }
                        continue;
                    }
                    if (this.params.getString("nType", "atLeast").equals(nType.atLeast.toString()) && !paths.isEmpty()) {
                        for (List<Node> path : paths) {
                            if (path.size() < this.getN() + 1) continue;
                            g.addUndirectedEdge(x, y);
                            continue block27;
                        }
                        continue;
                    }
                    if (!this.params.getString("nType", "atLeast").equals(nType.equals.toString())) continue;
                    for (List<Node> path : paths) {
                        if (path.size() != this.getN() + 1) continue;
                        g.addUndirectedEdge(x, y);
                        continue block27;
                    }
                }
            }
            selectedGraph = g;
            this.params.set("highlightInEditor", (Object)selectedVariables);
        } else if (this.params.getString("graphSelectionType", "Subgraph").equals(Type.Path_Edges.toString())) {
            HashSet<Edge> edges = new HashSet<Edge>();
            for (int i = 0; i < selectedVariables.size(); ++i) {
                for (int j = i + 1; j < selectedVariables.size(); ++j) {
                    List<List<Node>> paths;
                    Node x = selectedVariables.get(i);
                    Node y = selectedVariables.get(j);
                    if (this.params.getString("nType", "atLeast").equals(nType.atMost.toString())) {
                        paths = this.getGraphAtIndex(k).paths().allPathsFromTo(x, y, this.getN());
                        for (List<Node> path : paths) {
                            if (path.size() > this.getN() + 1) continue;
                            edges.addAll(this.getEdgesFromPath(path, this.getGraphAtIndex(k)));
                        }
                        continue;
                    }
                    if (this.params.getString("nType", "atLeast").equals(nType.atLeast.toString())) {
                        paths = this.getGraphAtIndex(k).paths().allPathsFromTo(x, y, -1);
                        for (List<Node> path : paths) {
                            if (path.size() < this.getN() + 1) continue;
                            edges.addAll(this.getEdgesFromPath(path, this.getGraphAtIndex(k)));
                        }
                        continue;
                    }
                    if (!this.params.getString("nType", "atLeast").equals(nType.equals.toString())) continue;
                    paths = this.getGraphAtIndex(k).paths().allPathsFromTo(x, y, this.getN());
                    for (List<Node> path : paths) {
                        if (path.size() != this.getN() + 1) continue;
                        edges.addAll(this.getEdgesFromPath(path, this.getGraphAtIndex(k)));
                    }
                }
            }
            selectedGraph = this.graphFromEdges(edges, new ArrayList<Node>());
            this.params.set("highlightInEditor", (Object)selectedVariables);
        } else if (this.params.getString("graphSelectionType", "Subgraph").equals(Type.Directed_Paths.toString())) {
            EdgeListGraph g = new EdgeListGraph(selectedVariables);
            for (int i = 0; i < selectedVariables.size(); ++i) {
                block37: for (int j = 0; j < selectedVariables.size(); ++j) {
                    List<List<Node>> paths;
                    if (i == j) continue;
                    Node x = selectedVariables.get(i);
                    Node y = selectedVariables.get(j);
                    if (this.params.getString("nType", "atLeast").equals(nType.atMost.toString())) {
                        paths = this.getGraphAtIndex(k).paths().allDirectedPathsFromTo(x, y, this.getN());
                        for (List<Node> path : paths) {
                            if (path.size() > this.getN() + 1) continue;
                            g.addDirectedEdge(x, y);
                            continue block37;
                        }
                        continue;
                    }
                    if (this.params.getString("nType", "atLeast").equals(nType.atLeast.toString())) {
                        paths = this.getGraphAtIndex(k).paths().allDirectedPathsFromTo(x, y, -1);
                        for (List<Node> path : paths) {
                            if (path.size() < this.getN() + 1) continue;
                            g.addDirectedEdge(x, y);
                            continue block37;
                        }
                        continue;
                    }
                    if (!this.params.getString("nType", "atLeast").equals(nType.equals.toString())) continue;
                    paths = this.getGraphAtIndex(k).paths().allDirectedPathsFromTo(x, y, this.getN());
                    for (List<Node> path : paths) {
                        if (path.size() != this.getN() + 1) continue;
                        g.addDirectedEdge(x, y);
                        continue block37;
                    }
                }
            }
            selectedGraph = g;
            this.params.set("highlightInEditor", (Object)selectedVariables);
        } else if (this.params.getString("graphSelectionType", "Subgraph").equals(Type.Directed_Path_Edges.toString())) {
            HashSet<Edge> edges = new HashSet<Edge>();
            for (int i = 0; i < selectedVariables.size(); ++i) {
                for (int j = 0; j < selectedVariables.size(); ++j) {
                    if (i == j) continue;
                    Node x = selectedVariables.get(i);
                    Node y = selectedVariables.get(j);
                    List<List<Node>> paths = this.getGraphAtIndex(k).paths().allDirectedPathsFromTo(x, y, this.getN());
                    if (this.params.getString("nType", "atLeast").equals(nType.atMost.toString()) && !paths.isEmpty()) {
                        for (List<Node> path : paths) {
                            if (path.size() > this.getN() + 1) continue;
                            edges.addAll(this.getEdgesFromPath(path, this.getGraphAtIndex(k)));
                        }
                        continue;
                    }
                    if (this.params.getString("nType", "atLeast").equals(nType.atLeast.toString()) && !paths.isEmpty()) {
                        for (List<Node> path : paths) {
                            if (path.size() < this.getN() + 1) continue;
                            edges.addAll(this.getEdgesFromPath(path, this.getGraphAtIndex(k)));
                        }
                        continue;
                    }
                    if (!this.params.getString("nType", "atLeast").equals(nType.equals.toString())) continue;
                    for (List<Node> path : paths) {
                        if (path.size() != this.getN() + 1) continue;
                        edges.addAll(this.getEdgesFromPath(path, this.getGraphAtIndex(k)));
                    }
                }
            }
            selectedGraph = this.graphFromEdges(edges, new ArrayList<Node>());
            this.params.set("highlightInEditor", (Object)selectedVariables);
        } else if (this.params.getString("graphSelectionType", "Subgraph").equals(Type.Indegree.toString())) {
            HashSet<Edge> g = new HashSet<Edge>();
            ArrayList<Node> nodes = new ArrayList<Node>();
            for (Node n : selectedVariables) {
                List<Node> h = this.getSelectedGraph(k).getParents(n);
                if (this.params.getString("nType", "atLeast").equals(nType.atMost.toString()) && h.size() <= this.getN()) {
                    nodes.add(n);
                    for (Node m : h) {
                        g.add(this.getSelectedGraph(k).getEdge(m, n));
                    }
                    continue;
                }
                if (this.params.getString("nType", "atLeast").equals(nType.atLeast.toString()) && h.size() >= this.getN()) {
                    nodes.add(n);
                    for (Node m : h) {
                        g.add(this.getSelectedGraph(k).getEdge(m, n));
                    }
                    continue;
                }
                if (!this.params.getString("nType", "atLeast").equals(nType.equals.toString()) || h.size() != this.getN()) continue;
                nodes.add(n);
                for (Node m : h) {
                    g.add(this.getSelectedGraph(k).getEdge(m, n));
                }
            }
            selectedGraph = this.graphFromEdges(g, new ArrayList<Node>());
            this.params.set("highlightInEditor", (Object)nodes);
        } else if (this.params.getString("graphSelectionType", "Subgraph").equals(Type.Out_Degree.toString())) {
            HashSet<Edge> g = new HashSet<Edge>();
            ArrayList<Node> nodes = new ArrayList<Node>();
            for (Node n : selectedVariables) {
                List<Node> h = this.getSelectedGraph(k).getChildren(n);
                if (this.params.getString("nType", "atLeast").equals(nType.atMost.toString()) && h.size() <= this.getN()) {
                    nodes.add(n);
                    for (Node m : h) {
                        g.add(this.getSelectedGraph(k).getEdge(m, n));
                    }
                    continue;
                }
                if (this.params.getString("nType", "atLeast").equals(nType.atLeast.toString()) && h.size() >= this.getN()) {
                    nodes.add(n);
                    for (Node m : h) {
                        g.add(this.getSelectedGraph(k).getEdge(m, n));
                    }
                    continue;
                }
                if (!this.params.getString("nType", "atLeast").equals(nType.equals.toString()) || h.size() != this.getN()) continue;
                nodes.add(n);
                for (Node m : h) {
                    g.add(this.getSelectedGraph(k).getEdge(m, n));
                }
            }
            selectedGraph = this.graphFromEdges(g, nodes);
            this.params.set("highlightInEditor", (Object)nodes);
        } else if (this.params.getString("graphSelectionType", "Subgraph").equals(Type.Degree.toString())) {
            HashSet<Edge> g = new HashSet<Edge>();
            ArrayList<Node> nodes = new ArrayList<Node>();
            for (Node n : selectedVariables) {
                List<Node> h = this.getSelectedGraph(k).getAdjacentNodes(n);
                if (this.params.getString("nType", "atLeast").equals(nType.atMost.toString()) && h.size() <= this.getN()) {
                    nodes.add(n);
                    for (Node m : h) {
                        g.add(this.getSelectedGraph(k).getEdge(m, n));
                    }
                    continue;
                }
                if (this.params.getString("nType", "atLeast").equals(nType.atLeast.toString()) && h.size() >= this.getN()) {
                    nodes.add(n);
                    for (Node m : h) {
                        g.add(this.getSelectedGraph(k).getEdge(m, n));
                    }
                    continue;
                }
                if (!this.params.getString("nType", "atLeast").equals(nType.equals.toString()) || h.size() != this.getN()) continue;
                nodes.add(n);
                for (Node m : h) {
                    g.add(this.getSelectedGraph(k).getEdge(m, n));
                }
            }
            selectedGraph = this.graphFromEdges(g, nodes);
            this.params.set("highlightInEditor", (Object)nodes);
        } else {
            throw new IllegalArgumentException("Unrecognized selection type: " + this.params.getString("graphSelectionType", "subgraph"));
        }
        return selectedGraph;
    }

    private Graph getGraphAtIndex(int k) {
        return this.getGraphs().get(k);
    }

    private Graph getSelectedGraph(int i) {
        List<Graph> graphs = this.getGraphs();
        if (graphs != null && graphs.size() > 0) {
            return graphs.get(i);
        }
        return new EdgeListGraph();
    }

    @Override
    public Graph getGraph() {
        return this.getSelectionGraphs(this.params).get(0);
    }

    public void setGraphs(List<Graph> graphs) {
        this.graphs = graphs;
        ArrayList<EdgeListGraph> selectionGraphs = new ArrayList<EdgeListGraph>();
        for (int i = 0; i < graphs.size(); ++i) {
            selectionGraphs.add(new EdgeListGraph());
        }
        this.setSelectedVariables(new ArrayList<Node>());
        this.params.set("selectionGraphs", (Object)selectionGraphs);
        List highlighted = (List)this.params.get("highlightInEditor", new ArrayList());
        highlighted.retainAll(this.getSelectedGraph(0).getNodes());
        this.params.set("highlightInEditor", (Object)highlighted);
        List<Node> selected = this.getSelectedVariables();
        selected.retainAll(this.getSelectedGraph(0).getNodes());
        this.setSelectedVariables(selected);
        this.log();
    }

    public Graph getSelectionGraph(int i) {
        List selectionGraphs = (List)this.params.get("selectionGraphs", new ArrayList());
        if (selectionGraphs == null || selectionGraphs.isEmpty()) {
            for (int j = 0; j < this.getGraphs().size(); ++j) {
                selectionGraphs.add(new EdgeListGraph());
            }
            this.params.set("selectionGraphs", (Object)selectionGraphs);
        }
        return (Graph)selectionGraphs.get(i);
    }

    public Graph getOriginalGraph() {
        return this.getSelectedGraph(0);
    }

    public void setDialogText(String dialogText) {
        this.params.set("dialogText", dialogText);
    }

    public String getDialogText() {
        return this.params.getString("dialogText", "");
    }

    public Type getType() {
        String graphSelectionType = this.params.getString("graphSelectionType", "subgraph");
        for (Type type : Type.values()) {
            if (!type.toString().equals(graphSelectionType)) continue;
            return type;
        }
        throw new IllegalArgumentException();
    }

    public void setType(Type type) {
        this.params.set("graphSelectionType", type.toString());
    }

    @Override
    public String getName() {
        return this.params.getString("name", null);
    }

    @Override
    public void setName(String name) {
        this.params.set("name", name);
    }

    @Override
    public Graph getSourceGraph() {
        return this.getSelectedGraph(0);
    }

    @Override
    public Graph getResultGraph() {
        return this.getSelectionGraphs(this.params).get(0);
    }

    @Override
    public List<String> getVariableNames() {
        return this.getSelectedGraph(0).getNodeNames();
    }

    public void setSelectedVariables(List<Node> variables) {
        this.selectedNodes = variables;
    }

    @Override
    public List<Node> getVariables() {
        return this.getSelectedGraph(0).getNodes();
    }

    public void setN(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.params.set("n", (Object)n);
    }

    public int getN() {
        return this.params.getInt("n", 0);
    }

    public void setNType(nType NType) {
        this.params.set("nType", NType.toString());
    }

    public String getNType() {
        return this.params.getString("nType", "atLeast");
    }

    public List<Node> getHighlightInEditor() {
        return (List)this.params.get("highlightInEditor", new ArrayList());
    }

    private Graph graphFromEdges(Set<Edge> edges, List<Node> nodes) {
        EdgeListGraph selectedGraph = new EdgeListGraph(nodes);
        for (Edge edge : edges) {
            if (!selectedGraph.containsNode(edge.getNode1())) {
                selectedGraph.addNode(edge.getNode1());
            }
            if (!selectedGraph.containsNode(edge.getNode2())) {
                selectedGraph.addNode(edge.getNode2());
            }
            selectedGraph.addEdge(edge);
        }
        return selectedGraph;
    }

    private Set<Node> mb(Graph graph, Node z) {
        HashSet<Node> mb = new HashSet<Node>(graph.getAdjacentNodes(z));
        for (Node c : graph.getChildren(z)) {
            for (Node p : graph.getParents(c)) {
                if (p == z) continue;
                mb.add(p);
            }
        }
        return mb;
    }

    private Set<Edge> yStructures(Graph graph, Node z, int i) {
        HashSet<Edge> edges = new HashSet<Edge>();
        ArrayList<Edge> parents = new ArrayList<Edge>();
        for (Node node : graph.getAdjacentNodes(z)) {
            Edge edge = graph.getEdge(node, z);
            if (!Edges.isDirectedEdge(edge) || !edge.pointsTowards(z)) continue;
            parents.add(edge);
        }
        List<Node> children = this.getSelectedGraph(i).getChildren(z);
        if (parents.size() > 1 && children.size() > 0) {
            edges.addAll(parents);
            for (Node node : children) {
                edges.add(this.getSelectedGraph(i).getEdge(node, z));
            }
        }
        return edges;
    }

    private Set<Edge> pagYStructures(Graph graph, Node z, int i) {
        HashSet<Edge> edges = new HashSet<Edge>();
        ArrayList<Edge> parents = new ArrayList<Edge>();
        for (Node node : graph.getAdjacentNodes(z)) {
            Edge edge = graph.getEdge(node, z);
            if (!Edges.isPartiallyOrientedEdge(edge) || !edge.pointsTowards(z)) continue;
            parents.add(edge);
        }
        List<Node> children = this.getSelectedGraph(i).getChildren(z);
        if (parents.size() > 1 && children.size() > 0) {
            edges.addAll(parents);
            for (Node node : children) {
                edges.add(this.getSelectedGraph(i).getEdge(node, z));
            }
        }
        return edges;
    }

    private void log() {
        TetradLogger.getInstance().log("info", "General Graph");
    }

    private Set<Edge> getEdgesFromPath(List<Node> path, Graph graph) {
        HashSet<Edge> edges = new HashSet<Edge>();
        for (int m = 1; m < path.size(); ++m) {
            Node n1;
            Node n0 = path.get(m - 1);
            Edge edge = graph.getEdge(n0, n1 = path.get(m));
            if (edge == null) continue;
            edges.add(edge);
        }
        return edges;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
    }

    @Override
    public IndependenceTest getIndependenceTest() {
        return new IndTestDSep(this.getGraph());
    }

    public static enum Type {
        Subgraph,
        Adjacents,
        Adjacents_of_Adjacents,
        Adjacents_of_Adjacents_of_Adjacents,
        Parents,
        Children,
        Ancestors,
        Descendants,
        Markov_Blankets,
        Treks,
        Trek_Edges,
        Paths,
        Path_Edges,
        Directed_Paths,
        Directed_Path_Edges,
        Y_Structures,
        Pag_Y_Structures,
        Indegree,
        Out_Degree,
        Degree;

    }

    public static enum nType {
        equals,
        atMost,
        atLeast;

    }
}

