/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.calculator.expression.Expression;
import edu.cmu.tetrad.calculator.expression.VariableExpression;
import edu.cmu.tetrad.data.KnowledgeBoxInput;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.LayoutUtil;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.graph.SemGraph;
import edu.cmu.tetrad.search.IndTestDSep;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.sem.GeneralizedSemIm;
import edu.cmu.tetrad.sem.GeneralizedSemPm;
import edu.cmu.tetrad.session.SimulationParamsSource;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.GeneralizedSemImWrapper;
import edu.cmu.tetradapp.model.GraphSettable;
import edu.cmu.tetradapp.model.GraphSource;
import edu.cmu.tetradapp.model.IndTestProducer;
import edu.cmu.tetradapp.model.MultipleGraphSource;
import edu.cmu.tetradapp.model.Simulation;
import edu.cmu.tetradapp.util.IonInput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GraphWrapper
implements KnowledgeBoxInput,
IonInput,
IndTestProducer,
SimulationParamsSource,
GraphSettable,
MultipleGraphSource {
    static final long serialVersionUID = 23L;
    private int numModels = 1;
    private int modelIndex;
    private String modelSourceName;
    private String name;
    private List<Graph> graphs;
    private Map<String, String> allParamSettings;
    private Parameters parameters;

    private GraphWrapper() {
    }

    public GraphWrapper(GraphSource graphSource, Parameters parameters) {
        this.parameters = parameters;
        if (graphSource instanceof Simulation) {
            Simulation simulation = (Simulation)graphSource;
            this.graphs = simulation.getGraphs();
            this.numModels = this.graphs.size();
            this.modelIndex = 0;
            this.modelSourceName = simulation.getName();
        } else {
            this.setGraph(new EdgeListGraph(graphSource.getGraph()));
        }
        this.log();
    }

    public GraphWrapper(Graph graph) {
        if (graph == null) {
            throw new NullPointerException("Graph must not be null.");
        }
        this.setGraph(graph);
        this.log();
    }

    public GraphWrapper(Graph graph, String message) {
        TetradLogger.getInstance().log("info", message);
        if (graph == null) {
            throw new NullPointerException("Graph must not be null.");
        }
        this.setGraph(graph);
    }

    public GraphWrapper(Parameters parameters) {
        this.parameters = parameters;
        this.setGraph(new EdgeListGraph());
        this.log();
    }

    public GraphWrapper(Simulation simulation, Parameters parameters) {
        this.parameters = parameters;
        this.graphs = simulation.getGraphs();
        this.numModels = this.graphs.size();
        this.modelIndex = 0;
        this.modelSourceName = simulation.getName();
        this.log();
    }

    public GraphWrapper(DataWrapper wrapper) {
        if (wrapper instanceof Simulation) {
            Simulation simulation = (Simulation)wrapper;
            this.graphs = simulation.getGraphs();
            this.numModels = this.graphs.size();
            this.modelIndex = 0;
            this.modelSourceName = simulation.getName();
        } else {
            this.setGraph(new EdgeListGraph(wrapper.getVariables()));
        }
        LayoutUtil.circleLayout(this.getGraph(), 200, 200, 150);
    }

    public GraphWrapper(GeneralizedSemImWrapper wrapper) {
        this(GraphWrapper.getStrongestInfluenceGraph(wrapper.getSemIms().get(0)));
        if (wrapper.getSemIms() == null || wrapper.getSemIms().size() > 1) {
            throw new IllegalArgumentException("I'm sorry; this editor can only edit a single generalized SEM IM.");
        }
    }

    public static GraphWrapper serializableInstance() {
        return new GraphWrapper(Dag.serializableInstance());
    }

    @Override
    public Graph getGraph() {
        return this.graphs.get(this.getModelIndex());
    }

    @Override
    public void setGraph(Graph graph) {
        this.graphs = new ArrayList<Graph>();
        this.graphs.add(new EdgeListGraph(graph));
        this.log();
    }

    public boolean allowRandomGraph() {
        return true;
    }

    @Override
    public IndependenceTest getIndependenceTest() {
        return new IndTestDSep(this.getGraph());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Graph getSourceGraph() {
        return this.getGraph();
    }

    @Override
    public Graph getResultGraph() {
        return this.getGraph();
    }

    @Override
    public List<String> getVariableNames() {
        return this.getGraph().getNodeNames();
    }

    @Override
    public List<Node> getVariables() {
        return this.getGraph().getNodes();
    }

    @Override
    public Map<String, String> getParamSettings() {
        HashMap<String, String> paramSettings = new HashMap<String, String>();
        paramSettings.put("# Vars", Integer.toString(this.getGraph().getNumNodes()));
        paramSettings.put("# Edges", Integer.toString(this.getGraph().getNumEdges()));
        if (this.getGraph().paths().existsDirectedCycle()) {
            paramSettings.put("Cyclic", null);
        }
        return paramSettings;
    }

    @Override
    public void setAllParamSettings(Map<String, String> paramSettings) {
        this.allParamSettings = paramSettings;
    }

    @Override
    public Map<String, String> getAllParamSettings() {
        return this.allParamSettings;
    }

    @Override
    public Parameters getParameters() {
        return this.parameters;
    }

    private static String findParameter(Expression expression, String name) {
        Expression expression1;
        VariableExpression varExpr;
        List<Expression> expressions = expression.getExpressions();
        if (expression.getToken().equals("*") && (varExpr = (VariableExpression)(expression1 = expressions.get(1))).getVariable().equals(name)) {
            Expression expression2 = expressions.get(0);
            VariableExpression constExpr = (VariableExpression)expression2;
            return constExpr.getVariable();
        }
        for (Expression _expression : expressions) {
            String param = GraphWrapper.findParameter(_expression, name);
            if (param == null) continue;
            return param;
        }
        return null;
    }

    private static Graph getStrongestInfluenceGraph(GeneralizedSemIm im) {
        GeneralizedSemPm pm = im.getGeneralizedSemPm();
        SemGraph imGraph = im.getGeneralizedSemPm().getGraph();
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (Node node : imGraph.getNodes()) {
            if (node.getNodeType() == NodeType.ERROR) continue;
            nodes.add(node);
        }
        EdgeListGraph graph2 = new EdgeListGraph(nodes);
        for (Edge edge : imGraph.getEdges()) {
            Node node1 = edge.getNode1();
            Node node2 = edge.getNode2();
            if (!graph2.containsNode(node1) || !graph2.containsNode(node2) || graph2.isAdjacentTo(node1, node2)) continue;
            List<Edge> edges = imGraph.getEdges(node1, node2);
            if (edges.size() == 1) {
                graph2.addEdge(edges.get(0));
                continue;
            }
            Expression expression1 = pm.getNodeExpression(node1);
            Expression expression2 = pm.getNodeExpression(node2);
            String param1 = GraphWrapper.findParameter(expression1, node2.getName());
            String param2 = GraphWrapper.findParameter(expression2, node1.getName());
            if (param1 == null || param2 == null) continue;
            double value1 = im.getParameterValue(param1);
            double value2 = im.getParameterValue(param2);
            if (value2 > value1) {
                graph2.addDirectedEdge(node1, node2);
                continue;
            }
            if (!(value1 > value2)) continue;
            graph2.addDirectedEdge(node2, node1);
        }
        return graph2;
    }

    private void log() {
        TetradLogger.getInstance().log("info", "General Graph");
        TetradLogger.getInstance().log("graph", "" + this.getGraph());
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
    }

    @Override
    public int getNumModels() {
        return this.numModels;
    }

    @Override
    public int getModelIndex() {
        return this.modelIndex;
    }

    @Override
    public String getModelSourceName() {
        return this.modelSourceName;
    }

    @Override
    public void setModelIndex(int modelIndex) {
        this.modelIndex = modelIndex;
    }

    @Override
    public List<Graph> getGraphs() {
        return this.graphs;
    }
}

