/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.LogDataUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.sem.SemEstimator;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.util.Matrix;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.PcRunner;
import edu.cmu.tetradapp.model.SemEstimatorWrapper;
import java.util.List;

public class ImpliedCovarianceDataAllWrapper
extends DataWrapper {
    static final long serialVersionUID = 23L;
    private SemIm semIm;

    public ImpliedCovarianceDataAllWrapper(SemEstimatorWrapper wrapper, Parameters params) {
        SemEstimator semEstimator = wrapper.getSemEstimator();
        SemIm semIm1 = semEstimator.getEstimatedSem();
        if (semIm1 != null) {
            Matrix matrix2D = semIm1.getImplCovar(true);
            int sampleSize = semIm1.getSampleSize();
            List<Node> variables = wrapper.getSemEstimator().getEstimatedSem().getSemPm().getVariableNodes();
            CovarianceMatrix cov = new CovarianceMatrix(variables, matrix2D, sampleSize);
            this.setDataModel(cov);
            this.setSourceGraph(wrapper.getSemEstimator().getEstimatedSem().getSemPm().getGraph());
            this.semIm = wrapper.getEstimatedSemIm();
        }
        LogDataUtils.logDataModelList("Data simulated from a linear structural equation model.", this.getDataModelList());
    }

    public SemIm getSemIm() {
        return this.semIm;
    }

    public static PcRunner serializableInstance() {
        return PcRunner.serializableInstance();
    }
}

