/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataModelList;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.data.IndependenceFacts;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.search.IndTestChiSquare;
import edu.cmu.tetrad.search.IndTestConditionalCorrelation;
import edu.cmu.tetrad.search.IndTestDSep;
import edu.cmu.tetrad.search.IndTestFisherZ;
import edu.cmu.tetrad.search.IndTestFisherZConcatenateResiduals;
import edu.cmu.tetrad.search.IndTestFisherZFisherPValue;
import edu.cmu.tetrad.search.IndTestFisherZGeneralizedInverse;
import edu.cmu.tetrad.search.IndTestFisherZPercentIndependent;
import edu.cmu.tetrad.search.IndTestGSquare;
import edu.cmu.tetrad.search.IndTestIndependenceFacts;
import edu.cmu.tetrad.search.IndTestMulti;
import edu.cmu.tetrad.search.IndTestMultinomialLogisticRegression;
import edu.cmu.tetrad.search.IndTestRegression;
import edu.cmu.tetrad.search.IndTestScore;
import edu.cmu.tetrad.search.IndTestType;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.ResolveSepsets;
import edu.cmu.tetrad.search.SemBicScore;
import edu.cmu.tetrad.search.SemBicScoreImages;
import edu.cmu.tetrad.util.Parameters;
import edu.pitt.csb.mgm.IndTestMultinomialLogisticRegressionWald;
import java.util.ArrayList;
import java.util.List;

final class IndTestChooser {
    IndTestChooser() {
    }

    public IndependenceTest getTest(Object dataSource, Parameters params) {
        return this.getTest(dataSource, params, IndTestType.DEFAULT);
    }

    public IndependenceTest getTest(Object dataSource, Parameters params, IndTestType testType) {
        if (dataSource == null) {
            throw new NullPointerException();
        }
        if (params == null) {
            throw new NullPointerException();
        }
        if (dataSource instanceof DataModelList) {
            DataModelList datasets = (DataModelList)dataSource;
            ArrayList<DataSet> _dataSets = new ArrayList<DataSet>();
            for (DataModel dataModel : datasets) {
                _dataSets.add((DataSet)dataModel);
            }
            return this.getMultiContinuousTest(_dataSets, params, testType);
        }
        if (dataSource instanceof DataSet) {
            DataSet dataSet = (DataSet)dataSource;
            if (dataSet.isContinuous() || dataSet.getNumColumns() == 0) {
                DataSet dataContinuous = (DataSet)dataSource;
                return this.getContinuousTest(dataContinuous, params, testType);
            }
            if (dataSet.isDiscrete()) {
                DataSet dataDiscrete = (DataSet)dataSource;
                return this.getDiscreteTest(dataDiscrete, params, testType);
            }
            if (dataSet.isMixed()) {
                DataSet dataMixed = (DataSet)dataSource;
                return this.getMixedTest(dataMixed, params, testType);
            }
        }
        if (dataSource instanceof Graph) {
            return this.getGraphTest((Graph)dataSource, params, IndTestType.D_SEPARATION);
        }
        if (dataSource instanceof ICovarianceMatrix) {
            return this.getCovMatrixTest((ICovarianceMatrix)dataSource, params);
        }
        if (dataSource instanceof IndependenceFacts) {
            return new IndTestIndependenceFacts((IndependenceFacts)dataSource);
        }
        throw new IllegalStateException("Unrecognized data source type: " + dataSource.getClass());
    }

    private IndependenceTest getMixedTest(DataSet dataSet, Parameters params, IndTestType testType) {
        if (IndTestType.MIXED_MLR == testType) {
            return new IndTestMultinomialLogisticRegressionWald(dataSet, params.getDouble("alpha", 0.001), false);
        }
        if (IndTestType.LINEAR_REGRESSION == testType) {
            return new IndTestRegression(dataSet, params.getDouble("alpha", 0.001));
        }
        params.set("indTestType", (Object)IndTestType.MIXED_MLR);
        return new IndTestMultinomialLogisticRegression(dataSet, params.getDouble("alpha", 0.001));
    }

    private IndependenceTest getContinuousTest(DataSet dataSet, Parameters params, IndTestType testType) {
        if (IndTestType.CONDITIONAL_CORRELATION == testType) {
            return new IndTestConditionalCorrelation(dataSet, params.getDouble("alpha", 0.001));
        }
        if (IndTestType.FISHER_Z == testType) {
            return new IndTestFisherZ(dataSet, params.getDouble("alpha", 0.001));
        }
        if (IndTestType.FISHER_ZD == testType) {
            return new IndTestFisherZGeneralizedInverse(dataSet, params.getDouble("alpha", 0.001));
        }
        if (IndTestType.SEM_BIC == testType) {
            return new IndTestScore(new SemBicScore(new CovarianceMatrix(dataSet)));
        }
        params.set("indTestType", (Object)IndTestType.FISHER_Z);
        return new IndTestFisherZ(dataSet, params.getDouble("alpha", 0.001));
    }

    private IndependenceTest getMultiContinuousTest(List<DataSet> dataSets, Parameters params, IndTestType testType) {
        if (IndTestType.POOL_RESIDUALS_FISHER_Z == testType) {
            return new IndTestFisherZPercentIndependent(dataSets, params.getDouble("alpha", 0.001));
        }
        if (IndTestType.TIPPETT == testType) {
            ArrayList<IndependenceTest> independenceTests = new ArrayList<IndependenceTest>();
            for (DataModel dataModel : dataSets) {
                DataSet dataSet = (DataSet)dataModel;
                independenceTests.add(new IndTestFisherZ(dataSet, params.getDouble("alpha", 0.001)));
            }
            return new IndTestMulti(independenceTests, ResolveSepsets.Method.tippett);
        }
        if (IndTestType.FISHER == testType) {
            return new IndTestFisherZFisherPValue(dataSets, params.getDouble("alpha", 0.001));
        }
        if (IndTestType.SEM_BIC == testType) {
            ArrayList<DataModel> dataModels = new ArrayList<DataModel>(dataSets);
            return new IndTestScore(new SemBicScoreImages(dataModels));
        }
        return new IndTestFisherZConcatenateResiduals(dataSets, params.getDouble("alpha", 0.001));
    }

    private IndependenceTest getDiscreteTest(DataSet dataDiscrete, Parameters params, IndTestType testType) {
        if (IndTestType.G_SQUARE == testType) {
            return new IndTestGSquare(dataDiscrete, params.getDouble("alpha", 0.001));
        }
        if (IndTestType.CHI_SQUARE == testType) {
            return new IndTestChiSquare(dataDiscrete, params.getDouble("alpha", 0.001));
        }
        if (IndTestType.MIXED_MLR == testType) {
            return new IndTestMultinomialLogisticRegression(dataDiscrete, params.getDouble("alpha", 0.001));
        }
        params.set("indTestType", (Object)IndTestType.CHI_SQUARE);
        return new IndTestChiSquare(dataDiscrete, params.getDouble("alpha", 0.001));
    }

    private IndependenceTest getGraphTest(Graph graph, Parameters params, IndTestType testType) {
        if (IndTestType.D_SEPARATION != testType) {
            params.set("indTestType", (Object)IndTestType.D_SEPARATION);
        }
        return new IndTestDSep(graph);
    }

    private IndependenceTest getCovMatrixTest(ICovarianceMatrix covMatrix, Parameters params) {
        return new IndTestFisherZ(covMatrix, params.getDouble("alpha", 0.001));
    }
}

