/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.IndependenceFacts;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.data.KnowledgeBoxInput;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.IndependenceFact;
import edu.cmu.tetrad.graph.Node;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class IndependenceFactsModel
implements KnowledgeBoxInput {
    static final long serialVersionUID = 23L;
    private IndependenceFacts facts = new IndependenceFacts();
    private String name = "";

    public static Knowledge serializableInstance() {
        return new Knowledge();
    }

    public void add(IndependenceFact fact) {
        this.facts.add(fact);
    }

    public String toString() {
        return this.facts.toString();
    }

    public void remove(IndependenceFact fact) {
        this.facts.remove(fact);
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public IndependenceFacts getFacts() {
        return this.facts;
    }

    public static IndependenceFactsModel loadFacts(Reader reader) throws IOException {
        String line;
        IndependenceFactsModel facts = new IndependenceFactsModel();
        HashSet<String> names = new HashSet<String>();
        HashMap<String, GraphNode> nodes = new HashMap<String, GraphNode>();
        BufferedReader in = new BufferedReader(reader);
        while ((line = in.readLine()) != null) {
            String[] tokens = line.split("[ ,;_|]+");
            if (tokens.length == 0) continue;
            if (tokens.length < 2) {
                throw new IllegalArgumentException("Must specify at least two variables--e.g. X1 X2, for X1 _||_ X2.");
            }
            for (String token : tokens) {
                names.add(token);
                if (nodes.containsKey(token)) continue;
                nodes.put(token, new GraphNode(token));
            }
            ArrayList<Node> z = new ArrayList<Node>();
            for (int i = 2; i < tokens.length; ++i) {
                z.add((Node)nodes.get(tokens[i]));
            }
            facts.add(new IndependenceFact((Node)nodes.get(tokens[0]), (Node)nodes.get(tokens[1]), z));
        }
        return facts;
    }

    public void setFacts(IndependenceFacts facts) {
        if (facts == null) {
            throw new NullPointerException("FActs is null.");
        }
        this.facts = facts;
    }

    @Override
    public Graph getSourceGraph() {
        return null;
    }

    @Override
    public Graph getResultGraph() {
        return null;
    }

    @Override
    public List<Node> getVariables() {
        return this.facts.getVariables();
    }

    @Override
    public List<String> getVariableNames() {
        return this.facts.getVariableNames();
    }
}

