/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.Triple;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.Ion2;
import edu.cmu.tetrad.session.DoNotAddOldModel;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetrad.util.TetradSerializable;
import edu.cmu.tetradapp.model.AbstractAlgorithmRunner;
import edu.cmu.tetradapp.model.FciRunner;
import edu.cmu.tetradapp.model.GraphWrapper;
import edu.cmu.tetradapp.model.IndTestChooser;
import edu.cmu.tetradapp.model.IndTestProducer;
import edu.cmu.tetradapp.model.KnowledgeBoxModel;
import edu.cmu.tetradapp.util.IonInput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class IonRunner
extends AbstractAlgorithmRunner
implements IndTestProducer,
DoNotAddOldModel,
IonInput {
    static final long serialVersionUID = 23L;
    private List<Graph> graphs;

    public IonRunner(IonInput pag, Parameters params) {
        super(params, pag.getGraph());
    }

    public IonRunner(IonInput pag1, IonInput pag2, Parameters params) {
        super(params, pag1.getGraph(), pag2.getGraph());
    }

    public IonRunner(IonInput pag1, IonInput pag2, IonInput pag3, Parameters params) {
        super(params, pag1.getGraph(), pag2.getGraph(), pag3.getGraph());
    }

    public IonRunner(IonInput pag1, IonInput pag2, IonInput pag3, IonInput pag4, Parameters params) {
        super(params, pag1.getGraph(), pag2.getGraph(), pag3.getGraph(), pag4.getGraph());
    }

    public IonRunner(IonInput pag1, IonInput pag2, IonInput pag3, IonInput pag4, IonInput pag5, Parameters params) {
        super(params, pag1.getGraph(), pag2.getGraph(), pag3.getGraph(), pag4.getGraph(), pag5.getGraph());
    }

    public IonRunner(IonInput pag1, IonInput pag2, IonInput pag3, IonInput pag4, IonInput pag5, IonInput pag6, Parameters params) {
        super(params, pag1.getGraph(), pag2.getGraph(), pag3.getGraph(), pag4.getGraph(), pag5.getGraph(), pag6.getGraph());
    }

    public IonRunner(IonInput pag1, IonInput pag2, IonInput pag3, IonInput pag4, IonInput pag5, IonInput pag6, IonInput pag7, Parameters params) {
        super(params, pag1.getGraph(), pag2.getGraph(), pag3.getGraph(), pag4.getGraph(), pag5.getGraph(), pag6.getGraph(), pag7.getGraph());
    }

    public IonRunner(IonInput pag1, IonInput pag2, IonInput pag3, IonInput pag4, IonInput pag5, IonInput pag6, IonInput pag7, IonInput pag8, Parameters params) {
        super(params, pag1.getGraph(), pag2.getGraph(), pag3.getGraph(), pag4.getGraph(), pag5.getGraph(), pag6.getGraph(), pag7.getGraph(), pag8.getGraph());
    }

    public IonRunner(IonInput pag1, IonInput pag2, IonInput pag3, IonInput pag4, IonInput pag5, IonInput pag6, IonInput pag7, IonInput pag8, IonInput pag9, Parameters params) {
        super(params, pag1.getGraph(), pag2.getGraph(), pag3.getGraph(), pag4.getGraph(), pag5.getGraph(), pag6.getGraph(), pag7.getGraph(), pag8.getGraph(), pag9.getGraph());
    }

    public IonRunner(IonInput pag1, IonInput pag2, IonInput pag3, IonInput pag4, IonInput pag5, IonInput pag6, IonInput pag7, IonInput pag8, IonInput pag9, IonInput pag10, Parameters params) {
        super(params, pag1.getGraph(), pag2.getGraph(), pag3.getGraph(), pag4.getGraph(), pag5.getGraph(), pag6.getGraph(), pag7.getGraph(), pag8.getGraph(), pag9.getGraph(), pag10.getGraph());
    }

    public IonRunner(IonInput pag, KnowledgeBoxModel knowledge, Parameters params) {
        super(params, knowledge, pag.getGraph());
    }

    public IonRunner(IonInput pag1, IonInput pag2, KnowledgeBoxModel knowledge, Parameters params) {
        super(params, knowledge, pag1.getGraph(), pag2.getGraph());
    }

    public IonRunner(IonInput pag1, IonInput pag2, IonInput pag3, KnowledgeBoxModel knowledge, Parameters params) {
        super(params, knowledge, pag1.getGraph(), pag2.getGraph(), pag3.getGraph());
    }

    public IonRunner(IonInput pag1, IonInput pag2, IonInput pag3, IonInput pag4, KnowledgeBoxModel knowledge, Parameters params) {
        super(params, knowledge, pag1.getGraph(), pag2.getGraph(), pag3.getGraph(), pag4.getGraph());
    }

    public IonRunner(IonInput pag1, IonInput pag2, IonInput pag3, IonInput pag4, IonInput pag5, KnowledgeBoxModel knowledge, Parameters params) {
        super(params, knowledge, pag1.getGraph(), pag2.getGraph(), pag3.getGraph(), pag4.getGraph(), pag5.getGraph());
    }

    public IonRunner(IonInput pag1, IonInput pag2, IonInput pag3, IonInput pag4, IonInput pag5, IonInput pag6, KnowledgeBoxModel knowledge, Parameters params) {
        super(params, knowledge, pag1.getGraph(), pag2.getGraph(), pag3.getGraph(), pag4.getGraph(), pag5.getGraph(), pag6.getGraph());
    }

    public IonRunner(IonInput pag1, IonInput pag2, IonInput pag3, IonInput pag4, IonInput pag5, IonInput pag6, IonInput pag7, KnowledgeBoxModel knowledge, Parameters params) {
        super(params, knowledge, pag1.getGraph(), pag2.getGraph(), pag3.getGraph(), pag4.getGraph(), pag5.getGraph(), pag6.getGraph(), pag7.getGraph());
    }

    public IonRunner(IonInput pag1, IonInput pag2, IonInput pag3, IonInput pag4, IonInput pag5, IonInput pag6, IonInput pag7, IonInput pag8, KnowledgeBoxModel knowledge, Parameters params) {
        super(params, knowledge, pag1.getGraph(), pag2.getGraph(), pag3.getGraph(), pag4.getGraph(), pag5.getGraph(), pag6.getGraph(), pag7.getGraph(), pag8.getGraph());
    }

    public IonRunner(IonInput pag1, IonInput pag2, IonInput pag3, IonInput pag4, IonInput pag5, IonInput pag6, IonInput pag7, IonInput pag8, IonInput pag9, KnowledgeBoxModel knowledge, Parameters params) {
        super(params, knowledge, pag1.getGraph(), pag2.getGraph(), pag3.getGraph(), pag4.getGraph(), pag5.getGraph(), pag6.getGraph(), pag7.getGraph(), pag8.getGraph(), pag9.getGraph());
    }

    public IonRunner(IonInput pag1, IonInput pag2, IonInput pag3, IonInput pag4, IonInput pag5, IonInput pag6, IonInput pag7, IonInput pag8, IonInput pag9, IonInput pag10, KnowledgeBoxModel knowledge, Parameters params) {
        super(params, knowledge, pag1.getGraph(), pag2.getGraph(), pag3.getGraph(), pag4.getGraph(), pag5.getGraph(), pag6.getGraph(), pag7.getGraph(), pag8.getGraph(), pag9.getGraph(), pag10.getGraph());
    }

    public IonRunner(FciRunner fci, Parameters params) {
        super(params, fci.getResultGraph());
    }

    public IonRunner(FciRunner fci1, FciRunner fci2, Parameters params) {
        super(params, fci1.getResultGraph(), fci2.getResultGraph());
    }

    public IonRunner(FciRunner fci1, FciRunner fci2, FciRunner fci3, Parameters params) {
        super(params, fci1.getResultGraph(), fci2.getResultGraph(), fci3.getResultGraph());
    }

    public IonRunner(FciRunner fci1, FciRunner fci2, FciRunner fci3, FciRunner fci4, Parameters params) {
        super(params, fci1.getResultGraph(), fci2.getResultGraph(), fci3.getResultGraph(), fci4.getResultGraph());
    }

    public static IonRunner serializableInstance() {
        return new IonRunner(new GraphWrapper(new EdgeListGraph()), new Parameters());
    }

    @Override
    public void execute() {
        System.out.println("Executing.");
        Ion2 ion = new Ion2(this.getGraphs());
        ion.setAdjacencySearch(this.getParams().getBoolean("pruneByAdjacencies", true));
        ion.setPathLengthSearch(this.getParams().getBoolean("pruneByPathLength", true));
        ion.setKnowledge((Knowledge)this.getParams().get("knowledge", new Knowledge()));
        List<Graph> graphs = ion.search();
        Collections.sort(graphs, new Comparator<Graph>(){

            @Override
            public int compare(Graph graph, Graph graph1) {
                return graph.getNumEdges() - graph1.getNumEdges();
            }
        });
        if (graphs == null) {
            throw new NullPointerException();
        }
        if (!graphs.isEmpty()) {
            this.setResultGraph(graphs.get(0));
        }
        System.out.println("graphs = " + graphs);
        this.getParams().set("graphIndex", (Object)0);
        this.graphs = graphs;
    }

    @Override
    public IndependenceTest getIndependenceTest() {
        TetradSerializable dataModel = this.getDataModel();
        if (dataModel == null) {
            dataModel = this.getSourceGraph();
        }
        return new IndTestChooser().getTest(dataModel, this.getParams());
    }

    @Override
    public Graph getGraph() {
        return this.getResultGraph();
    }

    @Override
    public List<String> getTriplesClassificationTypes() {
        return new ArrayList<String>();
    }

    @Override
    public List<List<Triple>> getTriplesLists(Node node) {
        return new ArrayList<List<Triple>>();
    }

    @Override
    public boolean supportsKnowledge() {
        return true;
    }

    @Override
    public String getAlgorithmName() {
        return "ION";
    }

    public List<Graph> getStoredGraphs() {
        if (this.graphs == null) {
            return new ArrayList<Graph>();
        }
        return new ArrayList<Graph>(this.graphs);
    }
}

