/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.data.KnowledgeBoxInput;
import edu.cmu.tetrad.data.KnowledgeTransferable;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.session.ParamsResettable;
import edu.cmu.tetrad.session.SessionModel;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetradapp.model.GraphWrapper;
import edu.cmu.tetradapp.model.KnowledgeEditable;
import edu.cmu.tetradapp.model.TimeLagGraphWrapper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;

public class KnowledgeBoxModel
implements SessionModel,
ParamsResettable,
KnowledgeEditable {
    static final long serialVersionUID = 23L;
    private final Graph sourceGraph = new EdgeListGraph();
    private String name;
    private Parameters params;
    private Knowledge knowledge = new Knowledge();
    private List<Node> variables = new ArrayList<Node>();
    private List<String> variableNames = new ArrayList<String>();
    private int numTiers = 3;

    public KnowledgeBoxModel(Parameters params) {
        this.knowledge = new Knowledge();
        this.numTiers = 3;
        this.variables = new ArrayList<Node>();
        this.params = params;
        this.params.set("__myKnowledge", (Object)this.knowledge);
    }

    public KnowledgeBoxModel(KnowledgeBoxInput[] inputs, Parameters params) {
        if (params == null) {
            throw new NullPointerException();
        }
        if (inputs.length == 1 && inputs[0] instanceof TimeLagGraphWrapper) {
            this.knowledge = ((TimeLagGraphWrapper)inputs[0]).getKnowledge();
            return;
        }
        if (inputs.length == 1 && inputs[0] instanceof KnowledgeTransferable) {
            this.knowledge = ((KnowledgeTransferable)((Object)inputs[0])).getKnowledge();
            this.numTiers = this.knowledge.getNumTiers();
            return;
        }
        for (KnowledgeBoxInput input : inputs) {
            if (input != null) continue;
            throw new NullPointerException();
        }
        TreeSet<Node> variableNodes = new TreeSet<Node>();
        TreeSet<String> variableNames = new TreeSet<String>();
        for (KnowledgeBoxInput input : inputs) {
            for (Node node : input.getVariables()) {
                if (node.getNodeType() != NodeType.MEASURED) continue;
                variableNodes.add(node);
                variableNames.add(node.getName());
                this.knowledge.addVariable(node.getName());
            }
        }
        this.variables = new ArrayList<Node>(variableNodes);
        this.variableNames = new ArrayList<String>(variableNames);
        this.params = params;
        Object myKnowledge = params.get("__myKnowledge");
        if (myKnowledge instanceof Knowledge && new HashSet<String>(((Knowledge)myKnowledge).getVariables()).equals(new HashSet(variableNames))) {
            this.knowledge = (Knowledge)myKnowledge;
        } else {
            this.knowledge = new Knowledge();
            for (String var : variableNames) {
                this.knowledge.addVariable(var);
            }
            params.set("__myKnowledge", (Object)this.knowledge);
        }
        TetradLogger.getInstance().log("info", "Knowledge");
    }

    public static KnowledgeBoxModel serializableInstance() {
        return new KnowledgeBoxModel(new KnowledgeBoxInput[]{GraphWrapper.serializableInstance()}, new Parameters());
    }

    private void freshenKnowledgeIfEmpty(List<String> varNames) {
        if (this.knowledge.isEmpty()) {
            this.createKnowledge(this.knowledge);
            for (String varName : varNames) {
                if (varName.startsWith("E_")) continue;
                varNames.add(varName);
            }
        }
    }

    private void createKnowledge(Knowledge knowledge) {
        knowledge.clear();
        this.variableNames.clear();
        for (String varName : knowledge.getVariables()) {
            knowledge.addVariable(varName);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Graph getSourceGraph() {
        return this.sourceGraph;
    }

    public Graph getResultGraph() {
        return this.sourceGraph;
    }

    @Override
    public List<String> getVarNames() {
        return this.variableNames;
    }

    @Override
    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    @Override
    public void setKnowledge(Knowledge knowledge) {
        if (knowledge == null) {
            throw new NullPointerException();
        }
        this.knowledge = knowledge;
        this.numTiers = knowledge.getNumTiers();
        this.params.set("__myKnowledge", (Object)knowledge);
    }

    @Override
    public void resetParams(Object params) {
        this.params = (Parameters)params;
        this.freshenKnowledgeIfEmpty(this.variableNames);
    }

    @Override
    public Object getResettableParams() {
        return this.params;
    }

    public List<Node> getVariables() {
        return this.variables;
    }

    public List<String> getVariableNames() {
        return this.variableNames;
    }

    public int getNumTiers() {
        return this.numTiers;
    }

    public void setNumTiers(int numTiers) {
        this.numTiers = numTiers;
    }
}

