/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataModelList;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataUtils;
import edu.cmu.tetrad.data.LogDataUtils;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.PcRunner;

public class LogData
extends DataWrapper {
    static final long serialVersionUID = 23L;

    public LogData(DataWrapper wrapper, Parameters params) {
        DataModelList inList = wrapper.getDataModelList();
        DataModelList outList = new DataModelList();
        for (DataModel model : inList) {
            if (!(model instanceof DataSet)) {
                throw new IllegalArgumentException("Not a data set: " + model.getName());
            }
            DataSet dataSet = (DataSet)model;
            double a = params.getDouble("a");
            boolean isUnlog = params.getBoolean("unlog");
            int base = params.getInt("base");
            DataSet dataSet2 = DataUtils.logData(dataSet, a, isUnlog, base);
            outList.add(dataSet2);
        }
        this.setDataModel(outList);
        this.setSourceGraph(wrapper.getSourceGraph());
        LogDataUtils.logDataModelList("Logarithmic conversion of data.", this.getDataModelList());
    }

    public static PcRunner serializableInstance() {
        return PcRunner.serializableInstance();
    }
}

