/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.BoxDataSet;
import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataModelList;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DiscreteVariable;
import edu.cmu.tetrad.data.VerticalDoubleDataBox;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.Triple;
import edu.cmu.tetrad.regression.LogisticRegression;
import edu.cmu.tetrad.search.ImpliedOrientation;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetradapp.model.AlgorithmRunner;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.RegressionModel;
import edu.cmu.tetradapp.model.Simulation;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class LogisticRegressionRunner
implements AlgorithmRunner,
RegressionModel {
    static final long serialVersionUID = 23L;
    private String name;
    private final Parameters params;
    private String targetName;
    private List<String> regressorNames = new ArrayList<String>();
    private List<DataSet> dataSets;
    private String report;
    private Graph outGraph;
    private LogisticRegression.Result result;
    private double alpha = 0.001;
    private int numModels = 1;
    private int modelIndex;
    private String modelSourceName;
    private final List<String> variableNames;

    public LogisticRegressionRunner(DataWrapper dataWrapper, Parameters params) {
        if (dataWrapper == null) {
            throw new NullPointerException();
        }
        if (params == null) {
            throw new NullPointerException();
        }
        if (dataWrapper instanceof Simulation) {
            Simulation simulation = (Simulation)dataWrapper;
            DataModelList dataModelList = dataWrapper.getDataModelList();
            this.dataSets = new ArrayList<DataSet>();
            for (DataModel dataModel : dataModelList) {
                this.dataSets.add((DataSet)dataModel);
            }
            this.numModels = dataModelList.size();
            this.modelIndex = 0;
            this.modelSourceName = simulation.getName();
        } else {
            DataModel dataModel = dataWrapper.getSelectedDataModel();
            if (!(dataModel instanceof DataSet)) {
                throw new IllegalArgumentException("Data set must be tabular.");
            }
            this.setDataSet((DataSet)dataModel);
        }
        this.params = params;
        this.variableNames = this.getDataModel().getVariableNames();
        this.targetName = null;
        this.regressorNames = new ArrayList<String>();
        TetradLogger.getInstance().log("info", "Linear Regression");
        if (this.result == null) {
            TetradLogger.getInstance().log("info", "Please double click this regression node to run the regession.");
        } else {
            TetradLogger.getInstance().log("result", this.report);
        }
    }

    public static LogisticRegressionRunner serializableInstance() {
        LinkedList<Node> variables = new LinkedList<Node>();
        ContinuousVariable var1 = new ContinuousVariable("X");
        ContinuousVariable var2 = new ContinuousVariable("Y");
        variables.add(var1);
        variables.add(var2);
        BoxDataSet dataSet = new BoxDataSet(new VerticalDoubleDataBox(3, variables.size()), variables);
        double[] col1data = new double[]{0.0, 1.0, 2.0};
        double[] col2data = new double[]{2.3, 4.3, 2.5};
        for (int i = 0; i < 3; ++i) {
            dataSet.setDouble(i, 0, col1data[i]);
            dataSet.setDouble(i, 1, col2data[i]);
        }
        DataWrapper dataWrapper = new DataWrapper(dataSet);
        return new LogisticRegressionRunner(dataWrapper, new Parameters());
    }

    @Override
    public DataModel getDataModel() {
        return this.dataSets.get(this.getModelIndex());
    }

    public double getAlpha() {
        return this.alpha;
    }

    public void setAlpha(double alpha) {
        this.alpha = alpha;
    }

    public LogisticRegression.Result getResult() {
        return this.result;
    }

    @Override
    public Parameters getParams() {
        return this.params;
    }

    public Graph getResultGraph() {
        return this.outGraph;
    }

    public void setResultGraph(Graph graph) {
        this.outGraph = graph;
    }

    @Override
    public Graph getSourceGraph() {
        return null;
    }

    @Override
    public void execute() {
        this.outGraph = new EdgeListGraph();
        if (this.regressorNames == null || this.regressorNames.isEmpty() || this.targetName == null) {
            this.report = "Response and predictor variables not set.";
            return;
        }
        if (this.regressorNames.contains(this.targetName)) {
            this.report = "Response must not be a predictor.";
            return;
        }
        DataSet regressorsDataSet = this.dataSets.get(this.getModelIndex()).copy();
        Node target = regressorsDataSet.getVariable(this.targetName);
        regressorsDataSet.removeColumn(target);
        List<String> names = regressorsDataSet.getVariableNames();
        ArrayList<Node> regressorNodes = new ArrayList<Node>();
        for (String s : this.regressorNames) {
            regressorNodes.add(this.dataSets.get(this.getModelIndex()).getVariable(s));
        }
        if (this.regressorNames.size() > 0) {
            for (String name1 : names) {
                Node regressorVar = regressorsDataSet.getVariable(name1);
                if (this.regressorNames.contains(regressorVar.getName())) continue;
                regressorsDataSet.removeColumn(regressorVar);
            }
        }
        int ncases = regressorsDataSet.getNumRows();
        int nvars = regressorsDataSet.getNumColumns();
        double[][] regressors = new double[nvars][ncases];
        for (int i = 0; i < nvars; ++i) {
            for (int j = 0; j < ncases; ++j) {
                regressors[i][j] = regressorsDataSet.getDouble(j, i);
            }
        }
        LogisticRegression logRegression = new LogisticRegression(this.dataSets.get(this.getModelIndex()));
        logRegression.setAlpha(this.alpha);
        this.result = logRegression.regress((DiscreteVariable)target, regressorNodes);
    }

    @Override
    public boolean supportsKnowledge() {
        return false;
    }

    @Override
    public ImpliedOrientation getMeekRules() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setExternalGraph(Graph graph) {
    }

    @Override
    public Graph getExternalGraph() {
        return null;
    }

    @Override
    public String getAlgorithmName() {
        return "Logistic-Regression";
    }

    public Graph getOutGraph() {
        return this.outGraph;
    }

    @Override
    public List<String> getVariableNames() {
        return this.variableNames;
    }

    @Override
    public List<String> getRegressorNames() {
        return new ArrayList<String>();
    }

    @Override
    public void setRegressorName(List<String> predictors) {
        this.regressorNames = predictors;
    }

    @Override
    public String getTargetName() {
        return this.targetName;
    }

    @Override
    public void setTargetName(String target) {
        this.targetName = target;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Graph getGraph() {
        return this.outGraph;
    }

    @Override
    public List<String> getTriplesClassificationTypes() {
        return new LinkedList<String>();
    }

    @Override
    public List<List<Triple>> getTriplesLists(Node node) {
        return new LinkedList<List<Triple>>();
    }

    @Override
    public Map<String, String> getParamSettings() {
        HashMap<String, String> paramSettings = new HashMap<String, String>();
        paramSettings.put("Algorithm", "Regression");
        return paramSettings;
    }

    @Override
    public void setAllParamSettings(Map<String, String> paramSettings) {
    }

    @Override
    public Map<String, String> getAllParamSettings() {
        return null;
    }

    public int getNumModels() {
        return this.numModels;
    }

    public int getModelIndex() {
        return this.modelIndex;
    }

    public String getModelSourceName() {
        return this.modelSourceName;
    }

    public void setModelIndex(int modelIndex) {
        this.modelIndex = modelIndex;
    }

    public void setDataSet(DataSet dataSet) {
        this.dataSets = new ArrayList<DataSet>();
        this.dataSets.add(dataSet);
    }

    @Override
    public List<Graph> getGraphs() {
        return null;
    }
}

