/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.Clusters;
import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.KnowledgeBoxInput;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.search.ClusterUtils;
import edu.cmu.tetrad.session.ParamsResettable;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.GraphSource;
import edu.cmu.tetradapp.model.PcRunner;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;

public final class MeasurementModelWrapper
implements ParamsResettable,
KnowledgeBoxInput {
    static final long serialVersionUID = 23L;
    private Clusters clusters;
    private List<String> varNames;
    private String name;
    private DataSet data;
    private Graph sourceGraph;
    private Parameters params;

    public MeasurementModelWrapper(Parameters params) {
        this.setVarNames(new ArrayList<String>());
        Clusters clusters = (Clusters)params.get("clusters", null);
        if (clusters == null) {
            clusters = new Clusters();
        }
        this.setClusters(clusters);
        this.params = params;
    }

    public MeasurementModelWrapper(KnowledgeBoxInput knowledgeInput, Parameters params) {
        if (knowledgeInput instanceof GraphSource) {
            GraphSource graphWrapper = (GraphSource)((Object)knowledgeInput);
            Graph mim = graphWrapper.getGraph();
            Clusters clusters = ClusterUtils.mimClusters(mim);
            ArrayList<String> nodeNames = new ArrayList<String>();
            for (Node node : mim.getNodes()) {
                if (node.getNodeType() == NodeType.LATENT) continue;
                nodeNames.add(node.getName());
            }
            this.setVarNames(nodeNames);
            this.setClusters(clusters);
            this.params = params;
            this.getParams().set("clusters", (Object)clusters);
            this.getParams().set("varNames", (Object)nodeNames);
        } else {
            this.setVarNames(knowledgeInput.getVariableNames());
            this.setClusters((Clusters)params.get("clusters", null));
            this.params = params;
        }
    }

    public MeasurementModelWrapper(DataWrapper dataWrapper, Parameters params) {
        this.setVarNames(dataWrapper.getVarNames());
        this.setClusters(new Clusters());
        DataModel selectedDataModel = dataWrapper.getSelectedDataModel();
        if (!(selectedDataModel instanceof DataSet)) {
            throw new IllegalArgumentException("That data box did not contain a dataset.");
        }
        this.data = (DataSet)selectedDataModel;
        this.params = params;
    }

    public static PcRunner serializableInstance() {
        return PcRunner.serializableInstance();
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
    }

    public Clusters getClusters() {
        return this.clusters;
    }

    private void setClusters(Clusters clusters) {
        this.clusters = clusters;
    }

    public List<String> getVarNames() {
        return this.varNames;
    }

    private void setVarNames(List<String> varNames) {
        this.varNames = varNames;
    }

    public DataSet getData() {
        return this.data;
    }

    @Override
    public Graph getSourceGraph() {
        return this.sourceGraph;
    }

    @Override
    public Graph getResultGraph() {
        return this.sourceGraph;
    }

    private Parameters getParams() {
        return this.params;
    }

    @Override
    public void resetParams(Object params) {
        this.params = (Parameters)params;
    }

    @Override
    public Object getResettableParams() {
        return this.params;
    }

    @Override
    public List<Node> getVariables() {
        ArrayList<Node> latents = new ArrayList<Node>();
        for (String name : this.getVariableNames()) {
            ContinuousVariable node = new ContinuousVariable(name);
            node.setNodeType(NodeType.LATENT);
            latents.add(node);
        }
        return latents;
    }

    @Override
    public List<String> getVariableNames() {
        List<List<Node>> partition = ClusterUtils.clustersToPartition(this.getClusters(), this.getData().getVariables());
        return ClusterUtils.generateLatentNames(partition.size());
    }
}

