/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.Clusters;
import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.LayoutUtil;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.ClusterUtils;
import edu.cmu.tetrad.search.MimUtils;
import edu.cmu.tetrad.search.MimbuildTrek;
import edu.cmu.tetrad.sem.ReidentifyVariables;
import edu.cmu.tetrad.sem.SemPm;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetradapp.model.AbstractMimRunner;
import edu.cmu.tetradapp.model.BuildPureClustersRunner;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.GraphSource;
import edu.cmu.tetradapp.model.KnowledgeBoxModel;
import edu.cmu.tetradapp.model.MeasurementModelWrapper;
import edu.cmu.tetradapp.model.PcRunner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MimBuildTrekRunner
extends AbstractMimRunner
implements GraphSource {
    static final long serialVersionUID = 23L;
    private final DataSet dataSet;
    private Graph fullGraph;
    private ICovarianceMatrix covMatrix;

    public MimBuildTrekRunner(DataWrapper dataWrapper, MeasurementModelWrapper mmWrapper, Parameters params) {
        super(dataWrapper, mmWrapper.getClusters(), params);
        this.dataSet = (DataSet)this.getData();
        this.setClusters(mmWrapper.getClusters());
        params.set("clusters", (Object)mmWrapper.getClusters());
    }

    public MimBuildTrekRunner(DataWrapper dataWrapper, BuildPureClustersRunner mmWrapper, Parameters params) {
        super(dataWrapper, mmWrapper.getClusters(), params);
        this.dataSet = (DataSet)this.getData();
        this.setClusters(mmWrapper.getClusters());
        params.set("clusters", (Object)mmWrapper.getClusters());
    }

    public MimBuildTrekRunner(DataWrapper dataWrapper, MeasurementModelWrapper mmWrapper, Parameters params, KnowledgeBoxModel knowledgeBoxModel) {
        super(dataWrapper, mmWrapper.getClusters(), params);
        this.dataSet = (DataSet)this.getData();
        this.setClusters(mmWrapper.getClusters());
        params.set("clusters", (Object)mmWrapper.getClusters());
        params.set("knowledge", (Object)knowledgeBoxModel.getKnowledge());
    }

    public MimBuildTrekRunner(MeasurementModelWrapper mmWrapper, DataWrapper dataWrapper, Parameters params) {
        super(mmWrapper, mmWrapper.getClusters(), params);
        this.dataSet = (DataSet)dataWrapper.getDataModelList().get(0);
        this.setClusters(mmWrapper.getClusters());
        params.set("clusters", (Object)mmWrapper.getClusters());
    }

    public MimBuildTrekRunner(MimBuildTrekRunner runner, Parameters params) {
        super(runner, params);
        this.dataSet = (DataSet)this.getData();
        this.setClusters((Clusters)params.get("clusters", null));
    }

    public MimBuildTrekRunner(MimBuildTrekRunner runner, KnowledgeBoxModel knowledgeBox, Parameters params) {
        super(runner, params);
        this.dataSet = (DataSet)this.getData();
        this.setClusters((Clusters)params.get("clusters", null));
        params.set("knowledge", (Object)knowledgeBox.getKnowledge());
    }

    public ICovarianceMatrix getCovMatrix() {
        return this.covMatrix;
    }

    public static PcRunner serializableInstance() {
        return PcRunner.serializableInstance();
    }

    @Override
    public void execute() throws Exception {
        DataSet data = this.dataSet;
        MimbuildTrek mimbuild = new MimbuildTrek();
        mimbuild.setAlpha(this.getParams().getDouble("alpha", 0.001));
        mimbuild.setKnowledge((Knowledge)this.getParams().get("knowledge", new Knowledge()));
        if (this.getParams().getBoolean("includeThreeClusters", true)) {
            mimbuild.setMinClusterSize(3);
        } else {
            mimbuild.setMinClusterSize(4);
        }
        Clusters clusters = (Clusters)this.getParams().get("clusters", null);
        List<List<Node>> partition = ClusterUtils.clustersToPartition(clusters, data.getVariables());
        ArrayList<String> latentNames = new ArrayList<String>();
        for (int i = 0; i < clusters.getNumClusters(); ++i) {
            latentNames.add(clusters.getClusterName(i));
        }
        CovarianceMatrix cov = new CovarianceMatrix(data);
        Graph structureGraph = mimbuild.search(partition, latentNames, cov);
        LayoutUtil.circleLayout(structureGraph, 200, 200, 150);
        LayoutUtil.fruchtermanReingoldLayout(structureGraph);
        ICovarianceMatrix latentsCov = mimbuild.getLatentsCov();
        TetradLogger.getInstance().log("details", "Latent covs = \n" + latentsCov);
        Graph fullGraph = mimbuild.getFullGraph();
        LayoutUtil.circleLayout(fullGraph, 200, 200, 150);
        LayoutUtil.fruchtermanReingoldLayout(fullGraph);
        this.setResultGraph(fullGraph);
        this.setFullGraph(fullGraph);
        this.setClusters(MimUtils.convertToClusters(structureGraph));
        this.setClusters(ClusterUtils.partitionToClusters(mimbuild.getClustering()));
        this.setStructureGraph(structureGraph);
        this.getParams().set("latentVariableNames", (Object)new ArrayList<String>(latentNames));
        this.covMatrix = latentsCov;
        double p = mimbuild.getpValue();
        TetradLogger.getInstance().log("details", "\nStructure graph = " + structureGraph);
        TetradLogger.getInstance().log("details", this.getLatentClustersString(fullGraph).toString());
        TetradLogger.getInstance().log("details", "P = " + p);
        if (this.getParams().getBoolean("showMaxP", false)) {
            if (p > this.getParams().getDouble("maxP", 1.0)) {
                this.getParams().set("maxP", (Object)p);
                this.getParams().set("maxStructureGraph", (Object)structureGraph);
                this.getParams().set("maxClusters", (Object)this.getClusters());
                this.getParams().set("maxFullGraph", (Object)fullGraph);
                this.getParams().set("maxAlpha", (Object)this.getParams().getDouble("alpha", 0.001));
            }
            this.setStructureGraph((Graph)this.getParams().get("maxStructureGraph", null));
            this.setFullGraph((Graph)this.getParams().get("maxFullGraph", null));
            if (this.getParams().get("maxClusters", null) != null) {
                this.setClusters((Clusters)this.getParams().get("maxClusters", null));
            }
            this.setResultGraph((Graph)this.getParams().get("maxFullGraph", null));
            TetradLogger.getInstance().log("maxmodel", "\nMAX Graph = " + this.getParams().get("maxStructureGraph", null));
            TetradLogger.getInstance().log("maxmodel", this.getLatentClustersString((Graph)this.getParams().get("maxFullGraph", null)).toString());
            TetradLogger.getInstance().log("maxmodel", "MAX P = " + this.getParams().getDouble("maxP", 1.0));
        }
    }

    private StringBuilder getLatentClustersString(Graph graph) {
        StringBuilder builder = new StringBuilder();
        builder.append("Latent Clusters:\n");
        List<Node> latents = ReidentifyVariables.getLatents(graph);
        Collections.sort(latents);
        for (Node latent : latents) {
            List<Node> children = graph.getChildren(latent);
            children.removeAll(latents);
            Collections.sort(children);
            builder.append(latent.getName()).append(": ");
            for (Node child : children) {
                builder.append(child + " ");
            }
            builder.append("\n");
        }
        return builder;
    }

    private void setFullGraph(Graph fullGraph) {
        this.fullGraph = fullGraph;
    }

    @Override
    public Graph getGraph() {
        return this.getResultGraph();
    }

    public SemPm getSemPm() {
        Graph graph = this.getResultGraph();
        return new SemPm(graph);
    }

    @Override
    public Graph getFullGraph() {
        return this.fullGraph;
    }
}

