/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.MisclassificationUtils;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.session.DoNotAddOldModel;
import edu.cmu.tetrad.session.SessionModel;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetradapp.model.GraphSource;
import java.io.IOException;
import java.io.ObjectInputStream;

public final class Misclassifications
implements SessionModel,
DoNotAddOldModel {
    static final long serialVersionUID = 23L;
    private final Graph targetGraph;
    private final Graph referenceGraph;
    private final Parameters params;
    private String name;

    public Misclassifications(GraphSource model1, GraphSource model2, Parameters params) {
        if (params == null) {
            throw new NullPointerException("Parameters must not be null");
        }
        if (model1 == null || model2 == null) {
            throw new NullPointerException("Null graph source>");
        }
        this.params = params;
        String referenceName = params.getString("referenceGraphName", null);
        String model1Name = model1.getName();
        String model2Name = model2.getName();
        if (referenceName.equals(model1Name)) {
            this.referenceGraph = model1.getGraph();
            this.targetGraph = model2.getGraph();
        } else if (referenceName.equals(model2Name)) {
            this.referenceGraph = model2.getGraph();
            this.targetGraph = model1.getGraph();
        } else {
            this.referenceGraph = model1.getGraph();
            this.targetGraph = model2.getGraph();
        }
        TetradLogger.getInstance().log("info", "Graph Comparison");
    }

    public DataSet getDataSet() {
        return (DataSet)this.params.get("dataSet", null);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public String getComparisonString() {
        String refName = this.getParams().getString("referenceGraphName", null);
        String targetName = this.getParams().getString("targetGraphName", null);
        Graph comparisonGraph = Misclassifications.getComparisonGraph(this.referenceGraph, this.params);
        return "True graph from " + refName + "\nTarget graph from " + targetName + "\n\n\nEdge Misclassification Table:\n" + MisclassificationUtils.edgeMisclassifications(this.targetGraph, comparisonGraph) + "\n\nEndpoint Misclassification Table:\n\n" + MisclassificationUtils.endpointMisclassification(this.targetGraph, comparisonGraph);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
    }

    public Parameters getParams() {
        return this.params;
    }

    public static Graph getComparisonGraph(Graph graph, Parameters params) {
        String type = params.getString("graphComparisonType");
        if ("DAG".equals(type)) {
            params.set("graphComparisonType", "DAG");
            return new EdgeListGraph(graph);
        }
        if ("CPDAG".equals(type)) {
            params.set("graphComparisonType", "CPDAG");
            return SearchGraphUtils.cpdagForDag(graph);
        }
        if ("PAG".equals(type)) {
            params.set("graphComparisonType", "PAG");
            return SearchGraphUtils.dagToPag(graph);
        }
        params.set("graphComparisonType", "DAG");
        return new EdgeListGraph(graph);
    }

    public Graph getReferenceGraph() {
        return this.referenceGraph;
    }
}

