/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataUtils;
import edu.cmu.tetrad.data.LogDataUtils;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.PcRunner;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;

public class MissingDataInjectorWrapper
extends DataWrapper {
    static final long serialVersionUID = 23L;
    private final DataSet outputDataSet;

    public MissingDataInjectorWrapper(DataWrapper wrapper, Parameters params) {
        DataSet dataSet = (DataSet)wrapper.getSelectedDataModel();
        int numVars = dataSet.getNumColumns();
        double prob = params.getDouble("prob", 0.02);
        double[] probs = new double[numVars];
        Arrays.fill(probs, prob);
        this.outputDataSet = DataUtils.addMissingData(dataSet, probs);
        this.setDataModel(this.outputDataSet);
        this.setSourceGraph(wrapper.getSourceGraph());
        LogDataUtils.logDataModelList("Parent data with missing values injected randomly.", this.getDataModelList());
    }

    public static PcRunner serializableInstance() {
        return PcRunner.serializableInstance();
    }

    public DataSet getOutputDataset() {
        return this.outputDataSet;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.outputDataSet == null) {
            throw new NullPointerException();
        }
    }
}

