/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.BoxDataSet;
import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataUtils;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.data.VerticalDoubleDataBox;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.LayoutUtil;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.Triple;
import edu.cmu.tetrad.search.HbmsBeam;
import edu.cmu.tetrad.search.Hbsms;
import edu.cmu.tetrad.search.HbsmsGes;
import edu.cmu.tetrad.search.ImpliedOrientation;
import edu.cmu.tetrad.search.MeekRules;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.util.Matrix;
import edu.cmu.tetrad.util.MatrixUtils;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetrad.util.RandomUtil;
import edu.cmu.tetradapp.model.AbstractAlgorithmRunner;
import edu.cmu.tetradapp.model.DagWrapper;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.GraphWrapper;
import edu.cmu.tetradapp.model.KnowledgeBoxModel;
import edu.cmu.tetradapp.model.PcRunner;
import edu.cmu.tetradapp.model.SemGraphWrapper;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class PValueImproverWrapper
extends AbstractAlgorithmRunner {
    static final long serialVersionUID = 23L;
    private AlgorithmType algorithmType = AlgorithmType.BEAM;
    private String name;
    private Graph externalGraph;
    private Graph graph;
    private transient List<PropertyChangeListener> listeners;
    private final DataWrapper dataWrapper;
    private final Parameters params = new Parameters();
    private Parameters params2;
    private SemIm estSem;
    private Graph trueDag;
    private final double alpha = 0.05;
    private SemIm originalSemIm;
    private SemIm newSemIm;
    private SemIm semIm;

    public PValueImproverWrapper(DataWrapper dataWrapper, Parameters params, KnowledgeBoxModel knowledgeBoxModel) {
        super(dataWrapper, params, knowledgeBoxModel);
        this.dataWrapper = dataWrapper;
        this.params2 = params;
        this.graph = new EdgeListGraph(dataWrapper.getSelectedDataModel().getVariables());
    }

    public PValueImproverWrapper(DataWrapper dataWrapper, Parameters params) {
        super(dataWrapper, params, null);
        this.dataWrapper = dataWrapper;
        this.params2 = params;
        this.setGraph(new EdgeListGraph(dataWrapper.getSelectedDataModel().getVariables()));
    }

    private void setGraph(EdgeListGraph graph) {
        this.graph = new EdgeListGraph(graph);
        this.externalGraph = new EdgeListGraph(graph);
    }

    public PValueImproverWrapper(GraphWrapper graphWrapper, DataWrapper dataWrapper, Parameters params, KnowledgeBoxModel knowledgeBoxModel) {
        super(dataWrapper, params, knowledgeBoxModel);
        this.dataWrapper = dataWrapper;
        this.params2 = params;
        this.setGraph(new EdgeListGraph(graphWrapper.getGraph()));
    }

    public PValueImproverWrapper(GraphWrapper graphWrapper, DataWrapper dataWrapper, Parameters params) {
        super(dataWrapper, params);
        this.dataWrapper = dataWrapper;
        this.params2 = params;
        this.setGraph(new EdgeListGraph(graphWrapper.getGraph()));
    }

    public PValueImproverWrapper(DagWrapper graphWrapper, DataWrapper dataWrapper, Parameters params, KnowledgeBoxModel knowledgeBoxModel) {
        super(dataWrapper, params, knowledgeBoxModel);
        this.dataWrapper = dataWrapper;
        this.params2 = params;
        this.setGraph(new EdgeListGraph(graphWrapper.getGraph()));
    }

    public PValueImproverWrapper(DagWrapper graphWrapper, DataWrapper dataWrapper, Parameters params) {
        super(dataWrapper, params);
        this.dataWrapper = dataWrapper;
        this.params2 = params;
        this.setGraph(new EdgeListGraph(graphWrapper.getGraph()));
    }

    public PValueImproverWrapper(SemGraphWrapper graphWrapper, DataWrapper dataWrapper, Parameters params, KnowledgeBoxModel knowledgeBoxModel) {
        super(dataWrapper, params, knowledgeBoxModel);
        this.dataWrapper = dataWrapper;
        this.params2 = params;
        this.setGraph(new EdgeListGraph(graphWrapper.getGraph()));
    }

    public PValueImproverWrapper(SemGraphWrapper graphWrapper, DataWrapper dataWrapper, Parameters params) {
        super(dataWrapper, params);
        this.dataWrapper = dataWrapper;
        this.params2 = params;
        this.setGraph(new EdgeListGraph(graphWrapper.getGraph()));
    }

    public PValueImproverWrapper(AbstractAlgorithmRunner graphWrapper, DataWrapper dataWrapper, Parameters params, KnowledgeBoxModel knowledgeBoxModel) {
        super(dataWrapper, params, knowledgeBoxModel);
        this.dataWrapper = dataWrapper;
        this.params2 = params;
        this.setGraph(new EdgeListGraph(graphWrapper.getGraph()));
    }

    public PValueImproverWrapper(AbstractAlgorithmRunner graphWrapper, DataWrapper dataWrapper, Parameters params) {
        super(dataWrapper, params);
        this.dataWrapper = dataWrapper;
        this.params2 = params;
        this.setGraph(new EdgeListGraph(graphWrapper.getGraph()));
    }

    public static PcRunner serializableInstance() {
        return PcRunner.serializableInstance();
    }

    public AlgorithmType getAlgorithmType() {
        return this.algorithmType;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean isShuffleMoves() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute() {
        Hbsms search;
        DataModel dataModel = this.getDataModel();
        Knowledge knowledge = (Knowledge)this.params2.get("knowledge", new Knowledge());
        if (this.externalGraph == null) {
            this.externalGraph = new EdgeListGraph(dataModel.getVariables());
        }
        EdgeListGraph edgeListGraph = new EdgeListGraph(this.externalGraph);
        Graph graph = GraphUtils.replaceNodes(edgeListGraph, dataModel.getVariables());
        if (dataModel instanceof DataSet) {
            DataSet dataSet = (DataSet)dataModel;
            if (this.getAlgorithmType() == AlgorithmType.BEAM) {
                search = new HbmsBeam(graph, dataSet, knowledge);
            } else {
                if (this.getAlgorithmType() != AlgorithmType.FGES) throw new IllegalStateException();
                search = new HbsmsGes(graph, dataSet);
                search.setKnowledge(knowledge);
            }
        } else {
            if (!(dataModel instanceof CovarianceMatrix)) throw new IllegalStateException();
            CovarianceMatrix covarianceMatrix = (CovarianceMatrix)dataModel;
            if (this.getAlgorithmType() == AlgorithmType.BEAM) {
                search = new HbmsBeam(graph, covarianceMatrix, knowledge);
            } else {
                if (this.getAlgorithmType() != AlgorithmType.FGES) throw new IllegalStateException();
                throw new IllegalArgumentException("GES method requires a dataset; a covariance matrix was provided.");
            }
        }
        Parameters params = this.getParams();
        search.setAlpha(params.getDouble("alpha", 0.001));
        search.setBeamWidth(params.getInt("beamWidth", 5));
        search.setHighPValueAlpha(params.getDouble("zeroEdgeP", 0.05));
        this.graph = search.search();
        this.setOriginalSemIm(search.getOriginalSemIm());
        this.newSemIm = search.getNewSemIm();
        this.fireGraphChange(this.graph);
        if (this.getSourceGraph() != null) {
            LayoutUtil.arrangeBySourceGraph(this.graph, this.getSourceGraph());
        } else if (knowledge.isDefaultToKnowledgeLayout()) {
            SearchGraphUtils.arrangeByKnowledgeTiers(this.graph, knowledge);
        } else {
            LayoutUtil.circleLayout(this.graph, 200, 200, 150);
        }
        this.setResultGraph(SearchGraphUtils.cpdagForDag(this.graph));
    }

    @Override
    public boolean supportsKnowledge() {
        return true;
    }

    @Override
    public ImpliedOrientation getMeekRules() {
        MeekRules rules = new MeekRules();
        rules.setKnowledge((Knowledge)this.params.get("knowledge", new Knowledge()));
        return rules;
    }

    @Override
    public String getAlgorithmName() {
        return "BFF";
    }

    public void setAlgorithmType(AlgorithmType algorithmType) {
        this.algorithmType = algorithmType;
    }

    private boolean isAggressivelyPreventCycles() {
        return this.params.getBoolean("aggressivelyPreventCycles", false);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (!this.getListeners().contains(l)) {
            this.getListeners().add(l);
        }
    }

    private void fireGraphChange(Graph graph) {
        for (PropertyChangeListener l : this.getListeners()) {
            l.propertyChange(new PropertyChangeEvent(this, "graph", null, graph));
        }
    }

    @Override
    public Graph getGraph() {
        return this.getResultGraph();
    }

    @Override
    public List<String> getTriplesClassificationTypes() {
        return new LinkedList<String>();
    }

    @Override
    public List<List<Triple>> getTriplesLists(Node node) {
        return new LinkedList<List<Triple>>();
    }

    private List<PropertyChangeListener> getListeners() {
        if (this.listeners == null) {
            this.listeners = new ArrayList<PropertyChangeListener>();
        }
        return this.listeners;
    }

    public DataSet simulateDataCholesky(int sampleSize, Matrix covar, List<Node> variableNodes) {
        LinkedList<Node> variables = new LinkedList<Node>(variableNodes);
        ArrayList<Node> newVariables = new ArrayList<Node>();
        for (Node node : variables) {
            ContinuousVariable continuousVariable = new ContinuousVariable(node.getName());
            continuousVariable.setNodeType(node.getNodeType());
            newVariables.add(continuousVariable);
        }
        BoxDataSet fullDataSet = new BoxDataSet(new VerticalDoubleDataBox(sampleSize, newVariables.size()), newVariables);
        Matrix cholesky = MatrixUtils.cholesky(covar);
        for (int row = 0; row < sampleSize; ++row) {
            double[] exoData = new double[cholesky.rows()];
            for (int i = 0; i < exoData.length; ++i) {
                exoData[i] = RandomUtil.getInstance().nextNormal(0.0, 1.0);
            }
            double[] point = new double[exoData.length];
            for (int i = 0; i < exoData.length; ++i) {
                double sum = 0.0;
                for (int j = 0; j <= i; ++j) {
                    sum += cholesky.get(i, j) * exoData[j];
                }
                point[i] = sum;
            }
            for (int col = 0; col < variables.size(); ++col) {
                int index = variableNodes.indexOf(variables.get(col));
                double value = point[index];
                if (Double.isNaN(value) || Double.isInfinite(value)) {
                    throw new IllegalArgumentException("Value out of range: " + value);
                }
                fullDataSet.setDouble(row, col, value);
            }
        }
        return DataUtils.restrictToMeasured(fullDataSet);
    }

    private void setOriginalSemIm(SemIm originalSemIm) {
        if (this.originalSemIm == null) {
            this.originalSemIm = originalSemIm;
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.params2 == null) {
            this.params2 = new Parameters();
        }
    }

    public SemIm getOriginalSemIm() {
        return this.originalSemIm;
    }

    public SemIm getNewSemIm() {
        return this.newSemIm;
    }

    public void setNewSemIm(SemIm newSemIm) {
        this.newSemIm = newSemIm;
    }

    public static enum AlgorithmType {
        BEAM,
        FGES;

    }
}

