/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.session.DoNotAddOldModel;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetradapp.model.GraphSource;
import edu.cmu.tetradapp.model.GraphWrapper;

public class PagFromDagGraphWrapper
extends GraphWrapper
implements DoNotAddOldModel {
    static final long serialVersionUID = 23L;

    public PagFromDagGraphWrapper(GraphSource source, Parameters parameters) {
        this(source.getGraph());
    }

    public PagFromDagGraphWrapper(Graph graph) {
        super(graph);
        if (graph.paths().existsDirectedCycle()) {
            throw new IllegalArgumentException("The source graph is not a DAG.");
        }
        Graph pag = SearchGraphUtils.dagToPag(graph);
        this.setGraph(pag);
        TetradLogger.getInstance().log("info", "\nGenerating allow_latent_common_causes from DAG.");
        TetradLogger.getInstance().log("CPDAG", pag + "");
    }

    public static PagFromDagGraphWrapper serializableInstance() {
        return new PagFromDagGraphWrapper(EdgeListGraph.serializableInstance());
    }

    @Override
    public boolean allowRandomGraph() {
        return false;
    }
}

