/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.Clusters;
import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.CorrelationMatrix;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.data.KnowledgeBoxInput;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.LayoutUtil;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.search.ClusterUtils;
import edu.cmu.tetrad.search.ContinuousTetradTest;
import edu.cmu.tetrad.search.PurifyTetradBased2;
import edu.cmu.tetrad.search.TestType;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetradapp.model.AbstractMimRunner;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.GraphSource;
import edu.cmu.tetradapp.model.MeasurementModelWrapper;
import edu.cmu.tetradapp.model.PcRunner;
import java.util.ArrayList;
import java.util.List;

public class PurifyRunner
extends AbstractMimRunner
implements GraphSource,
KnowledgeBoxInput {
    static final long serialVersionUID = 23L;

    public PurifyRunner(DataWrapper dataWrapper, MeasurementModelWrapper mmWrapper, Parameters params) {
        super(dataWrapper, mmWrapper.getClusters(), params);
        this.setClusters(mmWrapper.getClusters());
        params.set("clusters", (Object)mmWrapper.getClusters());
    }

    public static PcRunner serializableInstance() {
        return PcRunner.serializableInstance();
    }

    @Override
    public void execute() {
        ContinuousTetradTest test;
        DataModel source = this.getData();
        System.out.println("Clusters " + this.getParams().get("clusters", null));
        if (source instanceof ICovarianceMatrix) {
            ICovarianceMatrix covMatrix = (ICovarianceMatrix)source;
            CorrelationMatrix corrMatrix = new CorrelationMatrix(covMatrix);
            double alpha = this.getParams().getDouble("alpha", 0.001);
            TestType sigTestType = (TestType)this.getParams().get("tetradTestType", TestType.TETRAD_WISHART);
            test = new ContinuousTetradTest(covMatrix, sigTestType, alpha);
        } else if (source instanceof DataSet) {
            DataSet data = (DataSet)source;
            double alpha = this.getParams().getDouble("alpha", 0.001);
            TestType sigTestType = (TestType)this.getParams().get("tetradTestType", TestType.TETRAD_WISHART);
            test = new ContinuousTetradTest(data, sigTestType, alpha);
        } else {
            throw new RuntimeException("Data source for Purify of invalid type!");
        }
        List<List<Node>> inputPartition = ClusterUtils.clustersToPartition((Clusters)this.getParams().get("clusters", null), test.getVariables());
        PurifyTetradBased2 purify = new PurifyTetradBased2(test);
        List<List<Node>> partition = purify.purify(inputPartition);
        Clusters outputClusters = ClusterUtils.partitionToClusters(partition);
        List<int[]> partitionAsInts = ClusterUtils.convertListToInt(partition, test.getVariables());
        this.setResultGraph(ClusterUtils.convertSearchGraph(partitionAsInts, test.getVarNames()));
        LayoutUtil.fruchtermanReingoldLayout(this.getResultGraph());
        this.setClusters(outputClusters);
    }

    @Override
    public Clusters getClusters() {
        return super.getClusters();
    }

    @Override
    protected void setClusters(Clusters clusters) {
        super.setClusters(clusters);
    }

    @Override
    public Graph getGraph() {
        return this.getResultGraph();
    }

    @Override
    public List<Node> getVariables() {
        ArrayList<Node> latents = new ArrayList<Node>();
        for (String name : this.getVariableNames()) {
            ContinuousVariable node = new ContinuousVariable(name);
            node.setNodeType(NodeType.LATENT);
            latents.add(node);
        }
        return latents;
    }

    @Override
    public List<String> getVariableNames() {
        List<List<Node>> partition = ClusterUtils.clustersToPartition(this.getClusters(), this.getData().getVariables());
        return ClusterUtils.generateLatentNames(partition.size());
    }
}

