/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.BoxDataSet;
import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataModelList;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DoubleDataBox;
import edu.cmu.tetrad.data.ICovarianceMatrix;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.Triple;
import edu.cmu.tetrad.regression.RegressionCovariance;
import edu.cmu.tetrad.regression.RegressionDataset;
import edu.cmu.tetrad.regression.RegressionResult;
import edu.cmu.tetrad.search.ImpliedOrientation;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetradapp.model.AlgorithmRunner;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.RegressionModel;
import edu.cmu.tetradapp.model.Simulation;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class RegressionRunner
implements AlgorithmRunner,
RegressionModel {
    static final long serialVersionUID = 23L;
    private List<String> regressorNames;
    private String name;
    private final Parameters params;
    private String targetName;
    private final DataModelList dataModels;
    private Graph outGraph;
    private RegressionResult result;
    private Map<String, String> allParamsSettings;
    private final List<String> variableNames;
    private int numModels = 1;
    private int modelIndex;
    private String modelSourceName;

    public RegressionRunner(DataWrapper dataWrapper, Parameters params) {
        DataSet _dataSet;
        if (dataWrapper == null) {
            throw new NullPointerException();
        }
        if (params == null) {
            throw new NullPointerException();
        }
        if (dataWrapper instanceof Simulation) {
            Simulation simulation = (Simulation)dataWrapper;
            this.numModels = dataWrapper.getDataModelList().size();
            this.modelIndex = 0;
            this.modelSourceName = simulation.getName();
        }
        this.params = params;
        DataModel dataModel = dataWrapper.getSelectedDataModel();
        if (dataModel instanceof DataSet && !(_dataSet = (DataSet)dataModel).isContinuous()) {
            throw new IllegalArgumentException("Data set must be continuous.");
        }
        this.dataModels = dataWrapper.getDataModelList();
        this.variableNames = dataModel.getVariableNames();
        this.targetName = null;
        this.regressorNames = new ArrayList<String>();
        TetradLogger.getInstance().log("info", "Linear Regression");
        if (this.result == null) {
            TetradLogger.getInstance().log("info", "Please double click this regression node to run the regession.");
        } else {
            TetradLogger.getInstance().log("result", "\n" + this.result.getResultsTable().toString());
        }
    }

    public static RegressionRunner serializableInstance() {
        LinkedList<Node> variables = new LinkedList<Node>();
        ContinuousVariable var1 = new ContinuousVariable("X");
        ContinuousVariable var2 = new ContinuousVariable("Y");
        variables.add(var1);
        variables.add(var2);
        BoxDataSet _dataSet = new BoxDataSet(new DoubleDataBox(3, variables.size()), variables);
        double[] col1data = new double[]{0.0, 1.0, 2.0};
        double[] col2data = new double[]{2.3, 4.3, 2.5};
        for (int i = 0; i < 3; ++i) {
            _dataSet.setDouble(i, 0, col1data[i]);
            _dataSet.setDouble(i, 1, col2data[i]);
        }
        DataWrapper dataWrapper = new DataWrapper(_dataSet);
        return new RegressionRunner(dataWrapper, new Parameters());
    }

    @Override
    public DataModel getDataModel() {
        return this.dataModels.get(this.getModelIndex());
    }

    @Override
    public Parameters getParams() {
        return this.params;
    }

    public Graph getResultGraph() {
        return this.outGraph;
    }

    private void setResultGraph(Graph graph) {
        this.outGraph = graph;
    }

    @Override
    public Graph getSourceGraph() {
        return null;
    }

    @Override
    public void execute() {
        if (this.regressorNames.size() == 0 || this.targetName == null) {
            this.outGraph = new EdgeListGraph();
            return;
        }
        if (this.regressorNames.contains(this.targetName)) {
            this.outGraph = new EdgeListGraph();
            return;
        }
        if (this.getDataModel() instanceof DataSet) {
            DataSet _dataSet = (DataSet)this.getDataModel();
            RegressionDataset regression = new RegressionDataset(_dataSet);
            Node target = _dataSet.getVariable(this.targetName);
            LinkedList<Node> regressors = new LinkedList<Node>();
            for (String regressorName : this.regressorNames) {
                regressors.add(_dataSet.getVariable(regressorName));
            }
            double alpha = this.params.getDouble("alpha", 0.001);
            regression.setAlpha(alpha);
            this.result = regression.regress(target, regressors);
            this.outGraph = regression.getGraph();
        } else if (this.getDataModel() instanceof ICovarianceMatrix) {
            ICovarianceMatrix covariances = (ICovarianceMatrix)this.getDataModel();
            RegressionCovariance regression = new RegressionCovariance(covariances);
            Node target = covariances.getVariable(this.targetName);
            LinkedList<Node> regressors = new LinkedList<Node>();
            for (String regressorName : this.regressorNames) {
                regressors.add(covariances.getVariable(regressorName));
            }
            double alpha = this.params.getDouble("alpha", 0.001);
            regression.setAlpha(alpha);
            this.result = regression.regress(target, regressors);
            this.outGraph = regression.getGraph();
        }
        this.setResultGraph(this.outGraph);
    }

    @Override
    public boolean supportsKnowledge() {
        return false;
    }

    @Override
    public ImpliedOrientation getMeekRules() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setExternalGraph(Graph graph) {
    }

    @Override
    public Graph getExternalGraph() {
        return null;
    }

    @Override
    public String getAlgorithmName() {
        return "Regression";
    }

    public RegressionResult getResult() {
        return this.result;
    }

    public Graph getOutGraph() {
        return this.outGraph;
    }

    @Override
    public List<String> getVariableNames() {
        return this.variableNames;
    }

    @Override
    public List<String> getRegressorNames() {
        return this.regressorNames;
    }

    @Override
    public void setRegressorName(List<String> predictors) {
        this.regressorNames = predictors;
    }

    @Override
    public String getTargetName() {
        return this.targetName;
    }

    @Override
    public void setTargetName(String target) {
        this.targetName = target;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.params == null) {
            throw new NullPointerException();
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Graph getGraph() {
        return this.outGraph;
    }

    @Override
    public List<String> getTriplesClassificationTypes() {
        return new LinkedList<String>();
    }

    @Override
    public List<List<Triple>> getTriplesLists(Node node) {
        return new LinkedList<List<Triple>>();
    }

    @Override
    public Map<String, String> getParamSettings() {
        HashMap<String, String> paramSettings = new HashMap<String, String>();
        paramSettings.put("Algorithm", "Regression");
        return paramSettings;
    }

    @Override
    public void setAllParamSettings(Map<String, String> paramSettings) {
        this.allParamsSettings = paramSettings;
    }

    @Override
    public Map<String, String> getAllParamSettings() {
        return this.allParamsSettings;
    }

    public int getNumModels() {
        return this.numModels;
    }

    public int getModelIndex() {
        return this.modelIndex;
    }

    public String getModelSourceName() {
        return this.modelSourceName;
    }

    public void setModelIndex(int modelIndex) {
        this.modelIndex = modelIndex;
    }

    @Override
    public List<Graph> getGraphs() {
        return null;
    }
}

