/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.data.KnowledgeBoxInput;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetradapp.model.BayesImWrapper;
import edu.cmu.tetradapp.model.BayesPmWrapper;
import edu.cmu.tetradapp.model.BuildPureClustersRunner;
import edu.cmu.tetradapp.model.DagWrapper;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.DirichletBayesImWrapper;
import edu.cmu.tetradapp.model.GeneralizedSemImWrapper;
import edu.cmu.tetradapp.model.GeneralizedSemPmWrapper;
import edu.cmu.tetradapp.model.GraphWrapper;
import edu.cmu.tetradapp.model.KnowledgeBoxModel;
import edu.cmu.tetradapp.model.MeasurementModelWrapper;
import edu.cmu.tetradapp.model.PurifyRunner;
import edu.cmu.tetradapp.model.SemGraphWrapper;
import edu.cmu.tetradapp.model.SemImWrapper;
import edu.cmu.tetradapp.model.SemPmWrapper;
import edu.cmu.tetradapp.model.StandardizedSemImWrapper;
import edu.cmu.tetradapp.model.TimeLagGraphWrapper;
import java.util.List;

public class RequiredGraphModel
extends KnowledgeBoxModel {
    static final long serialVersionUID = 23L;
    private final Graph resultGraph;

    public RequiredGraphModel(BayesPmWrapper wrapper, Parameters params) {
        this((KnowledgeBoxInput)((Object)wrapper), params);
    }

    public RequiredGraphModel(GraphWrapper wrapper, Parameters params) {
        this((KnowledgeBoxInput)wrapper, params);
    }

    public RequiredGraphModel(StandardizedSemImWrapper wrapper, Parameters params) {
        this((KnowledgeBoxInput)wrapper, params);
    }

    public RequiredGraphModel(SemImWrapper wrapper, Parameters params) {
        this((KnowledgeBoxInput)((Object)wrapper), params);
    }

    public RequiredGraphModel(SemPmWrapper wrapper, Parameters params) {
        this((KnowledgeBoxInput)((Object)wrapper), params);
    }

    public RequiredGraphModel(DataWrapper wrapper, Parameters params) {
        this((KnowledgeBoxInput)wrapper, params);
    }

    public RequiredGraphModel(TimeLagGraphWrapper wrapper, Parameters params) {
        this((KnowledgeBoxInput)wrapper, params);
    }

    public RequiredGraphModel(GeneralizedSemImWrapper wrapper, Parameters params) {
        this((KnowledgeBoxInput)wrapper, params);
    }

    public RequiredGraphModel(BayesImWrapper wrapper, Parameters params) {
        this((KnowledgeBoxInput)((Object)wrapper), params);
    }

    public RequiredGraphModel(SemGraphWrapper wrapper, Parameters params) {
        this((KnowledgeBoxInput)wrapper, params);
    }

    public RequiredGraphModel(GeneralizedSemPmWrapper wrapper, Parameters params) {
        this((KnowledgeBoxInput)wrapper, params);
    }

    public RequiredGraphModel(DagWrapper wrapper, Parameters params) {
        this((KnowledgeBoxInput)wrapper, params);
    }

    public RequiredGraphModel(DirichletBayesImWrapper wrapper, Parameters params) {
        this((KnowledgeBoxInput)wrapper, params);
    }

    public RequiredGraphModel(BuildPureClustersRunner wrapper, Parameters params) {
        this((KnowledgeBoxInput)((Object)wrapper), params);
    }

    public RequiredGraphModel(PurifyRunner wrapper, Parameters params) {
        this((KnowledgeBoxInput)wrapper, params);
    }

    public RequiredGraphModel(MeasurementModelWrapper wrapper, Parameters params) {
        this((KnowledgeBoxInput)wrapper, params);
    }

    public RequiredGraphModel(KnowledgeBoxInput input, Parameters params) {
        this(params, input);
    }

    public RequiredGraphModel(Parameters params, KnowledgeBoxInput input) {
        super(new KnowledgeBoxInput[]{input}, params);
        if (input == null) {
            throw new NullPointerException();
        }
        this.resultGraph = input.getResultGraph();
        this.createKnowledge();
        TetradLogger.getInstance().log("info", "Knowledge");
        if (!((Knowledge)params.get("knowledge", new Knowledge())).isEmpty()) {
            TetradLogger.getInstance().log("knowledge", params.get("knowledge", new Knowledge()).toString());
        }
    }

    private void createKnowledge() {
        Knowledge knwl = this.getKnowledge();
        if (knwl == null) {
            return;
        }
        knwl.clear();
        if (this.resultGraph == null) {
            throw new NullPointerException("I couldn't find a parent graph.");
        }
        List<Node> nodes = this.resultGraph.getNodes();
        int numOfNodes = nodes.size();
        for (int i = 0; i < numOfNodes; ++i) {
            for (int j = i + 1; j < numOfNodes; ++j) {
                Edge edge;
                Node n1 = nodes.get(i);
                Node n2 = nodes.get(j);
                if (n1.getName().startsWith("E_") || n2.getName().startsWith("E_") || (edge = this.resultGraph.getEdge(n1, n2)) == null) continue;
                if (edge.isDirected()) {
                    knwl.setRequired(edge.getNode1().getName(), edge.getNode2().getName());
                    continue;
                }
                if (!Edges.isUndirectedEdge(edge)) continue;
                knwl.setRequired(n1.getName(), n2.getName());
                knwl.setRequired(n2.getName(), n1.getName());
            }
        }
    }

    public static RequiredGraphModel serializableInstance() {
        return new RequiredGraphModel(new Parameters(), GraphWrapper.serializableInstance());
    }

    @Override
    public Graph getResultGraph() {
        return this.resultGraph;
    }
}

