/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.LayoutUtil;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.Triple;
import edu.cmu.tetrad.search.ImpliedOrientation;
import edu.cmu.tetrad.search.IndTestType;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.MeekRules;
import edu.cmu.tetrad.search.SampleVcpcFast;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetrad.util.TetradSerializable;
import edu.cmu.tetradapp.model.AbstractAlgorithmRunner;
import edu.cmu.tetradapp.model.DagWrapper;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.GraphSource;
import edu.cmu.tetradapp.model.GraphWrapper;
import edu.cmu.tetradapp.model.IndTestChooser;
import edu.cmu.tetradapp.model.IndTestProducer;
import edu.cmu.tetradapp.model.IndependenceFactsModel;
import edu.cmu.tetradapp.model.KnowledgeBoxModel;
import edu.cmu.tetradapp.model.SemGraphWrapper;
import edu.cmu.tetradapp.model.SemImWrapper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SampleVcpcFastRunner
extends AbstractAlgorithmRunner
implements IndTestProducer {
    static final long serialVersionUID = 23L;
    private SemIm semIm;
    private Set<Edge> sfVcpcAdjacent;
    private Set<Edge> sfVcpcApparent;
    private Set<Edge> sfVcpcDefinite;

    public SampleVcpcFastRunner(DataWrapper dataWrapper, Parameters params) {
        super(dataWrapper, params, null);
    }

    public SampleVcpcFastRunner(DataWrapper dataWrapper, Parameters params, KnowledgeBoxModel knowledgeBoxModel) {
        super(dataWrapper, params, knowledgeBoxModel);
    }

    public SampleVcpcFastRunner(SemImWrapper semImWrapper, Parameters params, DataWrapper dataWrapper) {
        super(dataWrapper, params, null);
        this.semIm = semImWrapper.getSemIm();
    }

    public SampleVcpcFastRunner(Graph graph, Parameters params) {
        super(graph, params);
    }

    public SampleVcpcFastRunner(Graph graph, Parameters params, KnowledgeBoxModel knowledgeBoxModel) {
        super(graph, params, knowledgeBoxModel);
    }

    public SampleVcpcFastRunner(GraphWrapper graphWrapper, Parameters params) {
        super(graphWrapper.getGraph(), params);
    }

    public SampleVcpcFastRunner(GraphWrapper graphWrapper, Parameters params, KnowledgeBoxModel knowledgeBoxModel) {
        super(graphWrapper.getGraph(), params, knowledgeBoxModel);
    }

    public SampleVcpcFastRunner(GraphSource graphWrapper, Parameters params, KnowledgeBoxModel knowledgeBoxModel) {
        super(graphWrapper.getGraph(), params, knowledgeBoxModel);
    }

    public SampleVcpcFastRunner(GraphSource graphWrapper, Parameters params) {
        super(graphWrapper.getGraph(), params);
    }

    public SampleVcpcFastRunner(DagWrapper dagWrapper, Parameters params) {
        super(dagWrapper.getDag(), params);
    }

    public SampleVcpcFastRunner(DagWrapper dagWrapper, Parameters params, KnowledgeBoxModel knowledgeBoxModel) {
        super(dagWrapper.getDag(), params, knowledgeBoxModel);
    }

    public SampleVcpcFastRunner(SemGraphWrapper dagWrapper, Parameters params) {
        super(dagWrapper.getGraph(), params);
    }

    public SampleVcpcFastRunner(SemGraphWrapper dagWrapper, Parameters params, KnowledgeBoxModel knowledgeBoxModel) {
        super(dagWrapper.getGraph(), params, knowledgeBoxModel);
    }

    public SampleVcpcFastRunner(IndependenceFactsModel model, Parameters params) {
        super(model, params, null);
    }

    public SampleVcpcFastRunner(IndependenceFactsModel model, Parameters params, KnowledgeBoxModel knowledgeBoxModel) {
        super(model, params, knowledgeBoxModel);
    }

    public static SampleVcpcFastRunner serializableInstance() {
        return new SampleVcpcFastRunner(Dag.serializableInstance(), new Parameters());
    }

    @Override
    public void execute() {
        Knowledge knowledge = (Knowledge)this.getParams().get("knowledge", new Knowledge());
        Parameters params = this.getParams();
        SampleVcpcFast sfvcpc = new SampleVcpcFast(this.getIndependenceTest());
        sfvcpc.setKnowledge(knowledge);
        sfvcpc.setAggressivelyPreventCycles(this.isAggressivelyPreventCycles());
        sfvcpc.setDepth(params.getInt("depth", -1));
        sfvcpc.setSemIm(this.semIm);
        Graph graph = sfvcpc.search();
        if (this.getSourceGraph() != null) {
            LayoutUtil.arrangeBySourceGraph(graph, this.getSourceGraph());
        } else if (knowledge.isDefaultToKnowledgeLayout()) {
            SearchGraphUtils.arrangeByKnowledgeTiers(graph, knowledge);
        } else {
            LayoutUtil.circleLayout(graph, 200, 200, 150);
        }
        this.setResultGraph(graph);
        this.setSfvcpcFields(sfvcpc);
    }

    @Override
    public IndependenceTest getIndependenceTest() {
        TetradSerializable dataModel = this.getDataModel();
        if (dataModel == null) {
            dataModel = this.getSourceGraph();
        }
        IndTestType testType = (IndTestType)this.getParams().get("indTestType", IndTestType.FISHER_Z);
        return new IndTestChooser().getTest(dataModel, this.getParams(), testType);
    }

    @Override
    public Graph getGraph() {
        return this.getResultGraph();
    }

    @Override
    public List<String> getTriplesClassificationTypes() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("Ambiguous Triples");
        return names;
    }

    @Override
    public List<List<Triple>> getTriplesLists(Node node) {
        ArrayList<List<Triple>> triplesList = new ArrayList<List<Triple>>();
        Graph graph = this.getGraph();
        triplesList.add(GraphUtils.getAmbiguousTriplesFromGraph(node, graph));
        return triplesList;
    }

    public Set<Edge> getAdj() {
        return new HashSet<Edge>(this.sfVcpcAdjacent);
    }

    public Set<Edge> getAppNon() {
        return new HashSet<Edge>(this.sfVcpcApparent);
    }

    public Set<Edge> getDefNon() {
        return new HashSet<Edge>(this.sfVcpcDefinite);
    }

    @Override
    public boolean supportsKnowledge() {
        return true;
    }

    @Override
    public ImpliedOrientation getMeekRules() {
        MeekRules meekRules = new MeekRules();
        meekRules.setAggressivelyPreventCycles(this.isAggressivelyPreventCycles());
        meekRules.setKnowledge((Knowledge)this.getParams().get("knowledge", new Knowledge()));
        return meekRules;
    }

    @Override
    public String getAlgorithmName() {
        return "Sample-VCPC-Fast";
    }

    public SemIm getSemIm() {
        return this.semIm;
    }

    private boolean isAggressivelyPreventCycles() {
        Parameters params = this.getParams();
        if (params != null) {
            return params.getBoolean("aggressivelyPreventCycles", false);
        }
        return false;
    }

    private void setSfvcpcFields(SampleVcpcFast sfvcpc) {
        this.sfVcpcAdjacent = sfvcpc.getAdjacencies();
        this.sfVcpcApparent = sfvcpc.getApparentNonadjacencies();
        this.sfVcpcDefinite = sfvcpc.getDefiniteNonadjacencies();
    }
}

