/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.model;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.LayoutUtil;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.Triple;
import edu.cmu.tetrad.search.ImpliedOrientation;
import edu.cmu.tetrad.search.IndTestType;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.MeekRules;
import edu.cmu.tetrad.search.SampleVcpc;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.sem.SemPm;
import edu.cmu.tetrad.util.Parameters;
import edu.cmu.tetrad.util.TetradSerializable;
import edu.cmu.tetradapp.model.AbstractAlgorithmRunner;
import edu.cmu.tetradapp.model.DagWrapper;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.GraphSource;
import edu.cmu.tetradapp.model.GraphWrapper;
import edu.cmu.tetradapp.model.IndTestChooser;
import edu.cmu.tetradapp.model.IndTestProducer;
import edu.cmu.tetradapp.model.IndependenceFactsModel;
import edu.cmu.tetradapp.model.KnowledgeBoxModel;
import edu.cmu.tetradapp.model.SemGraphWrapper;
import edu.cmu.tetradapp.model.SemImWrapper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SampleVcpcRunner
extends AbstractAlgorithmRunner
implements IndTestProducer {
    static final long serialVersionUID = 23L;
    private IndependenceFactsModel independenceFactsModel;
    private Graph trueGraph;
    private SemPm semPm;
    private SemIm semIm;
    private Set<Edge> sVcpcAdjacent;
    private Set<Edge> sVcpcApparent;
    private Set<Edge> sVcpcDefinite;

    public SampleVcpcRunner(DataWrapper dataWrapper, Parameters params) {
        super(dataWrapper, params, null);
    }

    public SampleVcpcRunner(DataWrapper dataWrapper, Parameters params, KnowledgeBoxModel knowledgeBoxModel) {
        super(dataWrapper, params, knowledgeBoxModel);
    }

    public SampleVcpcRunner(SemImWrapper semImWrapper, Parameters params, DataWrapper dataWrapper) {
        super(dataWrapper, params, null);
        this.semIm = semImWrapper.getSemIm();
    }

    public SampleVcpcRunner(Graph graph, Parameters params) {
        super(graph, params);
    }

    public SampleVcpcRunner(Graph graph, Parameters params, KnowledgeBoxModel knowledgeBoxModel) {
        super(graph, params, knowledgeBoxModel);
    }

    public SampleVcpcRunner(GraphWrapper graphWrapper, Parameters params) {
        super(graphWrapper.getGraph(), params);
    }

    public SampleVcpcRunner(GraphWrapper graphWrapper, Parameters params, KnowledgeBoxModel knowledgeBoxModel) {
        super(graphWrapper.getGraph(), params, knowledgeBoxModel);
    }

    public SampleVcpcRunner(GraphSource graphWrapper, Parameters params, KnowledgeBoxModel knowledgeBoxModel) {
        super(graphWrapper.getGraph(), params, knowledgeBoxModel);
    }

    public SampleVcpcRunner(GraphSource graphWrapper, Parameters params, IndependenceFactsModel model) {
        super(graphWrapper.getGraph(), params);
        this.independenceFactsModel = model;
    }

    public SampleVcpcRunner(GraphSource graphWrapper, Parameters params) {
        super(graphWrapper.getGraph(), params);
    }

    public SampleVcpcRunner(DagWrapper dagWrapper, Parameters params) {
        super(dagWrapper.getDag(), params);
    }

    public SampleVcpcRunner(DagWrapper dagWrapper, Parameters params, KnowledgeBoxModel knowledgeBoxModel) {
        super(dagWrapper.getDag(), params, knowledgeBoxModel);
    }

    public SampleVcpcRunner(SemGraphWrapper dagWrapper, Parameters params) {
        super(dagWrapper.getGraph(), params);
    }

    public SampleVcpcRunner(SemGraphWrapper dagWrapper, Parameters params, KnowledgeBoxModel knowledgeBoxModel) {
        super(dagWrapper.getGraph(), params, knowledgeBoxModel);
    }

    public SampleVcpcRunner(DataWrapper dataWrapper, GraphWrapper graphWrapper, Parameters params) {
        super(dataWrapper, params, null);
        this.trueGraph = graphWrapper.getGraph();
    }

    public SampleVcpcRunner(DataWrapper dataWrapper, GraphWrapper graphWrapper, Parameters params, KnowledgeBoxModel knowledgeBoxModel) {
        super(dataWrapper, params, knowledgeBoxModel);
        this.trueGraph = graphWrapper.getGraph();
    }

    public SampleVcpcRunner(IndependenceFactsModel model, Parameters params) {
        super(model, params, null);
    }

    public SampleVcpcRunner(IndependenceFactsModel model, Parameters params, KnowledgeBoxModel knowledgeBoxModel) {
        super(model, params, knowledgeBoxModel);
    }

    public static SampleVcpcRunner serializableInstance() {
        return new SampleVcpcRunner(Dag.serializableInstance(), new Parameters());
    }

    @Override
    public void execute() {
        Knowledge knowledge = (Knowledge)this.getParams().get("knowledge", new Knowledge());
        SampleVcpc svcpc = new SampleVcpc(this.getIndependenceTest());
        svcpc.setKnowledge(knowledge);
        svcpc.setAggressivelyPreventCycles(this.isAggressivelyPreventCycles());
        svcpc.setDepth(this.getParams().getInt("depth", -1));
        if (this.independenceFactsModel != null) {
            svcpc.setFacts();
        }
        svcpc.setSemIm(this.semIm);
        if (this.semIm != null) {
            svcpc.setSemIm(this.semIm);
        }
        Graph graph = svcpc.search();
        if (this.getSourceGraph() != null) {
            LayoutUtil.arrangeBySourceGraph(graph, this.getSourceGraph());
        } else if (knowledge.isDefaultToKnowledgeLayout()) {
            SearchGraphUtils.arrangeByKnowledgeTiers(graph, knowledge);
        } else {
            LayoutUtil.circleLayout(graph, 200, 200, 150);
        }
        this.setResultGraph(graph);
        this.setSvcpcFields(svcpc);
    }

    @Override
    public IndependenceTest getIndependenceTest() {
        TetradSerializable dataModel = this.getDataModel();
        if (dataModel == null) {
            dataModel = this.getSourceGraph();
        }
        IndTestType testType = (IndTestType)this.getParams().get("indTestType", IndTestType.FISHER_Z);
        return new IndTestChooser().getTest(dataModel, this.getParams(), testType);
    }

    @Override
    public Graph getGraph() {
        return this.getResultGraph();
    }

    @Override
    public List<String> getTriplesClassificationTypes() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("Ambiguous Triples");
        return names;
    }

    @Override
    public List<List<Triple>> getTriplesLists(Node node) {
        ArrayList<List<Triple>> triplesList = new ArrayList<List<Triple>>();
        Graph graph = this.getGraph();
        triplesList.add(GraphUtils.getAmbiguousTriplesFromGraph(node, graph));
        return triplesList;
    }

    public Set<Edge> getAdj() {
        return new HashSet<Edge>(this.sVcpcAdjacent);
    }

    public Set<Edge> getAppNon() {
        return new HashSet<Edge>(this.sVcpcApparent);
    }

    public Set<Edge> getDefNon() {
        return new HashSet<Edge>(this.sVcpcDefinite);
    }

    @Override
    public boolean supportsKnowledge() {
        return true;
    }

    @Override
    public ImpliedOrientation getMeekRules() {
        MeekRules meekRules = new MeekRules();
        meekRules.setAggressivelyPreventCycles(this.isAggressivelyPreventCycles());
        meekRules.setKnowledge((Knowledge)this.getParams().get("knowledge", new Knowledge()));
        return meekRules;
    }

    @Override
    public String getAlgorithmName() {
        return "Sample-VCPC";
    }

    public SemIm getSemIm() {
        return this.semIm;
    }

    public SemPm getSemPm() {
        return this.semPm;
    }

    private boolean isAggressivelyPreventCycles() {
        Parameters params = this.getParams();
        if (params instanceof Parameters) {
            return params.getBoolean("aggressivelyPreventCycles", false);
        }
        return false;
    }

    private void setSvcpcFields(SampleVcpc svcpc) {
        this.sVcpcAdjacent = svcpc.getAdjacencies();
        this.sVcpcApparent = svcpc.getApparentNonadjacencies();
        this.sVcpcDefinite = svcpc.getDefiniteNonadjacencies();
        List<Node> sVcpcNodes = this.getGraph().getNodes();
    }
}

